/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.AbstractItemCollection;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ItemHashSet<E extends IItemHandle>
extends AbstractItemCollection<E>
implements ItemSet<E> {
    private CMode fMode;
    private HashMap<UUID, E> fImpl;

    public ItemHashSet() {
        this(CMode.CURRENT);
    }

    public ItemHashSet(CMode mode) {
        this.fMode = mode;
        this.fImpl = new HashMap();
    }

    public ItemHashSet(int initialCapacity) {
        this(initialCapacity, CMode.CURRENT);
    }

    public ItemHashSet(int initialCapacity, CMode mode) {
        this(new HashMap(initialCapacity), mode);
    }

    public ItemHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, CMode.CURRENT);
    }

    public ItemHashSet(int initialCapacity, float loadFactor, CMode mode) {
        this(new HashMap(initialCapacity, loadFactor), mode);
    }

    public ItemHashSet(ItemCollection<? extends E> collection) {
        this(collection, CMode.CURRENT);
    }

    public ItemHashSet(ItemCollection<? extends E> collection, CMode mode) {
        this(new HashMap((int)((float)collection.size() / 0.75f) + 1), mode);
        this.addAll(collection);
    }

    public ItemHashSet(Collection<? extends E> collection) {
        this(collection, CMode.CURRENT);
    }

    public ItemHashSet(Collection<? extends E> collection, CMode mode) {
        this(new HashMap((int)((float)collection.size() / 0.75f) + 1), mode);
        this.addAll(collection);
    }

    protected ItemHashSet(HashMap<UUID, E> impl, CMode mode) {
        this.fMode = mode;
        this.fImpl = impl;
    }

    @Override
    public CMode getMode() {
        return this.fMode;
    }

    @Override
    public boolean add(E element) {
        UUID key = this.fMode.getUUID(element);
        this.fImpl.put(key, element);
        return true;
    }

    @Override
    public void clear() {
        this.fImpl.clear();
    }

    @Override
    public boolean contains(Object element) {
        UUID key = this.fMode.getUUID(element);
        return this.fImpl.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.fImpl.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.fImpl.values().iterator();
    }

    @Override
    public boolean remove(Object element) {
        UUID key = this.fMode.getUUID(element);
        return this.fImpl.remove(key) != null;
    }

    @Override
    public boolean removeAll(ItemCollection collection) {
        boolean result = false;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(ItemCollection collection) {
        boolean result = false;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            UUID key = this.fMode.getUUID(iter.next());
            if (this.fImpl.containsKey(key)) continue;
            this.fImpl.remove(key);
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        return this.fImpl.size();
    }

    @Override
    public Collection<E> toCollection() {
        return Collections.unmodifiableCollection(this.fImpl.values());
    }

    @Override
    public Set<E> toSet() {
        return new HashSet<E>(this.fImpl.values());
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.fImpl.values().toArray(array);
    }
}

