/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.AbstractItemCollection;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ItemArrayList<E>
extends AbstractItemCollection<E>
implements ItemList<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HASH_FACTOR = 89;
    CMode fMode;
    ArrayList<E> fImpl;

    public ItemArrayList() {
        this(CMode.CURRENT);
    }

    public ItemArrayList(CMode mode) {
        this.fMode = mode;
        this.fImpl = new ArrayList();
    }

    public ItemArrayList(int initialCapacity) {
        this(initialCapacity, CMode.CURRENT);
    }

    public ItemArrayList(int initialCapacity, CMode mode) {
        this.fMode = mode;
        this.fImpl = new ArrayList(initialCapacity);
    }

    public ItemArrayList(Collection<? extends E> collection) {
        this(collection, CMode.CURRENT);
    }

    public ItemArrayList(Collection<? extends E> collection, CMode mode) {
        this.fMode = mode;
        this.fImpl = new ArrayList<E>(collection);
    }

    public ItemArrayList(ItemCollection<? extends E> collection) {
        this(collection, collection.getMode());
    }

    public ItemArrayList(ItemCollection<? extends E> collection, CMode mode) {
        this.fMode = mode;
        this.fImpl = new ArrayList(collection.size());
        ((AbstractItemCollection)this).addAll(collection);
    }

    @Override
    public CMode getMode() {
        return this.fMode;
    }

    public final void add(int index, E element) {
        this.fImpl.add(index, element);
    }

    @Override
    public final boolean add(E element) {
        return this.fImpl.add(element);
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        return this.fImpl.addAll(collection);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> collection) {
        return this.fImpl.addAll(index, collection);
    }

    @Override
    public final boolean addAll(int index, ItemCollection<? extends E> collection) {
        ArrayList<E> copy = new ArrayList<E>(collection.size());
        for (E element : collection) {
            copy.add(element);
        }
        return this.fImpl.addAll(index, copy);
    }

    @Override
    public final void clear() {
        this.fImpl.clear();
    }

    public final ItemArrayList<E> clone() throws CloneNotSupportedException {
        ItemArrayList result = (ItemArrayList)super.clone();
        result.fMode = this.fMode;
        result.fImpl = (ArrayList)this.fImpl.clone();
        return result;
    }

    @Override
    public final boolean contains(Object element) {
        Iterator<E> iter = this.fImpl.iterator();
        while (iter.hasNext()) {
            if (!this.fMode.matches(element, iter.next())) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacity(int minCapacity) {
        this.fImpl.ensureCapacity(minCapacity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ItemArrayList other = (ItemArrayList)o;
        if (this.fMode != other.fMode || this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!this.fMode.equals(this.get(i), other.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public E get(int index) {
        return this.fImpl.get(index);
    }

    @Override
    public int hashCode() {
        return this.fMode.hashCode() * 89 + this.fImpl.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        int index = 0;
        Iterator<E> iter = this.fImpl.iterator();
        while (iter.hasNext()) {
            if (this.fMode.matches(element, iter.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.fImpl.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.fImpl.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        int index = this.size() - 1;
        ListIterator<E> iter = this.fImpl.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (this.fMode.matches(element, iter.previous())) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.fImpl.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.fImpl.listIterator(index);
    }

    @Override
    public Object remove(int index) {
        return this.fImpl.remove(index);
    }

    @Override
    public boolean remove(Object element) {
        int index = 0;
        Iterator<E> iter = this.fImpl.iterator();
        while (iter.hasNext()) {
            if (this.fMode.matches(element, iter.next())) {
                this.fImpl.remove(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        return this.fImpl.set(index, element);
    }

    @Override
    public int size() {
        return this.fImpl.size();
    }

    @Override
    public Object[] toArray() {
        return this.fImpl.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.fImpl.toArray(array);
    }

    @Override
    public Collection<E> toCollection() {
        return this.toList();
    }

    @Override
    public List<E> toList() {
        return new ArrayList<E>(this.fImpl);
    }

    public String toString() {
        return "Mode: " + this.fMode.toString() + "\ncontent: " + this.fImpl.toString();
    }

    public void trimToSize() {
        this.fImpl.trimToSize();
    }
}

