/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;

public class Dates {
    private static final int HOUR = 3600000;
    private static final int HALF_DAY = 43200000;
    private static final int THRESHOLD_TIMEZONE_VALUE = 12;
    private static Hashtable<String, TimeZone> fgTimeZoneMap = new Hashtable();
    private static final TimeZone fgGMTTimezone = Dates.getTimeZone("GMT");

    public static Timestamp setGMTHighNoon(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        Dates.setGMTHighNoon(calendar);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Calendar setGMTHighNoon(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        int timeZoneOffsetInHours = calendar.getTimeZone().getRawOffset() / 3600000;
        if (timeZoneOffsetInHours >= 12) {
            calendar.set(21, calendar.getTimeZone().getOffset(calendar.getTimeInMillis()));
        } else {
            calendar.set(21, 43200000 + calendar.getTimeZone().getOffset(calendar.getTimeInMillis()));
        }
        return calendar;
    }

    public static int compareTo(Date d1, Date d2) {
        if (d1 instanceof Timestamp && d2 != null && d2.getClass().equals(Date.class)) {
            return ((Timestamp)d1).compareTo(new Timestamp(d2.getTime()));
        }
        return d1.compareTo(d2);
    }

    public static int compareTo2(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return Dates.compareTo(d1, d2);
    }

    public static Timestamp toTimestamp(Date d) {
        return d == null || d instanceof Timestamp ? (Timestamp)d : new Timestamp(d.getTime());
    }

    public static boolean compareDatesWithoutTime(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return Dates.compareDatesWithoutTime(cal1, cal2);
    }

    public static boolean compareDatesWithoutTime(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        TimeZone timeZone = fgTimeZoneMap.get(timeZoneId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone((String)timeZoneId);
            fgTimeZoneMap.put(timeZoneId, timeZone);
        }
        return timeZone;
    }

    public static TimeZone getGMTTimezone() {
        return fgGMTTimezone;
    }
}

