/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.IFilter;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Collections2 {
    private Collections2() {
    }

    public static <E, R> List<R> map(List<E> list, IMapping<E, R> mapping) {
        return Collections2.map(list, mapping, false);
    }

    public static <R> List<R> asList(Object[] array) {
        return Arrays.asList(array);
    }

    public static <E, R> List<R> map(List<E> list, IMapping<E, R> mapping, boolean ignoreNull) {
        ArrayList<R> result = new ArrayList<R>();
        Iterator<E> iter = list.iterator();
        while (iter.hasNext()) {
            R value = mapping.map(iter.next());
            if (value == null && ignoreNull) continue;
            result.add(value);
        }
        return result;
    }

    public static <E, R> Map<R, E> createMap(List<E> list, IKeyFactory<E, R> keyFactory) {
        HashMap<R, E> result = new HashMap<R, E>();
        for (E e : list) {
            result.put(keyFactory.createKey(e), e);
        }
        return result;
    }

    public static <E, T> List<T> cast(List<E> list, final Class<T> type) {
        IMapping mapping = new IMapping<E, T>(){

            @Override
            public T map(Object element) {
                if (type.isAssignableFrom(element.getClass())) {
                    return type.cast(element);
                }
                return null;
            }
        };
        return Collections2.map(list, mapping, true);
    }

    public static <E> Collection<E> filter(Collection<E> c, IFilter<E> filter) {
        return new FilteredCollection<E>(c, filter);
    }

    private static class FilteredCollection<E>
    extends AbstractCollection<E> {
        private final IFilter<E> fFilter;
        private final Collection<E> fDelegate;

        public FilteredCollection(Collection<E> collection, IFilter<E> filter) {
            this.fFilter = filter;
            this.fDelegate = collection;
        }

        @Override
        public Iterator<E> iterator() {
            return new FilteredIterator(this.fDelegate.iterator(), this.fFilter);
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            return size;
        }

        @Override
        public boolean add(E element) {
            return this.fDelegate.add(element);
        }

        @Override
        public void clear() {
            this.fDelegate.clear();
        }

        @Override
        public boolean contains(Object element) {
            for (E next : this) {
                if (!(element == null ? next == null : element.equals(next))) continue;
                return true;
            }
            return false;
        }

        public CMode getMode() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.fDelegate.isEmpty();
        }

        @Override
        public boolean remove(Object element) {
            return this.fDelegate.remove(element);
        }

        public Collection<E> toCollection() {
            ArrayList<E> result = new ArrayList<E>(this.size());
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            Iterator<E> iter = this.iterator();
            int index = 0;
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            while (iter.hasNext()) {
                Array.set(result, index++, iter.next());
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('[');
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(']');
            return buffer.toString();
        }
    }

    private static class FilteredIterator<E>
    implements Iterator<E> {
        private final IFilter<E> fFilter;
        private final Iterator<E> fDelegate;
        private E fNext;

        private FilteredIterator(Iterator<E> delegate, IFilter<E> filter) {
            this.fDelegate = delegate;
            this.fFilter = filter;
        }

        @Override
        public boolean hasNext() {
            this.computeNext();
            return this.fNext != null;
        }

        @Override
        public E next() {
            this.computeNext();
            E result = this.fNext;
            this.fNext = null;
            return result;
        }

        /*
         * Unable to fully structure code
         */
        private void computeNext() {
            if (this.fNext != null) {
                return;
            }
            if (this.fDelegate.hasNext()) ** GOTO lbl9
            return;
lbl-1000:
            // 1 sources

            {
                next = this.fDelegate.next();
                if (!this.fFilter.accept(next)) continue;
                this.fNext = next;
                return;
lbl9:
                // 2 sources

                ** while (this.fDelegate.hasNext())
            }
lbl10:
            // 1 sources

        }

        @Override
        public void remove() {
            this.fDelegate.remove();
        }
    }

    public static interface IKeyFactory<E, R> {
        public R createKey(E var1);
    }

    public static interface IMapping<E, R> {
        public R map(E var1);
    }
}

