/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import com.ibm.team.workitem.common.model.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class WorktimeIterator
implements ICalendarIterator {
    private static final TimeZone fgGMTTimeZone = ResourcePlanningUtils.getGMTTimezone();
    private static final Duration DAY = new Duration(86400000L);
    private Timespan fCurrent = null;
    private Instant fCurrentDay = null;
    private Workday[] fWorkdays = new Workday[0];
    private Direction fDirection;
    private final int fTimezoneOffset = ResourcePlanningUtils.getCalendarTimeZoneOffset();

    public WorktimeIterator(Workday[] workdays) {
        boolean isValid = false;
        this.fWorkdays = new Workday[7];
        Workday[] workdayArray = workdays;
        int n = workdays.length;
        int n2 = 0;
        while (n2 < n) {
            Workday workday;
            this.fWorkdays[workday.day - 1] = workday = workdayArray[n2];
            isValid |= workday.workingTime > 0 && workday.endTime > 0;
            ++n2;
        }
        if (!isValid) {
            int workDuration = 86399999;
            Workday[] workdayArray2 = workdays;
            int n3 = workdays.length;
            n = 0;
            while (n < n3) {
                Workday workday = workdayArray2[n];
                workday.workingTime = workDuration;
                workday.endTime = workDuration;
                ++n;
            }
        }
    }

    @Override
    public void reset(Instant earliestStart, boolean forward) {
        this.fDirection = forward ? Direction.Forward : Direction.Backward;
        this.fCurrentDay = earliestStart;
        this.validate();
        if (forward && earliestStart.after(this.fCurrent.getStart())) {
            if (earliestStart.before(this.fCurrent.getEnd())) {
                this.fCurrent = new Timespan(earliestStart.getDate(), this.fCurrent.getEnd());
            } else {
                this.next();
            }
        } else if (!forward && earliestStart.before(this.fCurrent.getEnd())) {
            if (earliestStart.after(this.fCurrent.getStart())) {
                this.fCurrent = new Timespan(this.fCurrent.getStart(), earliestStart.getDate());
            } else {
                this.next();
            }
        }
    }

    @Override
    public Timespan current() {
        return this.fCurrent;
    }

    @Override
    public Timespan next() {
        this.fCurrentDay = this.fDirection.next(this.fCurrentDay, DAY);
        this.validate();
        return this.fCurrent;
    }

    private void validate() {
        Workday workDay;
        Date date = this.fCurrentDay.getDate();
        while (true) {
            Calendar cal = Calendar.getInstance(fgGMTTimeZone);
            cal.setTimeInMillis(date.getTime());
            workDay = this.fWorkdays[cal.get(7) - 1];
            date = this.setHours(cal, 0, 0, 0, 0);
            if (workDay.workingTime > 0) break;
            this.fCurrentDay = this.fDirection.next(this.fCurrentDay, DAY);
            date = this.fCurrentDay.getDate();
        }
        long start = date.getTime() + (long)workDay.endTime - (long)workDay.workingTime;
        long end = date.getTime() + (long)workDay.endTime;
        this.fCurrent = new Timespan(Instant.time(start).getDate(), Instant.time(end).getDate());
    }

    private Date setHours(Calendar cal, int hours, int minutes, int seconds, int millisecs) {
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, millisecs);
        return new Date(cal.getTime().getTime() - (long)this.fTimezoneOffset);
    }

    private static enum Direction {
        Forward{

            @Override
            public Instant next(Instant instant, Duration duration) {
                return instant.plus(duration);
            }
        }
        ,
        Backward{

            @Override
            public Instant next(Instant instant, Duration duration) {
                return instant.minus(duration);
            }
        };


        public abstract Instant next(Instant var1, Duration var2);
    }

    public static class Workday {
        public int day;
        public int endTime;
        public int workingTime;

        public Workday(int _day, int _workingTime, int _endTime) {
            this.day = _day;
            this.endTime = _endTime;
            this.workingTime = _workingTime;
        }
    }
}

