/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import java.util.Date;

public class UnionIterator
implements ICalendarIterator {
    private ICalendarIterator[] fIterators = null;
    private Timespan fCurrent = null;
    private boolean fForward;

    public UnionIterator(ICalendarIterator[] iterators) {
        assert (iterators.length > 0);
        this.fIterators = iterators;
    }

    @Override
    public void reset(Instant earliestStart, boolean forward) {
        this.fForward = forward;
        int i = 0;
        while (i < this.fIterators.length) {
            this.fIterators[i].reset(earliestStart, forward);
            ++i;
        }
        this.fCurrent = this.validate(earliestStart.getDate());
    }

    @Override
    public Timespan current() {
        return this.fCurrent;
    }

    @Override
    public Timespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.validate(this.fForward ? this.fCurrent.getEnd() : this.fCurrent.getStart());
        }
        return this.fCurrent;
    }

    private Timespan validate(Date earliestStart) {
        Date end;
        Date begin;
        do {
            Timespan currentPeriod;
            begin = earliestStart;
            end = null;
            int i = 0;
            while (i < this.fIterators.length) {
                currentPeriod = this.fIterators[i].current();
                if (currentPeriod == null) {
                    return null;
                }
                if (begin == null || (this.fForward ? currentPeriod.getStart().after(begin) : currentPeriod.getEnd().before(begin))) {
                    begin = this.fForward ? currentPeriod.getStart() : currentPeriod.getEnd();
                }
                ++i;
            }
            Date candidateInstant = begin;
            int i2 = 0;
            while (i2 < this.fIterators.length) {
                currentPeriod = this.fIterators[i2].current();
                if (!this.contains(currentPeriod, candidateInstant)) {
                    while (!(this.fForward ? !this.beforeEq(currentPeriod.getEnd(), candidateInstant) : !this.afterEq(currentPeriod.getStart(), candidateInstant))) {
                        currentPeriod = this.fIterators[i2].next();
                        if (currentPeriod != null) continue;
                        return null;
                    }
                    begin = null;
                    end = null;
                }
                if (end == null || (this.fForward ? currentPeriod.getEnd().before(end) : currentPeriod.getStart().after(end))) {
                    end = this.fForward ? currentPeriod.getEnd() : currentPeriod.getStart();
                }
                ++i2;
            }
        } while (begin == null || end == null);
        if (this.fForward) {
            return new Timespan(earliestStart.after(begin) ? earliestStart : begin, end);
        }
        return new Timespan(end, earliestStart.before(begin) ? earliestStart : begin);
    }

    private boolean beforeEq(Date d1, Date d2) {
        return d1.before(d2) || d1.equals(d2);
    }

    private boolean afterEq(Date d1, Date d2) {
        return d1.after(d2) || d1.equals(d2);
    }

    private boolean contains(Timespan timespan, Date date) {
        if (this.fForward) {
            return this.beforeEq(timespan.getStart(), date) && timespan.getEnd().after(date);
        }
        return this.afterEq(timespan.getEnd(), date) && timespan.getStart().before(date);
    }
}

