/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class TimespanIterator
implements ICalendarIterator {
    private Timespan[] fTimespans;
    private Timespan fCurrent = null;
    private int fCurrentIndex = -1;
    private boolean fForward = true;

    public TimespanIterator(Timespan[] timespans) {
        if (timespans.length == 0) {
            this.fTimespans = new Timespan[0];
        } else {
            Timespan current;
            Arrays.sort(timespans, new Comparator<Timespan>(){

                @Override
                public int compare(Timespan left, Timespan right) {
                    return left.getStart().compareTo(right.getStart());
                }
            });
            int i = 1;
            while (i < timespans.length) {
                Timespan previous = timespans[i - 1];
                current = timespans[i];
                if (previous.getStart().equals(current.getStart()) && previous.getEnd().equals(current.getEnd())) {
                    timespans[i] = timespans[i - 1];
                } else if (previous.getEnd().after(current.getStart())) {
                    timespans[i] = previous.getEnd().after(current.getEnd()) ? timespans[i - 1] : new Timespan(previous.getEnd(), current.getEnd());
                }
                ++i;
            }
            ArrayList<Timespan> tempTimeSpans = new ArrayList<Timespan>();
            tempTimeSpans.add(timespans[0]);
            int i2 = 1;
            while (i2 < timespans.length) {
                current = timespans[i2];
                if (current != tempTimeSpans.get(tempTimeSpans.size() - 1)) {
                    tempTimeSpans.add(current);
                }
                ++i2;
            }
            this.fTimespans = new Timespan[tempTimeSpans.size()];
            this.fTimespans = tempTimeSpans.toArray(this.fTimespans);
        }
    }

    public void clear() {
        this.fTimespans = new Timespan[0];
        this.fCurrent = null;
        this.fCurrentIndex = -1;
        this.fForward = true;
    }

    @Override
    public void reset(Instant earliestStart, boolean forward) {
        Timespan current = null;
        int currentIndex = forward ? 0 : this.fTimespans.length - 1;
        while (!(forward ? currentIndex >= this.fTimespans.length : currentIndex < 0)) {
            current = this.fTimespans[currentIndex];
            if (forward) {
                if (this.afterEq(current.getStart(), earliestStart.getDate()) || current.getEnd().after(earliestStart.getDate())) break;
                ++currentIndex;
                continue;
            }
            if (this.beforeEq(current.getEnd(), earliestStart.getDate()) || current.getStart().before(earliestStart.getDate())) break;
            --currentIndex;
        }
        this.fCurrent = forward && currentIndex < this.fTimespans.length ? (earliestStart.after(current.getStart()) ? new Timespan(earliestStart.getDate(), current.getEnd()) : current) : (!forward && currentIndex >= 0 ? (earliestStart.before(current.getEnd()) ? new Timespan(current.getStart(), earliestStart.getDate()) : current) : null);
        this.fCurrentIndex = currentIndex;
        this.fForward = forward;
    }

    @Override
    public Timespan current() {
        return this.fCurrent;
    }

    @Override
    public Timespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.fForward && this.fCurrentIndex < this.fTimespans.length - 1 ? this.fTimespans[++this.fCurrentIndex] : (!this.fForward && this.fCurrentIndex > 0 ? this.fTimespans[--this.fCurrentIndex] : null);
        }
        return this.fCurrent;
    }

    private boolean beforeEq(Date d1, Date d2) {
        return d1.before(d2) || d1.equals(d2);
    }

    private boolean afterEq(Date d1, Date d2) {
        return d1.after(d2) || d1.equals(d2);
    }
}

