/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import java.util.Date;

public class ExclusionIterator
implements ICalendarIterator {
    private static final Instant LOWEST = Instant.time(1L);
    private static final Instant HIGHEST = Instant.time((long)Math.pow(2.0, 52.0));
    private ICalendarIterator fWrapped;
    private boolean fForward = true;
    private Timespan fCurrent = null;

    public ExclusionIterator(ICalendarIterator wrapped) {
        this.fWrapped = wrapped;
    }

    @Override
    public void reset(Instant earliestStart, boolean forward) {
        this.fForward = forward;
        this.fWrapped.reset(earliestStart, forward);
        Timespan wrappedCurrent = this.fWrapped.current();
        Date begin = null;
        Date end = null;
        while (wrappedCurrent != null && wrappedCurrent.contains(earliestStart.getDate())) {
            begin = forward ? wrappedCurrent.getEnd() : wrappedCurrent.getStart();
            wrappedCurrent = this.fWrapped.next();
        }
        if (begin == null) {
            Date date = begin = forward ? LOWEST.getDate() : HIGHEST.getDate();
        }
        if (wrappedCurrent != null) {
            end = forward ? wrappedCurrent.getStart() : wrappedCurrent.getEnd();
        } else {
            Date date = end = forward ? HIGHEST.getDate() : LOWEST.getDate();
        }
        if (forward) {
            Date startDate = earliestStart.after(begin) ? earliestStart.getDate() : begin;
            this.fCurrent = new Timespan(startDate, end);
        } else {
            Date endDate = earliestStart.before(begin) ? earliestStart.getDate() : begin;
            this.fCurrent = new Timespan(end, endDate);
        }
    }

    @Override
    public Timespan current() {
        return this.fCurrent;
    }

    @Override
    public Timespan next() {
        if (this.fCurrent != null) {
            boolean canComputeNext;
            boolean bl = this.fForward ? this.fCurrent.getEnd() != HIGHEST.getDate() : (canComputeNext = this.fCurrent.getStart() != LOWEST.getDate());
            if (canComputeNext) {
                Timespan wrappedLast = this.fWrapped.current();
                Timespan wrappedNext = this.fWrapped.next();
                this.fCurrent = this.fForward ? new Timespan(wrappedLast.getEnd(), wrappedNext != null ? wrappedNext.getStart() : HIGHEST.getDate()) : new Timespan(wrappedNext != null ? wrappedNext.getEnd() : LOWEST.getDate(), wrappedLast.getStart());
            } else {
                this.fCurrent = null;
            }
        }
        return this.fCurrent;
    }
}

