/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.Assignment;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class AssignmentIterator
implements ICalendarIterator {
    private Timespan fCurrent;
    private Timespan fRest;
    private int fCurrentAssignment;
    private int fLastAssignment;
    private Assignment[] fAssignments;
    private ICalendarIterator fWrapper;
    private boolean fForward;

    public AssignmentIterator(ICalendarIterator wrapper, Assignment[] assignments) {
        Assignment current;
        assert (wrapper != null && assignments != null && assignments.length > 0);
        this.fWrapper = wrapper;
        Arrays.sort(assignments, new Comparator<Assignment>(){

            @Override
            public int compare(Assignment left, Assignment right) {
                return left.getStart().compareTo(right.getStart());
            }
        });
        int i = 1;
        while (i < assignments.length) {
            Assignment previous = assignments[i - 1];
            current = assignments[i];
            if (previous.getStart().equals(current.getStart()) && previous.getEnd().equals(current.getEnd())) {
                assignments[i - 1].addAssignment(assignments[i]);
                assignments[i] = assignments[i - 1];
            } else if (previous.getEnd().after(current.getStart())) {
                assignments[i] = previous.getEnd().after(current.getEnd()) ? assignments[i - 1] : new Assignment(previous.getEnd(), current.getEnd(), current.getAssignment());
            }
            ++i;
        }
        ArrayList<Assignment> tempList = new ArrayList<Assignment>();
        tempList.add(assignments[0]);
        int i2 = 1;
        while (i2 < assignments.length) {
            current = assignments[i2];
            if (current != tempList.get(tempList.size() - 1)) {
                tempList.add(current);
            }
            ++i2;
        }
        this.fAssignments = tempList.toArray(new Assignment[tempList.size()]);
        Instant maxDate = assignments[0].getEnd();
        this.fLastAssignment = 0;
        int i3 = 0;
        while (i3 < this.fAssignments.length) {
            Assignment current2 = this.fAssignments[i3];
            if (maxDate.before(current2.getEnd())) {
                maxDate = current2.getEnd();
                this.fLastAssignment = i3;
            }
            ++i3;
        }
    }

    @Override
    public void reset(Instant earliestStart, boolean forward) {
        int index;
        this.fForward = forward;
        this.fCurrentAssignment = index = this.findIndex(earliestStart, forward);
        this.fRest = null;
        Assignment assignment = this.fAssignments[index];
        Instant resetInstant = earliestStart;
        if (forward) {
            if (earliestStart.before(assignment.getStart())) {
                resetInstant = assignment.getStart();
            }
        } else if (earliestStart.after(assignment.getEnd())) {
            resetInstant = assignment.getEnd();
        }
        this.fWrapper.reset(resetInstant, forward);
        this.fCurrent = this.fWrapper.current();
    }

    @Override
    public Timespan current() {
        return this.fCurrent;
    }

    @Override
    public Timespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.computeNext();
        }
        return this.fCurrent;
    }

    public Timespan nextForWorkTime() {
        Timespan tempCurrent = this.next();
        if (!this.fAssignments[this.fLastAssignment].endsAfter(new Instant(tempCurrent.getEnd()))) {
            tempCurrent = null;
        }
        return tempCurrent;
    }

    public double getAssignmentForWorkTime() {
        double tempAssignment = this.getAssignment();
        if (!this.fAssignments[this.fLastAssignment].endsAfter(new Instant(this.fCurrent.getEnd()))) {
            tempAssignment = 0.0;
        }
        return tempAssignment;
    }

    public double getAssignment() {
        return this.fAssignments[this.fCurrentAssignment].getAssignment();
    }

    private Timespan computeNext() {
        Timespan next = this.fRest == null ? this.fWrapper.next() : this.fRest;
        Assignment assignment = this.fAssignments[this.fCurrentAssignment];
        do {
            if (assignment.containsTimespan(next) || this.fForward && this.fCurrentAssignment == this.fAssignments.length - 1 || !this.fForward && this.fCurrentAssignment == 0) {
                this.fRest = null;
                return next;
            }
            if (this.fForward) {
                if (next.getStart().after(assignment.getEnd().getDate()) || next.getStart().equals(assignment.getEnd().getDate())) {
                    this.fCurrentAssignment = this.findIndex(new Instant(next.getStart()), true);
                    assignment = this.fAssignments[this.fCurrentAssignment];
                    this.fWrapper.reset(assignment.getStart(), true);
                    next = this.fWrapper.current();
                    continue;
                }
                Timespan result = new Timespan(next.getStart(), assignment.getEnd().getDate());
                this.fRest = new Timespan(assignment.getEnd().getDate(), next.getEnd());
                return result;
            }
            if (next.getEnd().before(assignment.getStart().getDate())) {
                this.fCurrentAssignment = this.findIndex(new Instant(next.getEnd()), false);
                assignment = this.fAssignments[this.fCurrentAssignment];
                this.fWrapper.reset(assignment.getEnd(), false);
                next = this.fWrapper.current();
                continue;
            }
            Timespan result = new Timespan(assignment.getStart().getDate(), next.getEnd());
            this.fRest = new Timespan(next.getStart(), assignment.getStart().getDate());
            return result;
        } while (this.fCurrentAssignment > 0 && this.fCurrentAssignment < this.fAssignments.length - 1);
        return next;
    }

    private int findIndex(Instant when, boolean forward) {
        int low = 0;
        int high = this.fAssignments.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >> 1;
            Assignment assignment = this.fAssignments[mid];
            if (assignment.contains(when)) {
                return mid;
            }
            if (assignment.getStart().after(when)) {
                high = mid - 1;
                continue;
            }
            assert (assignment.getEnd().compareTo(when) == 0 || assignment.getEnd().before(when));
            low = mid + 1;
        }
        if (forward) {
            return Math.min(low, this.fAssignments.length - 1);
        }
        return Math.max(low - 1, 0);
    }
}

