/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.time;

import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import java.text.SimpleDateFormat;

public class Assignment {
    private static SimpleDateFormat fDateFormat = new SimpleDateFormat("yyyyMMdd");
    private Instant fStartDate;
    private Instant fEndDate;
    private double fAssignment;

    public Assignment(Instant startDate, Instant endDate, double assignement) {
        assert (startDate != null && endDate != null && assignement > 0.0 && assignement <= 1.0);
        this.fStartDate = startDate;
        this.fEndDate = endDate;
        this.fAssignment = assignement;
    }

    public Instant getStart() {
        return this.fStartDate;
    }

    public Instant getEnd() {
        return this.fEndDate;
    }

    public double getAssignment() {
        return this.fAssignment;
    }

    void addAssignment(Assignment assignment) {
        if (this.getStart().equals(assignment.getStart()) && this.getEnd().equals(assignment.getEnd())) {
            this.fAssignment += assignment.getAssignment();
            if (this.fAssignment > 1.0) {
                this.fAssignment = 1.0;
            }
        }
    }

    public boolean endsAfter(Instant instant) {
        return this.fEndDate.after(instant) || this.isSameDay(this.fEndDate, instant);
    }

    public boolean startsBefore(Instant instant) {
        return this.fStartDate.before(instant) || this.isSameDay(this.fStartDate, instant);
    }

    public boolean contains(Instant instant) {
        return this.endsAfter(instant) && this.startsBefore(instant);
    }

    public boolean containsTimespan(Timespan timespan) {
        return this.endsAfter(new Instant(timespan.getStart())) && this.startsBefore(new Instant(timespan.getEnd()));
    }

    private boolean isSameDay(Instant a, Instant b) {
        return fDateFormat.format(a.getDate()).equals(fDateFormat.format(b.getDate()));
    }
}

