/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.setup.builders;

import com.ibm.team.apt.internal.common.setup.builders.IPlanBuilderContext;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;

public class WikiBuilder
extends AbstractArtifactBuilder<IWikiPage> {
    private static final ValueKey<String> WIKI_ID = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".wikiId");
    private static final ValueKey<IItemHandle> OWNER = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".owner");
    private static final ValueKey<Boolean> VISIBLE = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".visible");
    private static final ValueKey<String> NAME = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".name");
    private static final ValueKey<IContributorHandle> CREATOR = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".creator");
    private static final ValueKey<String> CONTENT = new ValueKey(String.valueOf(WikiBuilder.class.getName()) + ".content");
    private boolean fIsDefaultWiki;

    public WikiBuilder(IPlanBuilderContext buildContext) {
        super((IArtifactBuilderContext)buildContext);
    }

    public WikiBuilder wikiID(String id) {
        this.setBuilderValue(WIKI_ID, id);
        return this;
    }

    public WikiBuilder owner(IItemHandle owner) {
        this.setBuilderValue(OWNER, owner);
        return this;
    }

    public WikiBuilder visible(boolean visible) {
        this.setBuilderValue(VISIBLE, visible);
        return this;
    }

    public WikiBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public WikiBuilder creator(IContributorHandle creator) {
        this.setBuilderValue(CREATOR, creator);
        return this;
    }

    public WikiBuilder content(String text) {
        this.setBuilderValue(CONTENT, text);
        return this;
    }

    protected WikiBuilder isDefaultWiki(boolean isDefaultWiki) {
        this.fIsDefaultWiki = isDefaultWiki;
        return this;
    }

    protected IPlanBuilderContext getContext() {
        return (IPlanBuilderContext)super.getContext();
    }

    protected IWikiPage doBuild(BuildContext context) {
        return this.setFields((IWikiPage)this.artifact(IWikiPage.ITEM_TYPE), context);
    }

    protected IWikiPage doSave(BuildContext context) throws TeamRepositoryException {
        IWikiPage page = this.doBuild(context);
        page.setContent(this.artifactExists() ? page.getContent() : this.getContext().storeContent("text/plain", "UTF-8", ((String)this.getBuilderValue(CONTENT, "default content")).getBytes()));
        IContributorHandle creator = this.getCreator(context);
        if (creator != null) {
            page.setCreator(creator);
            page = ((IWikiService)this.getContext().getLibrary(IWikiService.class)).savePage(page);
        } else if (!this.fIsDefaultWiki) {
            throw new TeamRepositoryException("Cannot create wiki with specifying a creator or a process area with contribtuors");
        }
        return page;
    }

    private IWikiPage setFields(IWikiPage page, BuildContext context) {
        page.setWikiID((String)this.chooseValue(WIKI_ID, page.getWikiID(), "overview"));
        page.setVisible((Boolean)this.chooseValue(VISIBLE, page.isVisible(), true));
        page.setName((String)this.chooseValue(NAME, page.getName(), "Wiki Page " + UUID.generate().getUuidValue()));
        page.setOwner((IItemHandle)this.chooseValue(context, OWNER, WikiBuilderContext.WIKI_OWNER, page.getOwner()));
        return page;
    }

    private IContributorHandle getCreator(BuildContext context) throws TeamRepositoryException {
        IContributorHandle creator = (IContributorHandle)this.getBuilderValue(CREATOR, this.artifactExists() ? ((IWikiPage)this.getExistingArtifact()).getCreator() : null);
        if (creator == null) {
            creator = context.isPropertySet(WikiBuilderContext.WIKI_PROCESS_AREA) ? this.getContributor((IProcessAreaHandle)context.getProperty(WikiBuilderContext.WIKI_PROCESS_AREA)) : null;
        }
        return creator;
    }

    private IContributorHandle getContributor(IProcessAreaHandle owner) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        IProcessArea processArea = (IProcessArea)auditableCommon.resolveAuditable((IAuditableHandle)owner, ItemProfile.PROCESS_AREA_DEFAULT, null);
        IContributorHandle[] contributors = processArea.getMembers();
        return contributors.length != 0 ? contributors[0] : null;
    }

    public static final class WikiBuilderContext {
        public static final ValueKey<IItemHandle> WIKI_OWNER = new ValueKey(String.valueOf(WikiBuilderContext.class.getName()) + ".owner");
        public static final ValueKey<IProcessAreaHandle> WIKI_PROCESS_AREA = new ValueKey(String.valueOf(WikiBuilderContext.class.getName()) + ".creator");

        private WikiBuilderContext() {
        }
    }
}

