/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.setup.builders;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.PlanConfigurationStore;
import com.ibm.team.apt.internal.common.plantype.PlanTypeIds;
import com.ibm.team.apt.internal.common.rcp.IIterationPlanService;
import com.ibm.team.apt.internal.common.setup.builders.IPlanBuilderContext;
import com.ibm.team.apt.internal.common.setup.builders.WikiBuilder;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilderContext;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PlanBuilder
extends AbstractArtifactBuilder<IIterationPlanRecord> {
    public static final String NO_WIKI = "__NO_WIKI";
    private static final ValueKey<String> NAME = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".name");
    private static final ValueKey<String> TYPE = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".type");
    private static final ValueKey<IIterationHandle> ITERATION = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".iteration");
    private static final ValueKey<IProcessAreaHandle> OWNER = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".owner");
    private static final ValueKey<String> AUXILIARY_DATA = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".auxiliaryData");
    private static final ValueKey<Boolean> INCLUDE_ALL_ITEMS = new ValueKey(String.valueOf(PlanBuilder.class.getName()) + ".includeAllItems");
    private boolean fWikiSet = false;
    private boolean fNoWiki = false;

    public PlanBuilder(IPlanBuilderContext context) {
        super((IArtifactBuilderContext)context);
    }

    public PlanBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public PlanBuilder type(String type) {
        this.setBuilderValue(TYPE, type);
        return this;
    }

    public PlanBuilder owner(IProcessAreaHandle owner) {
        this.setBuilderValue(OWNER, owner);
        return this;
    }

    public PlanBuilder iteration(IIterationHandle iteration) {
        this.setBuilderValue(ITERATION, iteration);
        return this;
    }

    public PlanBuilder includeAllitems(Boolean includeAllItems) {
        this.setBuilderValue(INCLUDE_ALL_ITEMS, includeAllItems);
        return this;
    }

    public PlanBuilder planNotes(String planNotes) {
        if (NO_WIKI.equals(planNotes)) {
            this.fNoWiki = true;
        } else {
            this.planNotes(new WikiBuilder(this.getContext()).content(planNotes));
        }
        return this;
    }

    public PlanBuilder planNotes(WikiBuilder planNotes) {
        this.fWikiSet = true;
        this.addChildBuilder(new IArtifactBuilder[]{planNotes});
        return this;
    }

    public PlanBuilder auxiliaryData(String data) {
        this.setBuilderValue(AUXILIARY_DATA, data);
        return this;
    }

    public PlanBuilder workItems(WorkItemBuilder ... workItemBuilders) {
        WorkItemBuilder[] workItemBuilderArray = workItemBuilders;
        int n = workItemBuilders.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemBuilder workItemBuilder = workItemBuilderArray[n2];
            this.workItem(workItemBuilder);
            ++n2;
        }
        return this;
    }

    public PlanBuilder workItem(WorkItemBuilder workItemBuilder) {
        this.addChildBuilder(new IArtifactBuilder[]{workItemBuilder});
        return this;
    }

    protected IPlanBuilderContext getContext() {
        return (IPlanBuilderContext)super.getContext();
    }

    protected IIterationPlanRecord doBuild(BuildContext context) {
        IIterationPlanRecord plan = (IIterationPlanRecord)this.artifact(IIterationPlanRecord.ITEM_TYPE);
        plan.setOwner((IProcessAreaHandle)this.chooseValue(OWNER, plan.getOwner()));
        plan.setIteration((IIterationHandle)this.chooseValue(ITERATION, plan.getIteration()));
        plan.setName((String)this.chooseValue(NAME, plan.getName(), "Plan " + UUID.generate()));
        plan.setPlanType((String)this.chooseValue(TYPE, plan.getPlanType(), PlanTypeIds.FALLBACK_PLAN_ID));
        if (!this.fWikiSet && !this.fNoWiki) {
            this.addChildBuilder(new IArtifactBuilder[]{new WikiBuilder(this.getContext()).isDefaultWiki(true)});
        }
        for (IArtifactBuilder childBuilder : this.getChildBuilders()) {
            childBuilder.build(new BuildContext(context).setProperty(BuildContext.ITERATION, (Object)plan.getIteration()).setProperty(WikiBuilder.WikiBuilderContext.WIKI_OWNER, (Object)plan));
        }
        return plan;
    }

    protected IIterationPlanRecord doSave(BuildContext saveContext) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        IIterationPlanService iterationPlanService = (IIterationPlanService)this.getContext().getLibrary(IIterationPlanService.class);
        IIterationPlanRecord plan = this.doBuild(saveContext);
        if (this.isBuilderValueSet(AUXILIARY_DATA)) {
            IContent content = this.getContext().storeContent("text/plain", "UTF-8", ((String)this.getBuilderValue(AUXILIARY_DATA)).getBytes());
            plan.setAuxiliaryData(content);
        } else {
            IStore store = IStore.FACTORY.createStore(plan.getAuxiliaryData(), auditableCommon, (IProgressMonitor)new NullProgressMonitor());
            PlanConfigurationStore planConfigurationStore = new PlanConfigurationStore(store);
            planConfigurationStore.setRankingMode("explicit");
            if (this.isBuilderValueSet(INCLUDE_ALL_ITEMS)) {
                planConfigurationStore.setAlwaysLoadExecutionItems((Boolean)this.getBuilderValue(INCLUDE_ALL_ITEMS));
            }
            IContent content = this.getContext().storeContent("text/plain", "UTF-8", store.toString().getBytes());
            plan.setAuxiliaryData(content);
        }
        IProcessAreaHandle owner = plan.getOwner();
        plan = iterationPlanService.save(owner, plan, new IWikiPage[0]).getIterationPlanRecord();
        BuildContext childContext = this.getChildContext(saveContext, owner, plan, auditableCommon);
        for (IArtifactBuilder childBuilder : this.getChildBuilders()) {
            childBuilder.save(childContext);
        }
        return plan;
    }

    private BuildContext getChildContext(BuildContext saveContext, IProcessAreaHandle owner, IIterationPlanRecord iterationPlanRecord, IAuditableCommon auditableCommon) throws TeamRepositoryException {
        IProjectAreaHandle projectArea;
        BuildContext childContext = new BuildContext(saveContext);
        if (owner instanceof ITeamAreaHandle) {
            ITeamArea teamArea = owner.hasFullState() ? (ITeamArea)owner.getFullState() : (ITeamArea)auditableCommon.resolveAuditable((IAuditableHandle)owner, ItemProfile.createFullProfile((IItemType)ITeamArea.ITEM_TYPE), null);
            childContext.setProperty(BuildContext.TEAM_AREA, (Object)teamArea);
            projectArea = teamArea.getProjectArea();
        } else if (owner instanceof IProjectAreaHandle) {
            projectArea = (IProjectAreaHandle)owner;
        } else {
            throw new IllegalArgumentException("Plan owner property needs to be either an ITeamAreaHandle or an IProjectAreaHandle");
        }
        return childContext.setProperty(BuildContext.PROJECT_AREA, (Object)((IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.PROJECT_AREA_FULL, null))).setProperty(BuildContext.ITERATION, (Object)iterationPlanRecord.getIteration()).setProperty(WorkItemBuilderContext.CATEGORY, (Object)this.getCategory(owner, projectArea)).setProperty(WikiBuilder.WikiBuilderContext.WIKI_OWNER, (Object)iterationPlanRecord).setProperty(WikiBuilder.WikiBuilderContext.WIKI_PROCESS_AREA, (Object)owner);
    }

    private ICategoryHandle getCategory(IProcessAreaHandle owner, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        IWorkItemCommon workItemServer = (IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class);
        ICategory unassignedCategory = workItemServer.findUnassignedCategory(projectArea, ICategory.SMALL_PROFILE, null);
        List categories = workItemServer.findCategoriesOfProcessArea(owner, ICategory.FULL_PROFILE, null);
        for (ICategory category : categories) {
            if (category.sameItemId((IItemHandle)unassignedCategory)) continue;
            return category;
        }
        return unassignedCategory;
    }
}

