/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.progress;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.common.util.Html;
import java.util.Map;

public class ProgressBarMarkupStrategy {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private static final String GENERAL_BAR_CSS = "__general_bar_css";
    private IProgressInformation fInput;
    private IProgressLabelProvider fLabelProvider;

    public ProgressBarMarkupStrategy(IProgressLabelProvider labelProvider, IProgressInformation input) {
        this.fInput = input;
        this.fLabelProvider = labelProvider;
    }

    public void generateHead(Map<String, String> head) {
        if (head.containsKey(GENERAL_BAR_CSS)) {
            return;
        }
        StringBuilder css = new StringBuilder();
        Html.STYLE.open(css, new Html.Attribute("type", "text/css"));
        css.append("body {overflow: auto;}\n");
        css.append("table {").append(ProgressBarMarkupStrategy.getFont()).append("}");
        css.append("h5 {margin-bottom: 0px;}");
        css.append("a:link {color: #0000FF; text-decoration: none;}a:visited {color: #0000FF; text-decoration: none;}a:hover {color: #000080; text-decoration: underline;}");
        css.append(".noWorkEstimatedLabel {width: 100%; font-size: 75%; border:1pt solid #cccccc; overflow:hidden; position:relative; z-index:0; background-color: #ffffff; text-align: center; vertical-align: middle; color: gray;}div {margin: 0pt; padding: 0pt;}.bar {padding: 1px; background-color:white; border:1pt solid #cccccc; height: 0.8em; clear: both; width: 100%;}.barContainer {background-color:white; height: 100%; width: 100%; overflow:hidden; position:relative; z-index:0;}.barContainer .barPart {overflow:hidden; position:absolute; z-index:-1;}.barContainer .barPartTitle {bottom:0pt; height:auto; left:0pt; margin:0pt; overflow:hidden; padding:0pt; position:absolute; right:0pt; top:0pt; width:100%;}.barContainer .completed .barPartTitle {border-right: 1pt solid white;}.barContainer .completed {left: 0pt;background-color: #9ebf9e;}.barContainer .difference.none {display: none;}.barContainer .estimated.difference.ahead {background-color: #b9d6b9;}.barContainer .estimated.difference.behind {background-color: #de9c9c;}.barContainer .notEstimated { top: 0pt; background-color: #e0e0e0;}.barContainer .estimated { bottom: 0pt;}.barContainer .open { right: 0pt; background-color: #ffffff;}");
        Html.STYLE.close(css);
        head.put(GENERAL_BAR_CSS, css.toString());
    }

    public static String getFont() {
        return ProgressBarMarkupStrategy.getFont("'IBM Plex Sans', 'Helvetica Neue', Arial, sans-serif", 0);
    }

    public static String getFont(String name, int style) {
        StringBuffer cssBuf = new StringBuffer();
        if (name != null) {
            cssBuf.append(" font-family: ").append(name).append(';');
        }
        cssBuf.append(" font-size: 9pt;");
        if ((style & 1) != 0) {
            cssBuf.append(" font-weight: bold;");
        } else {
            cssBuf.append(" font-weight: normal;");
        }
        if ((style & 2) != 0) {
            cssBuf.append(" font-style: italic;");
        }
        return cssBuf.toString();
    }

    public <T extends CharSequence & Appendable> void generateBody(T body) {
        String message = this.fLabelProvider.getMessage(this.fInput);
        if (message != null) {
            Html.DIV.open(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("noWorkEstimatedLabel"), new Html.Attribute("style", "font-family: 'IBM Plex Sans', 'Helvetica Neue', Arial, sans-serif; font-size: 0.6em; padding: 0.2em 0 0.3em 0;")});
            Html.append(body, message);
            Html.DIV.close(body);
        } else {
            double direction = this.fLabelProvider.getDeltaDirection(this.fInput);
            double fillLevel = this.fLabelProvider.getFillLevel(this.fInput);
            double[] doneRange = this.fLabelProvider.getDoneRange(this.fInput);
            double[] projectionRange = this.fLabelProvider.getProjectionRange(this.fInput);
            boolean isDone = doneRange[1] == 1.0;
            boolean canProject = !isDone && projectionRange[0] != -1.0 && projectionRange[1] != -1.0;
            int heightEstimated = (int)this.round(100.0 * fillLevel);
            int heightNotEstimated = 100 - heightEstimated;
            StringBuilder buffer = new StringBuilder();
            String heightAttr = "height: ";
            String widthAttr = "width: ";
            String leftAttr = "left: ";
            String invisible = "visible: none;";
            String percent = "%;";
            buffer.setLength(0);
            buffer.append(heightAttr).append(heightNotEstimated).append(percent);
            String cssHeightNotEstimated = buffer.toString();
            buffer.setLength(0);
            buffer.append(heightAttr).append(heightEstimated).append(percent);
            String cssHeightEstimated = buffer.toString();
            int widthProjection = (int)this.round(100.0 * projectionRange[1]);
            buffer.setLength(0);
            buffer.append(widthAttr).append(this.convertToString(widthProjection)).append(percent);
            if (isDone || !canProject) {
                buffer.append(invisible);
            }
            String cssWidthDifference = buffer.toString();
            int widthCompleted = (int)this.round(100.0 * doneRange[1]);
            buffer.setLength(0);
            buffer.append(widthAttr).append(this.convertToString(widthCompleted)).append(percent);
            String cssWidthCompleted = buffer.toString();
            int widthOpen = 100 - (!canProject ? 100 : widthCompleted + widthProjection);
            buffer.setLength(0);
            buffer.append(widthAttr).append(widthOpen).append(percent);
            if (isDone) {
                buffer.append(invisible);
            }
            String cssWidthOpen = buffer.toString();
            buffer.setLength(0);
            buffer.append(leftAttr).append(widthCompleted).append(percent);
            String cssLeftDifference = buffer.toString();
            StringBuilder style = new StringBuilder();
            Html.DIV.open(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("bar")});
            Html.DIV.open(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barContainer")});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart notEstimated completed"), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthCompleted).toString())});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart notEstimated difference"), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthDifference).append(cssLeftDifference).toString())});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart notEstimated open"), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightNotEstimated).append(cssWidthOpen).toString())});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart estimated completed"), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightEstimated).append(cssWidthCompleted).toString())});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart estimated difference " + (direction > 0.0 ? "ahead" : (direction < 0.0 ? "behind" : "none"))), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightEstimated).append(cssWidthDifference).append(cssLeftDifference).toString())});
            style.setLength(0);
            ProgressBarMarkupStrategy.renderProgressBarPart(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPart estimated open"), ProgressBarMarkupStrategy.styleAttribute(style.append(cssHeightEstimated).append(cssWidthOpen).toString())});
            Html.DIV.close(body);
            Html.DIV.close(body);
        }
    }

    private static <T extends Appendable & CharSequence> void renderProgressBarPart(T body, Html.Attribute ... attributes) {
        Html.DIV.open(body, attributes);
        Html.DIV.open(body, new Html.Attribute[]{ProgressBarMarkupStrategy.classAttribute("barPartTitle")});
        Html.DIV.close(body);
        Html.DIV.close(body);
    }

    private static Html.Attribute classAttribute(String value) {
        return new Html.Attribute("class", value);
    }

    private static Html.Attribute styleAttribute(String value) {
        return new Html.Attribute("style", value);
    }

    private double round(double value) {
        double fac = Math.pow(10.0, 2.0);
        boolean neg = value < 0.0;
        value = Math.abs(value);
        double result = (double)Math.round(value * fac) / fac;
        double fraction = result - Math.floor(result);
        result -= fraction;
        if (fraction <= 0.125) {
            fraction = 0.0;
        } else if (fraction > 0.125 && fraction <= 0.25) {
            fraction = 0.25;
        } else if (fraction > 0.25 && fraction <= 0.5) {
            fraction = 0.5;
        } else if (fraction > 0.5 && fraction <= 0.75) {
            fraction = 0.75;
        } else if (fraction > 0.75) {
            fraction = 1.0;
        }
        return (result + fraction) * (double)(neg ? -1 : 1);
    }

    private String convertToString(double value) {
        if (Math.floor(value) == value) {
            return Long.toString(new Double(value).longValue());
        }
        return Double.toString(value);
    }
}

