/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.AuditablePlanningItemStore;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessConfigurationNodeProvider
implements INodeProvider {
    private static final IProcessConfigurationData NULL_MARKER = new IProcessConfigurationData(){

        public String getId() {
            return null;
        }

        public IProcessConfigurationElement[] getElements() {
            return null;
        }

        public String getCharacterData() {
            return null;
        }
    };
    private Map<String, IProcessConfigurationData> fCache = new HashMap<String, IProcessConfigurationData>();
    private final IPlanningItemStore.IPlanningProcessStore fPlanningProcessStore;
    public static String[] PROCESS_PROVIDER_PROFILE = new String[]{ProcessPackage.eINSTANCE.getProjectArea_InternalProcessProvider().getName()};
    public static ItemProfile<IProjectArea> PROJECT_CHECK_PROFILE = ItemProfile.PROJECT_AREA_DEFAULT.createExtension(PROCESS_PROVIDER_PROFILE);

    public ProcessConfigurationNodeProvider(IPlanningItemStore.IPlanningProcessStore processStore) {
        this.fPlanningProcessStore = processStore;
    }

    public ProcessConfigurationNodeProvider(IAuditableCommonProcess process) {
        this.fPlanningProcessStore = new AuditablePlanningItemStore.AuditablePlanningProcessStore(process);
    }

    @Override
    public INode getNode(String configurationDataPoint, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.fPlanningProcessStore.getProjectArea();
        IProcessConfigurationData data = this.fCache.get(configurationDataPoint);
        if (data == null) {
            data = this.fPlanningProcessStore.findProcessConfiguration(configurationDataPoint, monitor);
            this.fCache.put(configurationDataPoint, data == null ? NULL_MARKER : data);
        }
        if (data == NULL_MARKER) {
            data = null;
        }
        if (data != null) {
            return INode.FACTORY.createNode(data, this, projectArea.getItemId(), ProcessConfigurationNodeProvider.getProjectAreaETag(this.fPlanningProcessStore, monitor));
        }
        return null;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fPlanningProcessStore.getProjectArea();
    }

    public static Object getProjectAreaETag(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle processProviderHandle;
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, PROJECT_CHECK_PROFILE, monitor);
        Object result = projectArea.getStateId();
        if (projectArea instanceof ProjectArea && (processProviderHandle = ((ProjectArea)projectArea).getProcessProvider()) != null) {
            IProcessArea processProvider = (IProcessArea)auditableCommon.resolveAuditable((IAuditableHandle)processProviderHandle, PROJECT_CHECK_PROFILE, monitor);
            result = String.valueOf(projectArea.getStateId().getUuidValue()) + "@" + processProvider.getStateId().getUuidValue();
        }
        return result;
    }

    public static Object getProjectAreaETag(IPlanningItemStore.IPlanningProcessStore processStore, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = processStore.getProjectArea();
        Object result = projectArea.getStateId();
        IProjectAreaHandle processProviderHandle = ((ProjectArea)projectArea).getProcessProvider();
        if (processProviderHandle != null) {
            IProcessArea processProvider = (IProcessArea)processStore.getPlanningItemStore().fetchItem((IItemHandle)processProviderHandle, new String[]{IItem.STATE_ID_PROPERTY}, monitor);
            result = String.valueOf(projectArea.getStateId().getUuidValue()) + "@" + processProvider.getStateId().getUuidValue();
        }
        return result;
    }
}

