/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ElementPath;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.Messages;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.process.ValueComputer;
import com.ibm.team.apt.internal.common.util.Empty;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

class NodeBasedValueComputer
extends ValueComputer {
    private INode fNode;
    private INodeProvider fProvider;
    private IProgressMonitor fMonitor;
    private List<IConfigurationElementMassage<?>> fMassages;
    private final int fFlags;

    NodeBasedValueComputer(INode node, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, int flags, IProgressMonitor monitor) {
        this.fNode = node;
        this.fProvider = provider;
        this.fMassages = massages;
        this.fFlags = flags;
        this.fMonitor = monitor;
    }

    @Override
    public HashMap<String, Object> computeValues(Class<?> type) throws TeamRepositoryException {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>((int)((float)(type.getMethods().length / 2) * 1.3f));
            Iterator<Method> iter = this.getterIterator(type);
            while (iter.hasNext()) {
                this.computeValue(values, iter.next(), this.fNode);
            }
            HashMap<String, Object> hashMap = values;
            return hashMap;
        }
        finally {
            this.dispose();
        }
    }

    private void dispose() {
        this.fNode = null;
        this.fProvider = null;
        this.fMassages = null;
        this.fMonitor = null;
    }

    private void computeValue(Map<String, Object> values, Method method, INode element) throws TeamRepositoryException {
        Path annotation = method.getAnnotation(Path.class);
        if (annotation == null) {
            return;
        }
        String key = ConfigurationElements.key(annotation);
        ElementPath path = ElementPath.valueOf(key);
        List<String> segments = path.getSegments();
        String attribute = path.getAttribute();
        List<INode> elements = ConfigurationElements.select(element, segments);
        Class<?> returnType = method.getReturnType();
        if (!returnType.isArray() && (elements.size() > 1 || elements.size() == 0 && Empty.is(annotation.defaultDefinition()))) {
            this.checkStrict("Can't find data element for {0}@{1}. Expected one element, but found {3}.", annotation, method.getName(), elements);
        }
        if (returnType.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int optionalElement = 0;
            for (INode node : elements) {
                try {
                    list.add(this.toReturnValue(null, method, attribute, node));
                }
                catch (TeamRepositoryException e) {
                    if (this.isOptional(annotation) || this.isOptional(node)) {
                        ++optionalElement;
                        continue;
                    }
                    throw e;
                }
            }
            if (!this.checkSize(element, segments, list) && !this.isOptional(annotation)) {
                throw new TeamRepositoryException("Wrong result size.");
            }
            Object array = Array.newInstance(returnType.getComponentType(), list.size());
            ListIterator<Object> iter = list.listIterator();
            while (iter.hasNext()) {
                Array.set(array, iter.nextIndex(), iter.next());
            }
            values.put(key, array);
            if (optionalElement > 0 && segments.size() > 1 && !this.checkSize(element, segments, list) && !this.isOptional(annotation)) {
                this.checkStrict("Can't find data for {0}@{1}.", annotation, method.getName());
            }
        } else {
            values.put(key, this.toReturnValue(values, method, attribute, elements.isEmpty() ? null : elements.iterator().next()));
        }
    }

    private boolean checkSize(INode element, List<String> segments, ArrayList<Object> list) {
        List<INode> rootElements = ConfigurationElements.select(element, Collections.singletonList(segments.get(0)));
        if (rootElements == null || rootElements.size() != 1) {
            return true;
        }
        String size = rootElements.get(0).getAttribute("size");
        if (size == null) {
            return true;
        }
        Matcher matcher = Pattern.compile("\\{(\\d{1}),\\}").matcher(size);
        if (matcher.matches()) {
            int min = Integer.parseInt(matcher.group(1));
            return list.size() >= min;
        }
        if ("*".equals(size)) {
            return true;
        }
        if ("+".equals(size)) {
            return list.size() >= 1;
        }
        if ("?".equals(size)) {
            return list.size() <= 1;
        }
        return true;
    }

    private void checkStrict(String msg, Object ... bindings) throws TeamRepositoryException {
        if ((this.fFlags & 8) != 0) {
            throw new TeamRepositoryException(NLS.bind((String)msg, (Object[])bindings, (Object[])new Object[0]));
        }
    }

    private boolean isOptional(Path annotation) {
        return (annotation.flags() & 1) != 0;
    }

    private boolean isOptional(INode element) {
        String optional = element.getAttribute("optional");
        return optional != null && Boolean.parseBoolean(optional);
    }

    private HashMap<String, Object> getAdditionalReferenceAttributes(Class<?> returnType, INode element) {
        HashMap<String, String> storedReferenceAttributes = null;
        Path annotations = returnType.getAnnotation(Path.class);
        if (annotations != null && annotations.referenceAttributes().length > 0) {
            storedReferenceAttributes = new HashMap<String, String>();
            String[] referenceAttributes = returnType.getAnnotation(Path.class).referenceAttributes();
            int i = 0;
            while (i < referenceAttributes.length) {
                String storedAttribute = element.getAttribute(referenceAttributes[i]);
                if (storedAttribute != null) {
                    storedReferenceAttributes.put(referenceAttributes[i], storedAttribute);
                }
                ++i;
            }
        }
        return storedReferenceAttributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toReturnValue(Map<String, Object> values, Method method, String attribute, INode element) throws TeamRepositoryException {
        Path path = method.getAnnotation(Path.class);
        Class<?> returnType = method.getReturnType().isArray() ? method.getReturnType().getComponentType() : method.getReturnType();
        String value = null;
        if (element == null) {
            if (!Empty.isNot(path.defaultDefinition())) return ConfigurationElements.defaultValue(returnType);
            value = path.defaultDefinition();
        } else {
            value = element.getAttribute(attribute);
        }
        if (value == null && !ConfigurationElements.isConfigurationDataType(returnType)) {
            return ConfigurationElements.defaultValue(returnType);
        }
        HashMap<String, Object> storedReferenceAttributes = this.getAdditionalReferenceAttributes(returnType, element);
        if (ConfigurationElements.isConfigurationDataType(returnType)) {
            Object result = null;
            if (Empty.is(path.to())) {
                List<?> list = ConfigurationElementFactory.allInstances(returnType, element, this.fProvider);
                result = list.isEmpty() ? ConfigurationElements.defaultValue(returnType) : list.get(0);
            } else {
                if (this.fProvider instanceof ICachingSupport) {
                    if (value == null) {
                        return ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
                    }
                    result = ((ICachingSupport)this.fProvider).get(value, returnType);
                }
                if (path.refines()) {
                    result = null;
                }
                if (result == null) {
                    int flags = 8 | (path.refines() ? 16 : 0);
                    result = ConfigurationElementFactory.singleInstance(returnType, new Filter(path.to(), value), this.fProvider, this.fMassages, flags, this.fMonitor, storedReferenceAttributes);
                    if (result == null) {
                        this.customizeErrorMessage(returnType, value);
                    }
                }
            }
            if (!path.refines()) return result;
            Object instance = ConfigurationElementFactory.newInstance(returnType, element, this.fProvider, this.fMassages, 16, null, storedReferenceAttributes);
            ConfigurationElements.merge(result, instance);
            return result;
        }
        if (String.class.isAssignableFrom(returnType)) {
            return value;
        }
        if (URI.class.isAssignableFrom(returnType)) {
            try {
                return URI.create(value);
            }
            catch (IllegalArgumentException e) {
                APTCommonPlugin.log(e.getLocalizedMessage(), e);
                return null;
            }
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            Class<Enum> enumType = returnType.asSubclass(Enum.class);
            return Enum.valueOf(enumType, value);
        }
        if (Boolean.class.isAssignableFrom(returnType) || Boolean.TYPE.equals(returnType)) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class.isAssignableFrom(returnType) || Byte.TYPE.equals(returnType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.isAssignableFrom(returnType) || Short.TYPE.equals(returnType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.isAssignableFrom(returnType) || Integer.TYPE.equals(returnType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.isAssignableFrom(returnType) || Long.TYPE.equals(returnType)) {
            return Long.parseLong(value);
        }
        if (Float.class.isAssignableFrom(returnType) || Float.TYPE.equals(returnType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (!Double.class.isAssignableFrom(returnType) && !Double.TYPE.equals(returnType)) throw new IllegalArgumentException();
        return Double.parseDouble(value);
    }

    private void customizeErrorMessage(Class<?> missingReferenceClass, String id) throws TeamRepositoryException {
        if (missingReferenceClass.equals(IGroupModeDescription.class)) {
            this.checkStrict(Messages.getString("NodeBasedValueComputer_MISSING_GROUP_MODE"), id);
        } else if (missingReferenceClass.equals(ISortModeDescription.class)) {
            this.checkStrict(Messages.getString("NodeBasedValueComputer_MISSING_SORTING_CRITERION"), id);
        } else {
            this.checkStrict(Messages.getString("NodeBasedValueComputer_MISSING_REFERRED_ELEMENT"), missingReferenceClass.getSimpleName(), id);
        }
    }

    private static class Filter
    implements IFilter<INode> {
        private final String fAttributeName;
        private final String fLeft;

        public Filter(String key, String left) {
            this.fAttributeName = ElementPath.valueOf(key).getAttribute();
            this.fLeft = left;
        }

        @Override
        public boolean accept(INode element) {
            String right = element.getAttribute(this.fAttributeName);
            return right == this.fLeft || right != null && right.equals(this.fLeft);
        }
    }
}

