/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class EstimateConfiguration {
    public static final String ID = "com.ibm.team.apt.configuration.workItemProgressMode";
    private static final String ATTR_NAME = "name";
    private static final String ESTIMATE_MODE = "estimationMode";
    public static final String TIME_REMAINING = "TimeRemaining";
    public static final String TIME_SPENT = "TimeSpent";
    private static final String ESTIMATE_OUTPUT_FORMAT = "estimateOutputFormat";
    private EstimateOutputFormat fOutputFormat = EstimateOutputFormat.Mixed;
    private String fProgressMode = "TimeSpent";

    public EstimateConfiguration() {
    }

    public EstimateConfiguration(IProcessConfigurationData data) {
        if (data != null) {
            this.parseData(data.getElements());
        }
    }

    public EstimateConfiguration(ModelElement data) {
        List elements;
        if (data != null && (elements = data.getChildElements()) != null) {
            this.parseData(elements.toArray(new IProcessConfigurationElement[elements.size()]));
        }
    }

    private void parseData(IProcessConfigurationElement[] elements) {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
            if (ESTIMATE_MODE.equals(element.getName())) {
                value = element.getAttribute(ATTR_NAME);
                if (value != null && (TIME_SPENT.equals(value) || TIME_REMAINING.equals(value))) {
                    this.fProgressMode = value;
                }
            } else if (ESTIMATE_OUTPUT_FORMAT.equals(element.getName()) && (value = element.getAttribute(ATTR_NAME)) != null) {
                try {
                    this.fOutputFormat = Enum.valueOf(EstimateOutputFormat.class, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public EstimateOutputFormat getEstimateOutputFormat() {
        return this.fOutputFormat;
    }

    public void setEstimateOutputFormat(EstimateOutputFormat value) {
        Assert.isNotNull((Object)((Object)value));
        this.fOutputFormat = value;
    }

    public String getProgressMode() {
        return this.fProgressMode;
    }

    public void setProgressMode(String value) {
        Assert.isTrue((TIME_SPENT.equals(value) || TIME_REMAINING.equals(value) ? 1 : 0) != 0);
        this.fProgressMode = value;
    }

    public void writeTo(IMemento memento) {
        IMemento child = memento.createChild(ESTIMATE_MODE);
        child.putString(ATTR_NAME, this.fProgressMode);
        child = memento.createChild(ESTIMATE_OUTPUT_FORMAT);
        child.putString(ATTR_NAME, this.fOutputFormat.name());
    }
}

