/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ConfigurationData;
import com.ibm.team.apt.internal.common.process.ConfigurationElementInvocationHandler;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.util.Empty;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public final class ConfigurationElements {
    static final int NULL = 0;
    static final int INHERITED = 2;
    static final int IGNORE_FOR_EQUALITY = 4;
    static final int STRICT = 8;
    static final int NO_CACHING = 16;

    public static boolean isCircularDependencyFree(Class<?> type) {
        HashSet references = new HashSet();
        return !ConfigurationElements.checkForCycles(type, references);
    }

    private static boolean checkForCycles(Class<?> type, Set<Class<?>> references) {
        Method[] methods;
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> returnType = method.getReturnType();
            if (references.contains(returnType)) {
                return true;
            }
            if (ConfigurationElements.isConfigurationDataType(returnType)) {
                references.add(type);
                if (ConfigurationElements.checkForCycles(returnType, references)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isConfigurationDataType(Object object) {
        return !object.getClass().isArray() && ConfigurationElements.getConfigurationDataType(object) != null;
    }

    public static boolean isConfigurationDataTypeArray(Object object) {
        return object.getClass().isArray() && ConfigurationElements.getConfigurationDataType(object) != null;
    }

    static boolean isConfigurationDataOfType(Class<?> type, String typeValue) {
        String[] values;
        String[] stringArray = values = type.getAnnotation(ConfigurationData.class).value();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (typeValue.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static Class<?> getConfigurationDataType(Object object) {
        if (object != null) {
            Class<?>[] interfaces;
            if (object.getClass().isArray()) {
                Class<?> componentType = object.getClass().getComponentType();
                if (ConfigurationElements.isConfigurationDataType(componentType)) {
                    return componentType;
                }
                return null;
            }
            Class<?>[] classArray = interfaces = object.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if (ConfigurationElements.isConfigurationDataType(type)) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isConfigurationDataType(Class<?> type) {
        return type.isAnnotationPresent(ConfigurationData.class) && type.isAnnotationPresent(Path.class);
    }

    static List<INode> select(Object data, List<String> segments) {
        if (segments.isEmpty()) {
            return Arrays.asList(INode.FACTORY.createNode(data, null));
        }
        ArrayList<String> path = new ArrayList<String>(segments);
        INode node = INode.FACTORY.createNode(data, null);
        INode[] children = node.getChildren();
        String name = path.remove(0);
        ArrayList<INode> result = new ArrayList<INode>();
        INode[] iNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            INode element = iNodeArray[n2];
            if (element.getName().equals(name)) {
                if (path.size() == 0) {
                    result.add(element);
                } else {
                    result.addAll(ConfigurationElements.select(element, path));
                }
            }
            ++n2;
        }
        return result;
    }

    static final String key(Path annotation) {
        return Empty.isNot(annotation.value()) ? annotation.value() : annotation.from();
    }

    static final ConfigurationElementInvocationHandler getHandler(Object object) {
        if (!Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (!(handler instanceof ConfigurationElementInvocationHandler)) {
            return null;
        }
        return (ConfigurationElementInvocationHandler)handler;
    }

    static boolean hasFlag(Object object, int flag) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        return handler != null && (handler.fFlags & flag) == flag;
    }

    static void setFlag(Object object, int flag) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        handler.fFlags |= flag;
    }

    public static boolean isProviderType(Object object, Class<? extends INodeProvider> type, Class<? extends INodeProvider> ... rest) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        if (handler == null || handler.fProviderType == null) {
            return false;
        }
        if (handler.fProviderType.equals(type)) {
            return true;
        }
        Class<? extends INodeProvider>[] classArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends INodeProvider> otherType = classArray[n2];
            if (handler.fProviderType.equals(otherType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static void merge(Object a, Object b) {
        Assert.isLegal((boolean)ConfigurationElements.getConfigurationDataType(b).isAssignableFrom(ConfigurationElements.getConfigurationDataType(a)));
        HashMap<String, Object> aValues = ConfigurationElements.getHandler(a).getValues();
        HashMap<String, Object> bValues = ConfigurationElements.getHandler(b).getValues();
        for (Map.Entry<String, Object> next : bValues.entrySet()) {
            Object[] inheritedValues;
            if (next.getValue() == null) continue;
            Object object = aValues.get(next.getKey());
            if (object == null || !object.getClass().isArray()) {
                aValues.put(next.getKey(), next.getValue());
                continue;
            }
            if (((Object[])next.getValue()).length == 0) continue;
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(Arrays.asList((Object[])next.getValue()));
            Object[] objectArray = inheritedValues = (Object[])object;
            int n = inheritedValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object inheritedValue = objectArray[n2];
                ConfigurationElements.setFlag(inheritedValue, 2);
                set.add(inheritedValue);
                ++n2;
            }
            Object[] newArray = (Object[])Array.newInstance(object.getClass().getComponentType(), set.size());
            aValues.put(next.getKey(), set.toArray(newArray));
        }
    }

    public static boolean references(Object object, Object value) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        if (handler == null) {
            return false;
        }
        Collection<Object> values = handler.getValues().values();
        for (Object field : values) {
            if (field == null) continue;
            if (field.getClass().isArray()) {
                int len = Array.getLength(field);
                int i = 0;
                while (i < len) {
                    Object fieldIndex = Array.get(field, i);
                    if (fieldIndex.equals(value)) {
                        return true;
                    }
                    ++i;
                }
                continue;
            }
            if (!field.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> void update(Object object, T oldValue, T newValue) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(object);
        Assert.isNotNull((Object)handler);
        Assert.isLegal((newValue == null || oldValue.getClass().isAssignableFrom(newValue.getClass()) ? 1 : 0) != 0);
        String key = null;
        Iterator<Map.Entry<String, Object>> iter = handler.getValues().entrySet().iterator();
        while (key == null && iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            if (entry.getValue() != oldValue) continue;
            key = entry.getKey();
        }
        Assert.isNotNull(key);
        Object removedValue = handler.getValues().put(key, newValue);
        Assert.isTrue((boolean)removedValue.equals(oldValue));
    }

    static Method getMethodByPath(Class<?> type, String path) {
        Method[] methods;
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            Path annotation;
            Method method = methodArray[n2];
            if (ConfigurationElements.isGetter(method) && (annotation = method.getAnnotation(Path.class)) != null && (key = ConfigurationElements.key(annotation)).equals(path)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    static boolean isGetter(Method m) {
        return m.getName().startsWith("get") || m.getName().startsWith("is");
    }

    static boolean isSetter(Method m) {
        return m.getName().startsWith("set");
    }

    public static boolean deepEquals(Object element, Object other) {
        ConfigurationElementInvocationHandler thisHandler = ConfigurationElements.getHandler(element);
        ConfigurationElementInvocationHandler otherHandler = ConfigurationElements.getHandler(other);
        if (thisHandler == null) {
            return otherHandler == null ? element.equals(other) : false;
        }
        HashMap<String, Object> thisValues = thisHandler.getValues();
        HashMap<String, Object> otherValues = otherHandler.getValues();
        if (otherValues.size() != thisValues.size()) {
            return false;
        }
        for (Map.Entry<String, Object> next : thisValues.entrySet()) {
            if (!otherValues.containsKey(next.getKey())) {
                return false;
            }
            Object otherValue = otherValues.get(next.getKey());
            if (ConfigurationElements.valueEquals(next.getValue(), otherValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean valueEquals(Object v1, Object v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            int len = Array.getLength(v1);
            if (len != Array.getLength(v2)) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (!ConfigurationElements.valueEquals(Array.get(v1, i), Array.get(v2, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return ConfigurationElements.deepEquals(v1, v2);
    }

    static Object defaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (Boolean.TYPE.equals(type)) {
                return false;
            }
            if (Byte.TYPE.equals(type)) {
                return (byte)0;
            }
            if (Short.TYPE.equals(type)) {
                return (short)0;
            }
            if (Integer.TYPE.equals(type)) {
                return 0;
            }
            if (Long.TYPE.equals(type)) {
                return 0L;
            }
            if (Float.TYPE.equals(type)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(type)) {
                return 0.0;
            }
            throw new IllegalArgumentException();
        }
        return null;
    }
}

