/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ConfigurationData;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.IEqualityDelegate;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.process.ValueComputer;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

class ConfigurationElementInvocationHandler
implements InvocationHandler {
    private final Class<?> fType;
    private IEqualityDelegate<Object> fEqualityDelegate;
    private final HashMap<String, Object> fValues;
    int fFlags;
    final Class<? extends INodeProvider> fProviderType;

    ConfigurationElementInvocationHandler(Class<?> type, ValueComputer valueComputer) throws TeamRepositoryException {
        this(type, valueComputer, null, 0, null);
    }

    ConfigurationElementInvocationHandler(Class<?> type, ValueComputer valueComputer, Class<? extends INodeProvider> providerType, int flags, HashMap<String, Object> additionalReferenceAttributes) throws TeamRepositoryException {
        this.fType = type;
        this.fFlags = flags;
        this.fProviderType = providerType;
        this.fValues = valueComputer.computeValues(type);
        if (additionalReferenceAttributes != null) {
            this.fValues.putAll(additionalReferenceAttributes);
        }
    }

    Class<?> getType() {
        return this.fType;
    }

    HashMap<String, Object> getValues() {
        return this.fValues;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Path path = method.getAnnotation(Path.class);
        if (path != null && ConfigurationElements.isGetter(method)) {
            return this.fValues.get(ConfigurationElements.key(path));
        }
        if (path != null && ConfigurationElements.isSetter(method)) {
            String key = ConfigurationElements.key(path);
            Object oldValue = this.fValues.get(key);
            Object newValue = args[0];
            this.fValues.put(key, newValue);
            return oldValue;
        }
        if ("equals".equals(name)) {
            return this.getEqualityDelegate().equals(proxy, args[0]);
        }
        if ("hashCode".equals(name)) {
            return this.getEqualityDelegate().hashCode(proxy);
        }
        if ("toString".equals(name)) {
            return this.fValues.toString();
        }
        throw new IllegalArgumentException();
    }

    IEqualityDelegate<Object> getEqualityDelegate() throws InstantiationException, IllegalAccessException {
        if (this.fEqualityDelegate == null) {
            ConfigurationData annotation = this.fType.getAnnotation(ConfigurationData.class);
            this.fEqualityDelegate = annotation.equality().newInstance();
        }
        return this.fEqualityDelegate;
    }
}

