/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.ICompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompositeNodeProvider
implements INodeProvider,
ICachingSupport,
ICompositeNodeProvider {
    private INodeProvider[] fDelegates;
    private List<ICachingSupport> fCachingSupport;

    public CompositeNodeProvider(INodeProvider[] delegates) {
        this.fDelegates = delegates;
        this.initCachingSupport();
    }

    public CompositeNodeProvider(INodeProvider first, INodeProvider ... rest) {
        int len = rest.length;
        this.fDelegates = new INodeProvider[1 + len];
        if (len > 0) {
            this.fDelegates[0] = first;
            System.arraycopy(rest, 0, this.fDelegates, 1, len);
        }
        this.initCachingSupport();
    }

    private void initCachingSupport() {
        this.fCachingSupport = new ArrayList<ICachingSupport>();
        INodeProvider[] iNodeProviderArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            INodeProvider provider = iNodeProviderArray[n2];
            if (provider instanceof ICachingSupport) {
                this.fCachingSupport.add((ICachingSupport)provider);
            }
            ++n2;
        }
    }

    @Override
    public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        INodeProvider[] iNodeProviderArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            INodeProvider delegate = iNodeProviderArray[n2];
            INode node = delegate.getNode(identifier, monitor);
            if (node != null) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public INodeProvider[] getDelegates() {
        return this.fDelegates;
    }

    @Override
    public <T> T get(String identifier, Class<T> type) {
        if (this.fCachingSupport == null) {
            return null;
        }
        for (ICachingSupport cachingSupport : this.fCachingSupport) {
            T t = cachingSupport.get(identifier, type);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public void add(ICacheEntryState node, String identifier, Object value) {
        if (this.fCachingSupport == null) {
            return;
        }
        for (ICachingSupport cachingSupport : this.fCachingSupport) {
            cachingSupport.add(node, identifier, value);
        }
    }
}

