/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElementInvocationHandler;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ValueComputer;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

class CloningValueComputer
extends ValueComputer {
    private Object fOther;

    CloningValueComputer(Object other) {
        this.fOther = other;
    }

    @Override
    public HashMap<String, Object> computeValues(Class<?> type) throws TeamRepositoryException {
        try {
            ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(this.fOther);
            HashMap values = (HashMap)handler.getValues().clone();
            for (Map.Entry entry : values.entrySet()) {
                Object value = entry.getValue();
                entry.setValue(CloningValueComputer.deepClone(value));
            }
            HashMap hashMap = values;
            return hashMap;
        }
        finally {
            this.dispose();
        }
    }

    private void dispose() {
        this.fOther = null;
    }

    private static Object deepClone(Object value) {
        if (value == null) {
            return value;
        }
        if (ConfigurationElements.isConfigurationDataType(value)) {
            return ConfigurationElementFactory.copy(value);
        }
        if (ConfigurationElements.isConfigurationDataTypeArray(value)) {
            Class<?> componentType = ConfigurationElements.getConfigurationDataType(value);
            int len = Array.getLength(value);
            Object newValue = Array.newInstance(componentType, len);
            int i = 0;
            while (i < len) {
                Object clone = ConfigurationElementFactory.copy(Array.get(value, i));
                Array.set(newValue, i, clone);
                ++i;
            }
            return newValue;
        }
        return value;
    }
}

