/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AuditablePlanningItemStore
implements IPlanningItemStore {
    private final IAuditableCommon fCommon;

    public AuditablePlanningItemStore(IAuditableCommon common) {
        this.fCommon = common;
    }

    @Override
    public void invalidate(IItemHandle handle) {
    }

    @Override
    public boolean hasCached(IItemHandle handle, String[] properties) throws TeamRepositoryException {
        return false;
    }

    @Override
    public boolean cache(IItem item) {
        return false;
    }

    @Override
    public <T extends IItem> List<T> fetchItems(Collection<? extends IItemHandle> handles, String[] properties, IProgressMonitor monitor) throws TeamRepositoryException {
        Iterator<? extends IItemHandle> iterator = handles.iterator();
        if (iterator.hasNext()) {
            IItemType type = iterator.next().getItemType();
            ItemProfile profile = properties == null ? ItemProfile.createFullProfile((IItemType)type) : ItemProfile.createProfile((IItemType)type, (String[])properties);
            return this.fCommon.resolveAuditables((List)handles, profile, monitor);
        }
        if (monitor != null) {
            monitor.done();
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends IItem> List<T> fetchCompleteItems(Collection<? extends IItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchItems(handles, null, monitor);
    }

    @Override
    public IItem fetchItem(IItemHandle handle, String[] properties, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemType type = handle.getItemType();
        ItemProfile profile = properties == null ? ItemProfile.createFullProfile((IItemType)type) : ItemProfile.createProfile((IItemType)type, (String[])properties);
        return this.fCommon.resolveAuditable((IAuditableHandle)handle, profile, monitor);
    }

    @Override
    public IItem fetchCompleteItem(IItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchItem(handle, null, monitor);
    }

    @Override
    public IPlanningItemStore.IPlanningProcessStore getProcessStore(IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return new AuditablePlanningProcessStore(this, this.fCommon.getProcess(processAreaHandle, monitor));
    }

    public static class AuditablePlanningProcessStore
    implements IPlanningItemStore.IPlanningProcessStore {
        private final IAuditableCommonProcess fProcess;
        private final IPlanningItemStore fPlanningItemStore;

        public AuditablePlanningProcessStore(IPlanningItemStore itemStore, IAuditableCommonProcess process) {
            this.fPlanningItemStore = itemStore;
            this.fProcess = process;
        }

        public AuditablePlanningProcessStore(IAuditableCommonProcess process) {
            this(new AuditablePlanningItemStore(process.getAuditableCommon()), process);
        }

        @Override
        public IProjectArea getProjectArea() {
            return (IProjectArea)this.fProcess.getProjectArea();
        }

        @Override
        public IProcessConfigurationData findProcessConfiguration(String configurationDataPoint, IProgressMonitor monitor) throws TeamRepositoryException {
            return this.fProcess.findProcessConfiguration(configurationDataPoint, monitor);
        }

        @Override
        public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
            return this.fProcess.getPermittedActions(processArea, operationId, actions, monitor);
        }

        @Override
        public IPlanningItemStore getPlanningItemStore() {
            return this.fPlanningItemStore;
        }
    }
}

