/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.common.APTCommon;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.Messages;
import com.ibm.team.apt.internal.common.process.ProjectAreaBasedMassage;
import com.ibm.team.apt.internal.common.util.AttributeDefinitionUtil;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttributeDefinitionMassage
extends ProjectAreaBasedMassage<IAttributeDefinitionDescriptor> {
    private static final String DESCRIPTOR_ID = "com.ibm.team.apt.attribute.planitem.newRanking";
    public static final String NEW_RANKING_ATTRIBUTE_ID = "com.ibm.team.apt.attribute.planitem.newRanking._pm7NmRYUEd6L1tNIGdz5qQ";
    private final IWorkItemCommon fWorkItemCommon;
    private final IPlanningCommon fPlanningCommon;

    public AttributeDefinitionMassage(IPlanningCommon planningCommon, IWorkItemCommon workItemCommon) {
        this.fPlanningCommon = planningCommon;
        this.fWorkItemCommon = workItemCommon;
    }

    @Override
    public void massage(IProjectAreaHandle projectArea, IAttributeDefinitionDescriptor attribute, INode element, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        IComplexityAttribute complexityAttribute;
        IAttribute resolvedAttribute;
        Identifier<IAttribute> identifier = PlanItemAttributes.getAttributeId(attribute);
        if (identifier != null && (resolvedAttribute = this.fWorkItemCommon.findAttribute(projectArea, identifier.getStringIdentifier(), monitor)) != null) {
            boolean overwriteName = false;
            overwriteName |= attribute.getDisplayName() == null;
            if (overwriteName |= resolvedAttribute.getDisplayName() != null && !resolvedAttribute.getDisplayName().equals(attribute.getDisplayName())) {
                attribute.setDisplayName(resolvedAttribute.getDisplayName());
            }
            if (attribute.getQueryId() == null) {
                attribute.setQueryId(AttributeDefinitionUtil.toCamelCase(attribute.getDisplayName()));
            }
            if (attribute.isReadOnly() != resolvedAttribute.isReadOnly()) {
                attribute.setReadOnly(resolvedAttribute.isReadOnly());
            }
            if (attribute.isInternal() != resolvedAttribute.isInternal()) {
                attribute.setInternal(resolvedAttribute.isInternal());
            }
            if (attribute.getType() == null) {
                PlanningAttributeType type = AttributeTypes.isEnumerationAttributeType((String)resolvedAttribute.getAttributeType()) ? PlanningAttributeType.ENUMERATION : PlanItemAttributes.getPlanningAttributeType(resolvedAttribute.getAttributeType());
                attribute.setType(type);
            }
            IParameter itemIdParam = IParameter.FACTORY.create("itemId", resolvedAttribute.getItemId().getUuidValue());
            IParameter[] parameters = IParameter.FACTORY.appendOrOverwrite(attribute.getParameters(), itemIdParam);
            attribute.setParameters(parameters);
        }
        if ("com.ibm.team.apt.attribute.planitem.complexity".equals(attribute.getId()) && (complexityAttribute = this.fPlanningCommon.findComplexityAttribute((IProcessAreaHandle)projectArea, monitor)) != null) {
            ArrayList<IParameter> parameter = new ArrayList<IParameter>();
            parameter.add(IParameter.FACTORY.create("label", complexityAttribute.getDisplayName()));
            parameter.add(IParameter.FACTORY.create("abbreviation", complexityAttribute.getShortDisplayName()));
            parameter.add(IParameter.FACTORY.create("attribute", complexityAttribute.getAttributeId()));
            attribute.setParameters(parameter.toArray(new IParameter[0]));
        }
        if ("com.ibm.team.apt.attribute.planitem.timeSpent".equals(attribute.getId()) && this.fPlanningCommon.isSyncTimeSpentWithTimeTracking((IProcessAreaHandle)projectArea)) {
            attribute.setReadOnly(true);
        }
        if ("com.ibm.team.apt.attributes._com.ibm.team.workitem.attribute.wsjf".equals(attribute.getId()) || "com.ibm.team.apt.attributes._com.ibm.team.workitem.attribute.wsjfDecimal".equals(attribute.getId())) {
            attribute.setReadOnly(true);
        }
        if ("com.ibm.team.apt.client.RankingAttribute".equals(attribute.getImplementationName())) {
            attribute.setImplementationName("com.ibm.team.apt.shared.client.RankingAttribute");
        }
        if (APTCommon.isRanking(attribute.getImplementationName())) {
            IAttribute synAttribute;
            IParameter[] parameters;
            block15: {
                parameters = attribute.getParameters();
                IParameter attrParam = IParameter.FACTORY.findFirst("attribute", parameters);
                String synAttributeId = String.valueOf(attrParam.getValue()) + "." + "_pm7NmRYUEd6L1tNIGdz5qQ";
                synAttribute = this.fWorkItemCommon.findAttribute(projectArea, synAttributeId, monitor);
                if (synAttribute == null && synAttributeId.equals(NEW_RANKING_ATTRIBUTE_ID)) {
                    try {
                        synAttribute = this.fWorkItemCommon.createNewAttribute(projectArea, NEW_RANKING_ATTRIBUTE_ID, "smallString", null, monitor);
                        synAttribute.setInternal(true);
                        synAttribute.setDisplayName(Messages.getString(Messages.NewRankingAttributeHelper_LABEL_NEWRANKING_ATTR));
                        this.fWorkItemCommon.saveAttribute(synAttribute, monitor);
                    }
                    catch (TeamRepositoryException e) {
                        if (this.fWorkItemCommon.findAttribute(projectArea, synAttributeId, monitor) == null) break block15;
                        throw e;
                    }
                }
            }
            if (synAttribute != null) {
                IParameter synAttrParam = IParameter.FACTORY.create("synAttributeItemId", synAttribute.getItemId().getUuidValue());
                parameters = IParameter.FACTORY.appendOrOverwrite(parameters, synAttrParam);
                attribute.setParameters(parameters);
            }
        }
    }

    @Override
    public Class<IAttributeDefinitionDescriptor> getType() {
        return IAttributeDefinitionDescriptor.class;
    }
}

