/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.plantype;

import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanMode;
import com.ibm.team.apt.internal.common.plantype.SharedPlanModeComparator;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.repository.common.IItemHandle;

public class ResolvedPlanMode
implements Comparable<ResolvedPlanMode> {
    private ISharedPlanMode fSharedPlanMode;
    private IPlanModeDescription fDescription;
    private SharedPlanModeComparator fComparator;

    public ResolvedPlanMode(IProcessDefinitionHandle processDefinition, String plan, IPlanModeDescription description) {
        this.fSharedPlanMode = (ISharedPlanMode)ISharedPlanMode.ITEM_TYPE.createItem();
        this.fSharedPlanMode.setOwner((IItemHandle)processDefinition);
        this.fSharedPlanMode.setPlan(plan);
        this.fDescription = ResolvedPlanMode.removeSummaryColumn(description);
    }

    public ResolvedPlanMode(ISharedPlanMode sharedPlanMode, IPlanModeDescription description) {
        this.fSharedPlanMode = sharedPlanMode;
        this.fDescription = ResolvedPlanMode.removeSummaryColumn(description);
    }

    private static IPlanModeDescription removeSummaryColumn(IPlanModeDescription description) {
        IColumnDescriptor[] columns = description.getColumns();
        if (columns.length > 0 && "com.ibm.team.apt.attribute.summary".equals(columns[0].getAttribute().getId())) {
            IColumnDescriptor[] newColumns = new IColumnDescriptor[columns.length - 1];
            System.arraycopy(columns, 1, newColumns, 0, newColumns.length);
            description.setColumns(newColumns);
        }
        return description;
    }

    public IPlanModeDescription getDescription() {
        return this.fDescription;
    }

    public ISharedPlanMode getSharedPlanMode() {
        return this.fSharedPlanMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fDescription == null ? 0 : this.fDescription.hashCode());
        result = 31 * result + (this.fSharedPlanMode == null ? 0 : this.fSharedPlanMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvedPlanMode other = (ResolvedPlanMode)obj;
        if (this.fDescription == null ? other.fDescription != null : !this.fDescription.equals(other.fDescription)) {
            return false;
        }
        return !(this.fSharedPlanMode == null ? other.fSharedPlanMode != null : !this.fSharedPlanMode.equals(other.fSharedPlanMode));
    }

    @Override
    public int compareTo(ResolvedPlanMode other) {
        if (this.fComparator == null) {
            this.fComparator = new SharedPlanModeComparator(SortMode.ASC);
        }
        return this.fComparator.compare(this.getSharedPlanMode(), other.getSharedPlanMode());
    }
}

