/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.plantype;

import com.ibm.team.apt.internal.common.process.ConfigurationData;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.IEqualityDelegate;
import com.ibm.team.apt.internal.common.process.Path;

@ConfigurationData(value={""}, equality=PropertyEquality.class)
@Path
public interface IProperty {
    public static final Factory FACTORY = new Factory();

    @Path(value="@key")
    public String getKey();

    @Path(value="@key")
    public String setKey(String var1);

    @Path(value="@value")
    public String getValue();

    @Path(value="@value")
    public String setValue(String var1);

    public static class Factory {
        private Factory() {
        }

        public IProperty create(String key, String value) {
            IProperty property = ConfigurationElementFactory.emptyInstance(IProperty.class);
            property.setKey(key);
            property.setValue(value);
            return property;
        }

        public IProperty[] append(IProperty[] properties, IProperty first, IProperty ... rest) {
            int len1 = properties.length;
            int len2 = rest.length;
            IProperty[] result = new IProperty[len1 + 1 + len2];
            System.arraycopy(properties, 0, result, 0, len1);
            result[len1] = first;
            System.arraycopy(rest, 0, result, len1 + 1, len2);
            return result;
        }

        public IProperty findFirst(String key, IProperty[] properties) {
            if (properties == null) {
                return null;
            }
            IProperty[] iPropertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                IProperty parameter = iPropertyArray[n2];
                if (key.equals(parameter.getKey())) {
                    return parameter;
                }
                ++n2;
            }
            return null;
        }

        public IProperty[] appendOrOverwrite(IProperty[] properties, IProperty property) {
            IProperty first = this.findFirst(property.getKey(), properties);
            if (first != null) {
                first.setValue(property.getValue());
                return properties;
            }
            return this.append(properties, property, new IProperty[0]);
        }
    }

    public static class PropertyEquality
    implements IEqualityDelegate<IProperty> {
        @Override
        public boolean equals(IProperty element, Object other) {
            if (other instanceof IProperty) {
                return ((IProperty)other).getKey() == null ? element.getKey() == null : ((IProperty)other).getKey().equals(element.getKey());
            }
            return false;
        }

        @Override
        public int hashCode(IProperty element) {
            return element.getKey() == null ? 0 : element.getKey().hashCode();
        }
    }
}

