/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.plantype;

import com.ibm.team.apt.internal.common.process.ConfigurationData;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.IEqualityDelegate;
import com.ibm.team.apt.internal.common.process.Path;

@ConfigurationData(value={""}, equality=ParameterEquality.class)
@Path
public interface IParameter {
    public static final Factory FACTORY = new Factory();

    @Path(value="@key")
    public String getKey();

    @Path(value="@key")
    public String setKey(String var1);

    @Path(value="@value")
    public String getValue();

    @Path(value="@value")
    public String setValue(String var1);

    public static class Factory {
        private Factory() {
        }

        public IParameter create(String key, String value) {
            IParameter parameter = ConfigurationElementFactory.emptyInstance(IParameter.class);
            parameter.setKey(key);
            parameter.setValue(value);
            return parameter;
        }

        public IParameter[] append(IParameter[] parameters, IParameter first, IParameter ... rest) {
            int len1 = parameters.length;
            int len2 = rest.length;
            IParameter[] result = new IParameter[len1 + 1 + len2];
            System.arraycopy(parameters, 0, result, 0, len1);
            result[len1] = first;
            System.arraycopy(rest, 0, result, len1 + 1, len2);
            return result;
        }

        public IParameter findFirst(String key, IParameter[] parameters) {
            if (parameters == null) {
                return null;
            }
            IParameter[] iParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter parameter = iParameterArray[n2];
                if (key.equals(parameter.getKey())) {
                    return parameter;
                }
                ++n2;
            }
            return null;
        }

        public IParameter[] appendOrOverwrite(IParameter[] parameters, IParameter param) {
            IParameter first = this.findFirst(param.getKey(), parameters);
            if (first != null) {
                first.setValue(param.getValue());
                return parameters;
            }
            return this.append(parameters, param, new IParameter[0]);
        }
    }

    public static class ParameterEquality
    implements IEqualityDelegate<IParameter> {
        @Override
        public boolean equals(IParameter element, Object other) {
            if (other instanceof IParameter) {
                return ((IParameter)other).getKey() == null ? element.getKey() == null : ((IParameter)other).getKey().equals(element.getKey());
            }
            return false;
        }

        @Override
        public int hashCode(IParameter element) {
            return element.getKey() == null ? 0 : element.getKey().hashCode();
        }
    }
}

