/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.items;

import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.IUIItemHandle;
import com.ibm.team.apt.api.common.ItemType;
import com.ibm.team.apt.api.common.UIItemHandle;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanEditorTabContribution;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.IProcessNature;
import com.ibm.team.apt.internal.common.plantype.ISchedulerDescription;
import com.ibm.team.apt.internal.common.plantype.ISnapshotType;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import java.util.HashMap;
import java.util.Map;

public class ItemUtil {
    private static Map<ItemType, Class<? extends IConfigurationElement>> map = new HashMap<ItemType, Class<? extends IConfigurationElement>>();

    static {
        map.put(ItemType.PlanningAttributeDesc, IAttributeDefinitionDescriptor.class);
        map.put(ItemType.PlanTypeDesc, IPlanType.class);
        map.put(ItemType.PlanCheckDesc, IPlanCheckDescription.class);
        map.put(ItemType.SchedulerDesc, ISchedulerDescription.class);
        map.put(ItemType.PlanModeDesc, IPlanModeDescription.class);
        map.put(ItemType.ViewModeDesc, IViewModeDescription.class);
        map.put(ItemType.GroupModeDesc, IGroupModeDescription.class);
        map.put(ItemType.SortModeDesc, ISortModeDescription.class);
        map.put(ItemType.FilterDesc, IFilterDescription.class);
        map.put(ItemType.PlanEditorTabContribution, IPlanEditorTabContribution.class);
        map.put(ItemType.ProcessNature, IProcessNature.class);
        map.put(ItemType.SnapshotType, ISnapshotType.class);
    }

    public static Class<? extends IConfigurationElement> getConfigurationType(ItemType type) {
        return map.get(type);
    }

    public static ItemType getItemType(Object element) {
        for (Map.Entry<ItemType, Class<? extends IConfigurationElement>> entry : map.entrySet()) {
            if (!entry.getValue().isInstance(element)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T extends IUIItem> IUIItemHandle<T> createItemHandle(Object object) {
        if (object instanceof IAttributeDefinitionDescriptor) {
            return UIItemHandle.stateHandleFrom((ItemType)ItemType.PlanningAttributeDesc, (String)((IAttributeDefinitionDescriptor)object).getId(), null);
        }
        if (object instanceof IItemHandle) {
            IItemHandle itemHandle = (IItemHandle)object;
            ItemType itemType = ItemUtil.getItemType(itemHandle.getItemType());
            return UIItemHandle.stateHandleFrom((ItemType)itemType, (String)ItemUtil.uuid(itemHandle.getItemId()), (String)ItemUtil.uuid(itemHandle.getStateId()));
        }
        throw new IllegalArgumentException();
    }

    public static IItemHandle createItemHandle(IUIItemHandle<?> handle) {
        IItemType itemType = ItemUtil.getItemType(handle.getType());
        UUID itemId = ItemUtil.uuid(handle.getItemId());
        UUID stateId = ItemUtil.uuid(handle.getStateId());
        return itemType.createItemHandle(itemId, stateId);
    }

    public static IItemType getItemType(ItemType type) {
        IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(type.getName(), type.getNamespace());
        return itemType;
    }

    public static ItemType getItemType(IItemType itemType) {
        ItemType[] itemTypeArray = ItemType.values();
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType type = itemTypeArray[n2];
            if (type.getName().equals(itemType.getName()) && type.getNamespace().equals(itemType.getNamespaceURI())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static UUID uuid(String value) {
        return value != null ? UUID.valueOf((String)value) : null;
    }

    public static String uuid(UUID value) {
        return value != null ? value.getUuidValue() : null;
    }

    public static boolean isNewItem(IUIItemHandle<? extends IUIItem> handle) {
        return handle.getItemId().indexOf("__new") == 0;
    }
}

