/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.duration;

import com.ibm.team.apt.api.common.planning.IPlanDuration;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.internal.common.WorkItemEstimator;
import org.eclipse.core.runtime.Assert;

public class PlanDuration
extends com.ibm.team.workitem.common.model.Duration
implements IPlanDuration {
    private final long fOriginalEstimate;
    private final long fCorrectedEstimate;
    private final long fTimeSpent;
    private static final int INVALID_TIME_SPENT_OFFSET = 3;

    public PlanDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        super(PlanDuration.calculateDuration(originalEstimate, correctedEstimate, timeSpent, isResolved));
        this.fOriginalEstimate = originalEstimate;
        this.fCorrectedEstimate = correctedEstimate;
        this.fTimeSpent = timeSpent;
    }

    public long getDuration() {
        if (this.isSpecified()) {
            return this.longValue();
        }
        return WorkItemEstimator.getInstance().getDefaultEstimate();
    }

    public long getOriginalEstimateDuration() {
        return this.fOriginalEstimate;
    }

    public long getCorrectedEstimateDuration() {
        return this.fCorrectedEstimate;
    }

    public long getCurrentEstimateDuration() {
        return this.isOriginalEstimateFixed() ? this.fCorrectedEstimate : this.fOriginalEstimate;
    }

    public long getTimeSpentDuration() {
        return this.fTimeSpent;
    }

    public long getTimeRemainingDuration() {
        long timeSpent = this.getTimeSpentDuration();
        if (PlanDuration.isEncodedTimeRemaining(timeSpent)) {
            return PlanDuration.decodeTimeSpent2TimeRemaining(timeSpent);
        }
        if (timeSpent >= 0L) {
            long value = this.getCurrentEstimateDuration() - timeSpent;
            if (value >= 0L) {
                return value;
            }
            return com.ibm.team.workitem.common.model.Duration.INVALID.longValue();
        }
        return this.getEstimate().getMilliseconds();
    }

    public String getLabel() {
        return String.valueOf(this.getDuration());
    }

    public long getMilliseconds() {
        return this.getDuration();
    }

    public IDuration getOriginalEstimate() {
        return new Duration(this.getOriginalEstimateDuration());
    }

    public int compareTo(IDuration duration) {
        return this.getMilliseconds() > duration.getMilliseconds() ? -1 : (this.getMilliseconds() == duration.getMilliseconds() ? 0 : 1);
    }

    public IDuration getCorrectedEstimate() {
        return new Duration(this.getCorrectedEstimateDuration());
    }

    public IDuration getTimeSpent() {
        return new Duration(this.getTimeSpentDuration());
    }

    public IDuration getTimeRemaining() {
        return new Duration(this.getTimeRemainingDuration());
    }

    public IDuration getEstimate() {
        return this.getCorrectedEstimate().isSpecified() ? this.getCorrectedEstimate() : this.getOriginalEstimate();
    }

    public boolean isOriginalEstimateFixed() {
        return this.fCorrectedEstimate != -1L;
    }

    public boolean hasEstimate() {
        return this.getCurrentEstimateDuration() >= 0L;
    }

    public boolean hasOriginalEstimate() {
        return this.getOriginalEstimateDuration() >= 0L;
    }

    public boolean hasCorrectedEstimate() {
        return this.getCorrectedEstimateDuration() >= 0L;
    }

    public boolean hasTimeSpent() {
        return this.getTimeSpentDuration() >= 0L;
    }

    public boolean hasTimeRemaining() {
        return this.getTimeRemainingDuration() >= 0L;
    }

    public static long encodeTimeRemaining2TimeSpent(long value) {
        Assert.isLegal((value >= 0L ? 1 : 0) != 0);
        long result = 0L;
        result += 3L;
        result += value;
        return result *= -1L;
    }

    public static long decodeTimeSpent2TimeRemaining(long value) {
        Assert.isLegal((boolean)PlanDuration.isEncodedTimeRemaining(value));
        long result = value;
        result *= -1L;
        return result -= 3L;
    }

    public static boolean isEncodedTimeRemaining(long timeSpent) {
        return timeSpent < -2L;
    }

    private static long calculateDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        long result = originalEstimate;
        if (correctedEstimate >= 0L) {
            result = correctedEstimate;
        }
        if (timeSpent >= 0L) {
            if (!isResolved) {
                if (result >= 0L) {
                    result = Math.max(result - timeSpent, 0L);
                }
            } else {
                result = timeSpent;
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.fCorrectedEstimate ^ this.fCorrectedEstimate >>> 32);
        result = 31 * result + (int)(this.fOriginalEstimate ^ this.fOriginalEstimate >>> 32);
        result = 31 * result + (int)(this.fTimeSpent ^ this.fTimeSpent >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PlanDuration other = (PlanDuration)((Object)obj);
        if (this.fCorrectedEstimate != other.fCorrectedEstimate) {
            return false;
        }
        if (this.fOriginalEstimate != other.fOriginalEstimate) {
            return false;
        }
        return this.fTimeSpent == other.fTimeSpent;
    }
}

