/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.time.Assignment;
import com.ibm.team.apt.internal.common.time.AssignmentIterator;
import com.ibm.team.apt.internal.common.time.ExclusionIterator;
import com.ibm.team.apt.internal.common.time.ICalendarIterator;
import com.ibm.team.apt.internal.common.time.TimespanIterator;
import com.ibm.team.apt.internal.common.time.UnionIterator;
import com.ibm.team.apt.internal.common.time.WorktimeIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;

public class WorktimeScheduler
implements IWorkHoursDefinition {
    private final int fTimezoneOffset = ResourcePlanningUtils.getCalendarTimeZoneOffset();
    private final IWorkLocationDefinition fWorkLocation;
    private final IWorkResourceDetails[] fAssignments;
    private final TimeZone fWorkTimeZone;
    private final Locale fWorkLocale;
    private final IWorkDayDefinition[] fWorkDays;
    private final Set<BookedTimeType> fBookedTimeTypes = new HashSet<BookedTimeType>();
    private final Set<IBookedTime> fBookedTime = new HashSet<IBookedTime>();
    private final List<BookedTimespan> fBookedTimespans = new ArrayList<BookedTimespan>();
    private final Comparator<BookedTimespan> fTimespanInsertComparator = new Comparator<BookedTimespan>(){

        @Override
        public int compare(BookedTimespan e1, BookedTimespan e2) {
            if (e1.getEnd().compareTo(e2.getStart()) < 0) {
                return -1;
            }
            if (e1.getStart().compareTo(e2.getEnd()) > 0) {
                return 1;
            }
            int result = e1.getStart().compareTo(e2.getStart());
            if (result == 0) {
                result = e1.getEnd().compareTo(e2.getEnd());
            }
            return result;
        }
    };

    public WorktimeScheduler(IWorkLocationDefinition workLocationDefinition, IWorkResourceDetails[] assignments) {
        this.fWorkLocation = workLocationDefinition;
        this.fAssignments = assignments;
        this.fWorkLocale = ResourcePlanningUtils.getLocale(workLocationDefinition);
        this.fWorkTimeZone = ResourcePlanningUtils.getTimeZone(workLocationDefinition);
        this.fWorkDays = new IWorkDayDefinition[7];
        Iterator<IWorkDayDefinition> iterator = this.fWorkLocation.getWorkDays().iterator();
        while (iterator.hasNext()) {
            IWorkDayDefinition workDay;
            this.fWorkDays[workDay.getDay().getValue() - 1] = workDay = iterator.next();
        }
    }

    public long calculateWorkingTime(Timespan span) {
        long currentEnd;
        Assert.isNotNull((Object)span);
        Assert.isNotNull((Object)span.getStart());
        Assert.isNotNull((Object)span.getEnd());
        Assert.isTrue((span.getStart().before(span.getEnd()) || span.getStart().equals(span.getEnd()) ? 1 : 0) != 0);
        if (span.getStart().equals(span.getEnd())) {
            return 0L;
        }
        WorktimeIterator.Workday[] workdays = this.getWorkDays();
        ICalendarIterator worktimeIterator = new WorktimeIterator(workdays);
        if (this.fBookedTimespans != null && this.fBookedTimespans.size() > 0) {
            ArrayList<Timespan> absences = new ArrayList<Timespan>();
            for (BookedTimespan absence : this.fBookedTimespans) {
                Date absenceStart = this.setHours(absence.getStart(), 0, 0, 0, 0, true);
                Date absenceEnd = this.setHours(absence.getEnd(), 23, 59, 59, 0, true);
                if (absenceEnd.before(span.getStart()) || absenceStart.after(span.getEnd())) continue;
                absences.add(new Timespan(absenceStart, absenceEnd));
            }
            worktimeIterator = new UnionIterator(new ICalendarIterator[]{worktimeIterator, new ExclusionIterator(new TimespanIterator(absences.toArray(new Timespan[absences.size()])))});
        }
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        if (this.fAssignments == null || this.fAssignments.length == 0) {
            assignments.add(new Assignment(Instant.time(1L), Instant.time((long)Math.pow(2.0, 52.0)), 0.01));
        } else {
            int i = 0;
            while (i < this.fAssignments.length) {
                double assignment = (double)this.fAssignments[i].getAssignment() / 100.0;
                Instant endDate = new Instant(this.setHours(this.fAssignments[i].getEndDate(), 23, 59, 59, 0, false));
                Instant startDate = new Instant(this.setHours(this.fAssignments[i].getStartDate(), 0, 0, 0, 0, false));
                assignments.add(new Assignment(startDate, endDate, assignment));
                ++i;
            }
        }
        AssignmentIterator iterator = new AssignmentIterator(worktimeIterator, assignments.toArray(new Assignment[assignments.size()]));
        try {
            Date iterationStart = WorktimeScheduler.convertToDateInTimeZone(span.getStart(), this.getTimeZone());
            iterator.reset(new Instant(iterationStart), true);
        }
        catch (ParseException e) {
            iterator.reset(new Instant(span.getStart()), true);
        }
        long workTime = 0L;
        long maxEnd = 0L;
        try {
            Date iterationEnd = WorktimeScheduler.convertToDateInTimeZone(span.getEnd(), this.getTimeZone());
            maxEnd = iterationEnd.getTime();
        }
        catch (ParseException e) {
            maxEnd = span.getEnd().getTime();
        }
        do {
            long currentStart = Math.min(iterator.current().getStart().getTime(), maxEnd);
            currentEnd = Math.min(iterator.current().getEnd().getTime(), maxEnd);
            workTime = (long)((double)workTime + (double)Math.max(0L, currentEnd - currentStart) * iterator.getAssignmentForWorkTime());
        } while (iterator.nextForWorkTime() != null && currentEnd != maxEnd);
        return workTime;
    }

    private static Date convertToDateInTimeZone(Date date, TimeZone timeZone) throws ParseException {
        SimpleDateFormat formatter = WorktimeScheduler.getDateFormatter(timeZone);
        String dateString = formatter.format(date);
        Date newDate = formatter.parse(dateString);
        return newDate;
    }

    private static SimpleDateFormat getDateFormatter(TimeZone timeZone) {
        timeZone = timeZone == null ? ResourcePlanningUtils.getGMTTimezone() : timeZone;
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        format.setTimeZone(timeZone);
        return format;
    }

    private WorktimeIterator.Workday[] getWorkDays() {
        WorktimeIterator.Workday[] workdays = new WorktimeIterator.Workday[7];
        int i = 0;
        while (i < 7) {
            long workingTimePerDay = Math.max(this.fWorkDays[i] != null ? this.fWorkDays[i].getWorkingTime() : 0L, 0L);
            long endTime = Math.max(this.fWorkDays[i] != null ? this.fWorkDays[i].getEndTime() : 0L, 0L);
            workdays[i] = new WorktimeIterator.Workday(i + 1, (int)workingTimePerDay, (int)endTime);
            ++i;
        }
        return workdays;
    }

    @Deprecated
    public long calculateWorkingTimeOld(Timespan span) {
        Assert.isNotNull((Object)span);
        Assert.isNotNull((Object)span.getStart());
        Assert.isNotNull((Object)span.getEnd());
        Assert.isTrue((span.getStart().before(span.getEnd()) || span.getStart().equals(span.getEnd()) ? 1 : 0) != 0);
        Date start = span.getStart();
        Date end = span.getEnd();
        if (span.getStart().equals(span.getEnd())) {
            return 0L;
        }
        long duration = 0L;
        Date current = new Date(this.setToDayStart(this.getCalendarInstance(start.getTime())).getTimeInMillis());
        while (!current.after(end)) {
            Timespan dayHrs = this.getWorkingHours(current);
            if (dayHrs != null) {
                Date dayStart;
                Date dayEnd = dayHrs.getEnd();
                if (end.before(dayEnd)) {
                    dayEnd = end;
                }
                if (start.after(dayStart = dayHrs.getStart())) {
                    dayStart = start;
                }
                duration += Math.max(dayEnd.getTime() - dayStart.getTime(), 0L);
            }
            current.setTime(current.getTime() + 86400000L);
        }
        return duration;
    }

    public Date calculateWorkStart(Date referenceTime) {
        return this.calculateWorkStart(referenceTime, this.fBookedTimeTypes);
    }

    public Date calculateWorkStart(Date referenceTime, Collection<BookedTimeType> bookedTimeToConsider) {
        return this.doCalculateTimeSpan(referenceTime, 0L, true, bookedTimeToConsider).getStart();
    }

    public Timespan calculateTimeSpan(Date planned, long duration, boolean forward) {
        return this.calculateTimeSpan(planned, duration, forward, this.fBookedTimeTypes);
    }

    public Timespan calculateTimeSpan(Date planned, long duration, boolean forward, Collection<BookedTimeType> bookedTimeToConsider) {
        return this.doCalculateTimeSpan(planned, duration, forward, bookedTimeToConsider);
    }

    public Collection<IBookedTime> getBookedTime() {
        return this.getBookedTime(this.fBookedTimeTypes);
    }

    public Collection<IBookedTime> getBookedTime(Collection<BookedTimeType> typesToConsider) {
        if (this.fBookedTimeTypes.equals(typesToConsider)) {
            return Collections.unmodifiableCollection(this.fBookedTime);
        }
        ArrayList<IBookedTime> result = new ArrayList<IBookedTime>(this.fBookedTime.size());
        for (IBookedTime bookedTime : this.fBookedTime) {
            if (!typesToConsider.contains(bookedTime.getType())) continue;
            result.add(bookedTime);
        }
        return result;
    }

    public void addBookedTime(IBookedTime bookedTime) {
        if (this.fBookedTime.add(bookedTime)) {
            BookedTimespan normalized;
            int insertionIndex;
            this.fBookedTimeTypes.add(bookedTime.getType());
            Calendar startCalendar = this.getCalendarInstance(bookedTime.getStart().getTime());
            Calendar endCalendar = this.getCalendarInstance(bookedTime.getEnd().getTime());
            if (bookedTime.getType() == BookedTimeType.OUT_OF_OFFICE) {
                this.setToDayStart(startCalendar);
                endCalendar.add(6, 1);
                this.setToDayStart(endCalendar);
                endCalendar.add(14, -1);
            }
            if ((insertionIndex = Collections.binarySearch(this.fBookedTimespans, normalized = new BookedTimespan(startCalendar.getTime(), endCalendar.getTime(), bookedTime), this.fTimespanInsertComparator)) < 0) {
                insertionIndex = -insertionIndex - 1;
            }
            this.fBookedTimespans.add(insertionIndex, normalized);
        }
    }

    public void removeBookedTime(IBookedTime absence) {
        if (this.fBookedTime.remove(absence)) {
            Iterator<BookedTimespan> iterator = this.fBookedTimespans.iterator();
            while (iterator.hasNext()) {
                BookedTimespan bookedTimespan = iterator.next();
                if (!absence.equals(bookedTimespan.getOriginalEntry())) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.fWorkLocale;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.fWorkTimeZone;
    }

    @Override
    public Calendar getCalendarInstance() {
        return Calendar.getInstance(this.fWorkTimeZone, this.fWorkLocale);
    }

    @Override
    public Calendar getCalendarInstance(long time) {
        Calendar result = this.getCalendarInstance();
        result.setTimeInMillis(time);
        return result;
    }

    private Date setHours(Date date, int hours, int minutes, int seconds, int millisecs, boolean includeTimeZoneOffset) {
        Calendar cal = Calendar.getInstance(this.getTimeZone());
        cal.setTime(date);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, millisecs);
        return includeTimeZoneOffset ? new Date(cal.getTime().getTime() - (long)this.fTimezoneOffset) : new Date(cal.getTime().getTime());
    }

    private Timespan doCalculateTimeSpan(Date planned, long duration, boolean forward, Collection<BookedTimeType> typesToConsider) {
        int bookedTimeStart = forward ? 0 : this.fBookedTimespans.size() - 1;
        int bookedTimeLength = this.fBookedTimespans.size();
        int bookedTimeIndex = 0;
        Calendar cal = this.getCalendarInstance(planned.getTime());
        long toGo = Math.max(duration, 1L);
        Date start = null;
        Date end = null;
        boolean hasWorkTime = false;
        IWorkDayDefinition[] iWorkDayDefinitionArray = this.fWorkDays;
        int n = this.fWorkDays.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkDayDefinition workDay = iWorkDayDefinitionArray[n2];
            hasWorkTime |= workDay.getWorkingTime() > 0L && workDay.getEndTime() > 0L;
            ++n2;
        }
        if (hasWorkTime) {
            do {
                long workDuration;
                boolean retryToday = false;
                long workDayStart = 0L;
                long workDayEnd = 0L;
                while (true) {
                    IWorkDayDefinition workDay;
                    if ((workDay = this.fWorkDays[cal.get(7) - 1]) != null && workDay.getWorkingTime() > 0L) {
                        long now = cal.getTimeInMillis();
                        workDayEnd = workDay.getEndTime() + (now - this.getDayRelativeTime(cal));
                        workDayStart = workDayEnd - workDay.getWorkingTime();
                        if (forward) {
                            if (now > workDayEnd) {
                                workDayStart = workDayEnd;
                            } else if (now > workDayStart) {
                                workDayStart = now;
                            }
                        } else if (now < workDayStart) {
                            workDayEnd = workDayStart;
                        } else if (now < workDayEnd) {
                            workDayEnd = now;
                        }
                        if (workDayStart < workDayEnd && !typesToConsider.isEmpty()) {
                            while (bookedTimeIndex < bookedTimeLength) {
                                BookedTimespan bookedTimespan = this.fBookedTimespans.get(Math.abs(bookedTimeStart - bookedTimeIndex));
                                if (typesToConsider.contains(bookedTimespan.getOriginalEntry().getType())) {
                                    long absenceStart = bookedTimespan.getStart().getTime();
                                    long absenceEnd = bookedTimespan.getEnd().getTime();
                                    if (!(forward && absenceEnd <= Math.max(workDayStart, now) || !forward && absenceStart >= Math.min(workDayEnd, now))) {
                                        boolean absenceEndsToday;
                                        if (forward && absenceStart > workDayEnd || !forward && absenceEnd <= workDayStart) break;
                                        boolean absenceStartsToday = absenceStart > workDayStart;
                                        boolean bl = absenceEndsToday = absenceEnd <= workDayEnd;
                                        if (forward) {
                                            if (!absenceStartsToday && absenceEndsToday) {
                                                workDayStart = absenceEnd;
                                            } else if (absenceStartsToday) {
                                                workDayEnd = absenceStart;
                                            } else if (!absenceStartsToday && !absenceEndsToday) {
                                                workDayStart = workDayEnd;
                                            }
                                        } else if (!absenceEndsToday && absenceStartsToday) {
                                            workDayEnd = absenceStart;
                                        } else if (absenceEndsToday) {
                                            workDayStart = absenceEnd;
                                        } else if (!absenceStartsToday && !absenceEndsToday) {
                                            workDayEnd = workDayStart;
                                        }
                                        if (absenceStartsToday && absenceEndsToday) {
                                            retryToday = true;
                                        }
                                        now = forward ? absenceEnd : absenceStart;
                                    }
                                }
                                ++bookedTimeIndex;
                            }
                        }
                        cal.setTimeInMillis(now);
                    }
                    if (workDayStart != workDayEnd) break;
                    this.advanceDay(cal, forward);
                }
                if (start == null) {
                    start = new Date(forward ? workDayStart : workDayEnd);
                }
                if (toGo <= (workDuration = workDayEnd - workDayStart)) {
                    end = new Date(forward ? workDayStart + toGo : workDayEnd - toGo);
                }
                toGo -= workDuration;
                if (retryToday) continue;
                this.advanceDay(cal, forward);
            } while (end == null);
        } else {
            start = planned;
            end = new Date(planned.getTime() + (forward ? toGo : -toGo));
        }
        return forward ? new Timespan(start, end) : new Timespan(end, start);
    }

    @Override
    public Timespan getWorkingHours(Date day) {
        Calendar cal = this.getCalendarInstance(day.getTime());
        IWorkDayDefinition workDay = this.fWorkDays[cal.get(7) - 1];
        if (workDay != null && workDay.getWorkingTime() > 0L) {
            long now = cal.getTimeInMillis();
            for (BookedTimespan absence : this.fBookedTimespans) {
                long absenceStart = absence.getStart().getTime();
                long absenceEnd = absence.getEnd().getTime();
                if (absenceStart > now || absenceEnd < now) continue;
                return null;
            }
            this.setToDayStart(cal);
            cal.add(14, (int)workDay.getEndTime());
            Date endTime = new Date(cal.getTimeInMillis());
            cal.add(14, -((int)workDay.getWorkingTime()));
            Date startTime = new Date(cal.getTimeInMillis());
            return new Timespan(startTime, endTime);
        }
        return null;
    }

    private long getDayRelativeTime(Calendar cal) {
        return ((cal.get(11) * 60 + cal.get(12)) * 60 + cal.get(13)) * 1000 + cal.get(14);
    }

    private void advanceDay(Calendar cal, boolean forward) {
        this.setToDayStart(cal);
        if (forward) {
            cal.add(6, 1);
        } else {
            cal.add(14, -1);
        }
    }

    private Calendar setToDayStart(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private List<Timespan> subtractAbsences(Timespan span) {
        ArrayList<Timespan> subspans = new ArrayList<Timespan>();
        long start = span.getStart().getTime();
        long end = span.getEnd().getTime();
        for (BookedTimespan absence : this.fBookedTimespans) {
            long absenceStart = absence.getStart().getTime();
            long absenceEnd = absence.getEnd().getTime();
            if (absenceEnd <= start) continue;
            if (absenceStart <= start) {
                start = Math.min(absenceEnd, end);
            } else {
                subspans.add(new Timespan(new Date(start), new Date(Math.min(absenceStart, end))));
                start = Math.min(absenceEnd, end);
            }
            if (start >= end) break;
        }
        if (start < end) {
            subspans.add(new Timespan(new Date(start), new Date(end)));
        }
        return subspans;
    }

    private Calendar getNextDayStart(Date d) {
        Calendar nextDay = this.getCalendarInstance(d.getTime());
        nextDay.add(7, 1);
        this.setToDayStart(nextDay);
        return nextDay;
    }

    private Calendar getDayStart(Date d) {
        Calendar dayStart = this.getCalendarInstance(d.getTime());
        this.setToDayStart(dayStart);
        return dayStart;
    }

    private long intersectionDuration(Timespan A, Timespan B) {
        long start = Math.max(A.getStart().getTime(), B.getStart().getTime());
        long end = Math.min(A.getEnd().getTime(), B.getEnd().getTime());
        return Math.max(end - start, 0L);
    }

    private long oneDayDuration(Timespan timespanContainedInADay) {
        Calendar cal = this.getCalendarInstance(timespanContainedInADay.getStart().getTime());
        IWorkDayDefinition workDay = this.fWorkDays[cal.get(7) - 1];
        if (workDay != null && workDay.getWorkingTime() > 0L) {
            this.setToDayStart(cal);
            cal.add(14, (int)workDay.getEndTime());
            Date endTime = new Date(cal.getTimeInMillis());
            cal.add(14, -((int)workDay.getWorkingTime()));
            Date startTime = new Date(cal.getTimeInMillis());
            return this.intersectionDuration(timespanContainedInADay, new Timespan(startTime, endTime));
        }
        return 0L;
    }

    private int fullDaysBetween(Calendar from, Calendar to) {
        long fromMillis = from.getTimeInMillis() + (long)from.getTimeZone().getOffset(from.getTimeInMillis());
        long toMillis = to.getTimeInMillis() + (long)to.getTimeZone().getOffset(to.getTimeInMillis());
        return (int)((toMillis - fromMillis) / 86400000L);
    }

    private long calculateWokingTimeWithoutAbsences(Timespan timespan) {
        Calendar firstFullDayStart = this.getNextDayStart(timespan.getStart());
        Calendar lastDayStart = this.getDayStart(timespan.getEnd());
        long duration = 0L;
        if (new Date(firstFullDayStart.getTimeInMillis()).after(timespan.getEnd())) {
            duration = this.oneDayDuration(timespan);
        } else {
            Calendar firstDayEnd = (Calendar)firstFullDayStart.clone();
            firstDayEnd.add(14, -1);
            duration = this.oneDayDuration(new Timespan(timespan.getStart(), new Date(firstDayEnd.getTimeInMillis())));
            duration += this.oneDayDuration(new Timespan(new Date(lastDayStart.getTimeInMillis()), timespan.getEnd()));
            if (firstFullDayStart.before(lastDayStart)) {
                int fullDaysBetween = this.fullDaysBetween(firstFullDayStart, lastDayStart);
                int fullWeeksBetween = fullDaysBetween / 7;
                int[] numberOfFullDays = new int[7];
                int i = 0;
                while (i < 7) {
                    numberOfFullDays[i] = fullWeeksBetween;
                    ++i;
                }
                int firstDayOfWeek = firstFullDayStart.get(7) - 1;
                int weeksModulo = fullDaysBetween % 7;
                int i2 = 0;
                while (i2 < weeksModulo) {
                    int n = (i2 + firstDayOfWeek) % 7;
                    numberOfFullDays[n] = numberOfFullDays[n] + 1;
                    ++i2;
                }
                i2 = 0;
                while (i2 < 7) {
                    long workingTimePerDay = Math.max(this.fWorkDays[i2] != null ? this.fWorkDays[i2].getWorkingTime() : 0L, 0L);
                    duration += (long)numberOfFullDays[i2] * workingTimePerDay;
                    ++i2;
                }
            }
        }
        return duration;
    }

    private class BookedTimespan
    extends Timespan {
        private final IBookedTime fOriginalEntry;

        public BookedTimespan(Date start, Date end, IBookedTime originalEntry) {
            super(start, end);
            this.fOriginalEntry = originalEntry;
        }

        public IBookedTime getOriginalEntry() {
            return this.fOriginalEntry;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.fOriginalEntry.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj) || this.fOriginalEntry.equals(((BookedTimespan)obj).fOriginalEntry);
        }
    }
}

