/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.api.common.internal.CombinedIdentifier;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ReferenceAttributeProvider
implements ICachingSupport {
    public static final String IS_SINGLE_VALUED_PARAM_NAME = "isSingleValued";
    public static final String IS_USER_MODIFIABLE_PARAM_NAME = "isUserModifiable";
    public static final String OTHER_REF_PARAM_NAME = "otherRef";
    public static final String IS_MASTER_PARAM_NAME = "isMaster";
    public static final String IS_SOURCE_PARAM_NAME = "isSource";
    public static final String LINK_TYPE_PARAM_NAME = "linkType";
    private static final String IMPLEMENTATION_NAME = "com.ibm.team.apt.client.ReferenceAttribute";
    private static final String SYN_REF_ATTR = "planning";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private final List<IProjectLink> fActiveProjectLinks;

    public ReferenceAttributeProvider(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IAuditableCommon auditableCommon = process.getAuditableCommon();
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)process.getProjectArea(), ItemProfile.PROJECT_AREA_LINKS_ONLY, (IProgressMonitor)progress.newChild(1));
        this.fActiveProjectLinks = auditableCommon.resolveAuditables(Arrays.asList(projectArea.getProjectLinks()), ItemProfile.PROJECT_LINK_DEFAULT, (IProgressMonitor)progress.newChild(1));
    }

    public ReferenceAttributeProvider(IPlanningItemStore.IPlanningProcessStore process, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IProjectArea projectArea = process.getProjectArea();
        this.fActiveProjectLinks = process.getPlanningItemStore().fetchItems(Arrays.asList(projectArea.getProjectLinks()), ItemProfile.PROJECT_LINK_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
    }

    public Collection<IAttributeDefinitionDescriptor> getAllReferenceAttributes() {
        ArrayList<IAttributeDefinitionDescriptor> result = new ArrayList<IAttributeDefinitionDescriptor>();
        Collection linkTypes = ILinkTypeRegistry.INSTANCE.allEntries();
        for (ILinkType linkType : linkTypes) {
            boolean isUserModifiable;
            CALMLinkTypeInformation calmLinkInfo;
            if (linkType.isInternal() || (calmLinkInfo = CALMLinkTypeInformationRegistry.getLinkTypeInformation((ILinkType)linkType)) != null && !calmLinkInfo.hasServiceProviders(this.fActiveProjectLinks)) continue;
            IEndPointDescriptor sourceDescriptor = linkType.getSourceEndPointDescriptor();
            IEndPointDescriptor targetDescriptor = linkType.getTargetEndPointDescriptor();
            boolean supportsTarget = ReferenceAttributeProvider.isWorkItemReference(sourceDescriptor, calmLinkInfo);
            boolean supportsSource = !WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)sourceDescriptor) && ReferenceAttributeProvider.isWorkItemReference(linkType.getTargetEndPointDescriptor(), calmLinkInfo);
            boolean bl = isUserModifiable = WorkItemLinkTypes.isUserWritable((ILinkType)linkType) || calmLinkInfo != null && calmLinkInfo.hasPickerServiceDescriptionForTarget();
            if (supportsTarget) {
                result.add(this.createAttributeDescriptor(targetDescriptor, supportsSource && supportsTarget, isUserModifiable, targetDescriptor.isSingleValued()));
            }
            if (!supportsSource) continue;
            result.add(this.createAttributeDescriptor(sourceDescriptor, supportsSource && supportsTarget, isUserModifiable, sourceDescriptor.isSingleValued()));
        }
        return result;
    }

    public IAttributeDefinitionDescriptor getReferenceAttribute(String identifier) {
        IEndPointDescriptor descriptor;
        CombinedIdentifier combinedIdentifier = new CombinedIdentifier(identifier);
        if (!combinedIdentifier.first().equals(SYN_REF_ATTR)) {
            return null;
        }
        ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(combinedIdentifier.third());
        if (linkType == null) {
            return null;
        }
        CALMLinkTypeInformation calmLinkInfo = CALMLinkTypeInformationRegistry.getLinkTypeInformation((ILinkType)linkType);
        if (calmLinkInfo != null && !calmLinkInfo.hasServiceProviders(this.fActiveProjectLinks)) {
            return null;
        }
        boolean isSource = !combinedIdentifier.second().equals(SOURCE);
        IEndPointDescriptor iEndPointDescriptor = descriptor = isSource ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
        boolean hasSpouse = !WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)descriptor) && ReferenceAttributeProvider.isWorkItemReference(isSource ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor(), calmLinkInfo);
        boolean isUserModifiable = WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)descriptor) || calmLinkInfo != null && calmLinkInfo.hasPickerServiceDescriptionForTarget();
        return this.createAttributeDescriptor(descriptor, hasSpouse, isUserModifiable, descriptor.isSingleValued());
    }

    private static boolean isWorkItemReference(IEndPointDescriptor descriptor, CALMLinkTypeInformation calmLinkInfo) {
        IItemType itemType = descriptor.getReferencedItemType();
        if (itemType != null && IWorkItem.ITEM_TYPE.equals(itemType)) {
            return true;
        }
        if (!descriptor.isItemReference() && calmLinkInfo != null) {
            return calmLinkInfo.getTargetResourceId().equals(OSLCResourceDescription.ID_CM_CHANGE_REQUEST);
        }
        return false;
    }

    private IAttributeDefinitionDescriptor createAttributeDescriptor(IEndPointDescriptor endPoint, boolean hasSpouse, boolean isUserModfiable, boolean isSingleValued) {
        boolean isSource = !endPoint.isSource();
        boolean isMaster = isSource || !hasSpouse;
        String linkTypeId = endPoint.getLinkType().getLinkTypeId();
        IEndPointDescriptor otherEndPoint = endPoint.isSource() ? endPoint.getLinkType().getTargetEndPointDescriptor() : endPoint.getLinkType().getSourceEndPointDescriptor();
        IAttributeDefinitionDescriptor result = ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
        result.setId(CombinedIdentifier.of((Object[])new Object[]{SYN_REF_ATTR, isSource ? SOURCE : TARGET, linkTypeId}));
        result.setDisplayName(this.getEndPointDisplayName(endPoint));
        result.setReadOnly(!isUserModfiable);
        String queryId = this.getEndPointId(endPoint);
        result.setQueryId(this.createQueryId(queryId, IWorkItem.ITEM_TYPE.equals(otherEndPoint.getReferencedItemType())));
        result.setType(PlanningAttributeType.REFERENCE);
        result.setImplementationName(IMPLEMENTATION_NAME);
        IParameter[] parameters = new IParameter[]{IParameter.FACTORY.create(LINK_TYPE_PARAM_NAME, linkTypeId), IParameter.FACTORY.create(IS_SOURCE_PARAM_NAME, String.valueOf(isSource)), IParameter.FACTORY.create(IS_MASTER_PARAM_NAME, String.valueOf(isMaster)), IParameter.FACTORY.create(OTHER_REF_PARAM_NAME, CombinedIdentifier.of((Object[])new Object[]{SYN_REF_ATTR, !isSource ? SOURCE : TARGET, linkTypeId})), IParameter.FACTORY.create(IS_USER_MODIFIABLE_PARAM_NAME, String.valueOf(isUserModfiable)), IParameter.FACTORY.create(IS_SINGLE_VALUED_PARAM_NAME, String.valueOf(isSingleValued))};
        result.setParameters(parameters);
        return result;
    }

    private String getEndPointDisplayName(IEndPointDescriptor endPointDescriptor) {
        return endPointDescriptor.getDisplayName();
    }

    private String getEndPointId(IEndPointDescriptor endPointDescriptor) {
        return this.getCombinedIdentifier(endPointDescriptor);
    }

    private String getCombinedIdentifier(IEndPointDescriptor endPointDescriptor) {
        ILinkType linkType = endPointDescriptor.getLinkType();
        boolean isSource = linkType.getSourceEndPointDescriptor().equals(endPointDescriptor);
        return CombinedIdentifier.of((Object[])new Object[]{linkType.getLinkTypeId(), isSource});
    }

    private String createQueryId(String id, boolean isQueryable) {
        if (!isQueryable) {
            return null;
        }
        id = id.replaceAll("\\s", "");
        id = String.valueOf(id.substring(0, 1).toLowerCase()) + id.substring(1);
        return id;
    }

    @Override
    public <T> T get(String identifier, Class<T> type) {
        if (type.equals(IAttributeDefinitionDescriptor.class)) {
            return (T)this.getReferenceAttribute(identifier);
        }
        return null;
    }

    @Override
    public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    @Override
    public void add(ICacheEntryState node, String identifier, Object value) {
    }
}

