/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.APTCommon;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.InvalidConfigurationException;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanItemsDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.apt.internal.common.util.SerializeHelper;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PlanningConfigurationValidator {
    private static final List<Class<? extends IConfigurationElement>> types = new ArrayList<Class<? extends IConfigurationElement>>();
    private final IPlanningCommon fPlanningCommon;

    static {
        types.add(IFilterDescription.class);
        types.add(ISortModeDescription.class);
        types.add(IViewModeDescription.class);
        types.add(IGroupModeDescription.class);
        types.add(IPlanModeDescription.class);
        types.add(IPlanItemsDescription.class);
        types.add(IPlanCheckDescription.class);
        types.add(IPlanType.class);
        types.add(IAttributeDefinitionDescriptor.class);
    }

    public PlanningConfigurationValidator(IPlanningCommon planningCommon) {
        this.fPlanningCommon = planningCommon;
    }

    public void performValidationIfNeeded(IWorkItemCommon workItemCommon, IProjectAreaHandle projectArea, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.needsValidation(projectArea)) {
            this.performValidation(workItemCommon, projectArea, itemStore, monitor);
        }
    }

    public void performValidation(IWorkItemCommon workItemCommon, IProjectAreaHandle projectAreaHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        IParameter parameter;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + types.size() + 2 + 2));
        IPlanningItemStore.IPlanningProcessStore process = itemStore.getProcessStore((IProcessAreaHandle)projectAreaHandle, (IProgressMonitor)progress.newChild(1));
        for (Class<? extends IConfigurationElement> type : types) {
            try {
                this.fPlanningCommon.findConfigurationElements2(type, process, (IProgressMonitor)progress.newChild(1));
            }
            catch (TeamRepositoryException e) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_CONFIG_ELEMENT"), (Object)type.getName(), (Object[])new Object[0]), e);
            }
        }
        List<IAttributeDefinitionDescriptor> planningAttributes = this.fPlanningCommon.findConfigurationElements2(IAttributeDefinitionDescriptor.class, process, (IProgressMonitor)progress.newChild(1));
        List workItemAttributes = workItemCommon.findAttributes(projectAreaHandle, (IProgressMonitor)progress.newChild(1));
        HashMap<String, IAttribute> attributeIds = new HashMap<String, IAttribute>();
        for (IAttribute workItemAttribute : workItemAttributes) {
            attributeIds.put(workItemAttribute.getIdentifier(), workItemAttribute);
        }
        for (IAttributeDefinitionDescriptor planAttribute : planningAttributes) {
            Identifier<IAttribute> attributeIdentifier = PlanItemAttributes.getAttributeId(planAttribute);
            if (PlanItemAttributes.isWorkItemProxied(planAttribute) && attributeIdentifier == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_WORK_ITEM_ATTR_PROXY"), (Object)planAttribute.getId(), (Object[])new Object[0]));
            }
            if (attributeIdentifier == null || !PlanItemAttributes.isWorkItemProxied(planAttribute) && !PlanItemAttributes.isBuiltIn(planAttribute)) continue;
            String identifier = attributeIdentifier.getStringIdentifier();
            IAttribute attribute2 = (IAttribute)attributeIds.get(identifier);
            if (attribute2 == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_WORK_ITEM_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[]{identifier}));
            }
            try {
                SerializeHelper.getAttributeType(attribute2);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_ATTRIBUTE_TYPE_NOT_SUPPORTED"), (Object)attribute2.getAttributeType(), (Object[])new Object[]{planAttribute.getId()}));
            }
        }
        IComplexityAttribute complexity = this.fPlanningCommon.findComplexityAttribute2((IProcessAreaHandle)process.getProjectArea(), itemStore, (IProgressMonitor)progress.newChild(1));
        if (complexity != null) {
            IParameter[] params;
            IAttributeDefinitionDescriptor attribute = this.fPlanningCommon.findConfigurationElement2(IAttributeDefinitionDescriptor.class, complexity.getAttributeId(), process, (IProgressMonitor)progress.newChild(1));
            if (attribute == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_COMPLEXITY_ATTR"), (Object)complexity.getAttributeId(), (Object[])new Object[0]));
            }
            attribute = this.fPlanningCommon.findConfigurationElement2(IAttributeDefinitionDescriptor.class, "com.ibm.team.apt.attribute.planitem.complexity", process, (IProgressMonitor)progress.newChild(1));
            IParameter[] iParameterArray = params = attribute.getParameters();
            int n = params.length;
            int attribute2 = 0;
            while (attribute2 < n) {
                parameter = iParameterArray[attribute2];
                if (parameter.getKey().equals("attribute")) {
                    String value = parameter.getValue();
                    if (!value.equals("com.ibm.team.apt.attribute.planitem.complexity")) break;
                    throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_CYCLIC_COMPLEXITY_ATTR"), (Object)complexity.getAttributeId(), (Object[])new Object[0]));
                }
                ++attribute2;
            }
        }
        for (IAttributeDefinitionDescriptor planAttribute : planningAttributes) {
            if (!APTCommon.isRanking(planAttribute.getImplementationName())) continue;
            parameter = IParameter.FACTORY.findFirst("attribute", planAttribute.getParameters());
            if (parameter == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_RANKING_NO_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[0]));
            }
            IAttributeDefinitionDescriptor attribute = this.fPlanningCommon.findConfigurationElement2(IAttributeDefinitionDescriptor.class, parameter.getValue(), process, (IProgressMonitor)progress.newChild(1));
            if (attribute != null) continue;
            throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_RANKING_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[]{parameter.getValue()}));
        }
        Map<String, Iterations.BacklogPair> backlogInfo = Iterations.getBacklogInformation(projectAreaHandle, this.fPlanningCommon, itemStore, monitor);
        for (Map.Entry<String, Iterations.BacklogPair> backlogEntry : backlogInfo.entrySet()) {
            if (backlogEntry.getValue().errorMessage == null) continue;
            throw new InvalidConfigurationException(backlogEntry.getValue().errorMessage);
        }
        this.storeValidationMarker(itemStore, projectAreaHandle, monitor);
    }

    protected boolean needsValidation(IProjectAreaHandle handle) {
        ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return true;
        }
        return cache.get(PlanningConfigurationValidator.asIdentifier((IItemHandle)handle), Object.class) == null;
    }

    protected void storeValidationMarker(IPlanningItemStore itemStore, IProjectAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)itemStore.fetchItem((IItemHandle)handle, ItemProfile.PROJECT_AREA_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        cache.add(new ItemState((IItem)projectArea), PlanningConfigurationValidator.asIdentifier((IItemHandle)projectArea), new Object());
    }

    protected static String asIdentifier(IItemHandle item) {
        return "__validationMarker@" + item.getItemId().getUuidValue();
    }

    private static class ItemState
    implements ICacheEntryState {
        private final IItem fItem;

        public ItemState(IItem item) {
            this.fItem = item;
        }

        @Override
        public UUID getOrigin() {
            return this.fItem.getItemId();
        }

        @Override
        public Object getState() {
            return this.fItem.getStateId();
        }
    }
}

