/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.ReferenceAttributeProvider;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.nucleus.query.BaseIterationPlanRecordQueryModel;
import com.ibm.team.apt.internal.common.plantype.DefaultPlanType;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IBacklogIteration;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.process.AuditablePlanningItemStore;
import com.ibm.team.apt.internal.common.process.CompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.ProcessConfigurationNodeProvider;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.common.util.UniqueFilterMutator;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ILicenseService;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PlanningCommonImpl
implements IPlanningCommon {
    private static final String ID_SPRINT_BACKLOG = "com.ibm.team.apt.plantype.default";
    private static final String ID_TEAM_RELEASE_BACKLOG = "com.ibm.team.apt.plantype.release";
    private static final String ID_PROJECT_RELEASE_BACKLOG = "com.ibm.team.apt.plantype.release.project";
    private static final String ID_PRODUCT_BACKLOG = "com.ibm.team.apt.plantype.product.backlog";
    private final StaticConfigurationDataRegistry fRegistry = StaticConfigurationDataRegistry.getInstance();
    private final ICommonServiceContext fServiceContext;
    private final Map<Locale, Map<UUID, ConfigurationElementCache>> fLocale2ProjectArea2Cache = new LinkedHashMap<Locale, Map<UUID, ConfigurationElementCache>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Locale, Map<UUID, ConfigurationElementCache>> eldest) {
            return this.size() >= 8;
        }
    };
    private final List<IConfigurationElementMassage<?>> fMassages = new ArrayList();
    private final IPlanningItemStore fDefaultItemStore;
    private final IAuditableCommon fAuditableCommon;
    private static final String TIMETRACKING_CONFIG_POINT = "com.ibm.team.tpt.timetracking";
    private static final String TIMETRACKING_SYNC_FLAG = "syncTimeSpentWithTimeTracking";
    private static final String TIMETRACKING_CFG_ELEMENT = "timeTrackingSpecification";

    public PlanningCommonImpl(ICommonServiceContext serviceContext, IAuditableCommon auditableCommon, ILicenseService licenseServer) {
        this.fServiceContext = serviceContext;
        this.fAuditableCommon = auditableCommon;
        this.fDefaultItemStore = new AuditablePlanningItemStore(auditableCommon);
    }

    @Override
    public IComplexityAttribute findComplexityAttribute2(IProcessAreaHandle processArea, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        return ConfigurationElementFactory.singleInstance(IComplexityAttribute.class, new ProcessConfigurationNodeProvider(itemStore.getProcessStore(processArea, monitor)), monitor);
    }

    @Override
    public List<IPlanType> findPlanTypes2(IPlanningItemStore.IPlanningProcessStore process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findConfigurationElements2(IPlanType.class, process, monitor);
    }

    @Override
    public <T extends IConfigurationElement> List<T> findConfigurationElements2(final Class<T> type, final IPlanningItemStore.IPlanningProcessStore process, final IProgressMonitor monitor) throws TeamRepositoryException {
        List result = null;
        String identifier = type.getName();
        result = this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea()).getCollection(identifier, type);
        if (result == null) {
            final IFilter<INode> ensureUnique = new IFilter<INode>(){
                private final HashSet<String> fIds = new HashSet();

                @Override
                public boolean accept(INode element) {
                    return this.fIds.add(element.getAttribute("id"));
                }
            };
            ServiceRunnable runnable = new ServiceRunnable<List<T>>(){

                public List<T> run() throws TeamRepositoryException {
                    CompositeNodeProvider provider = new CompositeNodeProvider(PlanningCommonImpl.this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea()), new ReferenceAttributeProvider(process, monitor), new ProcessConfigurationNodeProvider(process), PlanningCommonImpl.this.fRegistry);
                    return ConfigurationElementFactory.allInstances(type, ensureUnique, provider, PlanningCommonImpl.this.getConfigurationElementMassages(), monitor);
                }
            };
            result = (List)this.fServiceContext.callCancelableService(runnable, monitor);
            ConfigurationElementCache cache = this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea());
            if (IAttributeDefinitionDescriptor.class.equals(type)) {
                Collection<IAttributeDefinitionDescriptor> referenceAttributes = new ReferenceAttributeProvider(process, monitor).getAllReferenceAttributes();
                for (IAttributeDefinitionDescriptor descriptor : referenceAttributes) {
                    cache.add(PlanningCommonImpl.createCachingKey(process), descriptor.getId(), descriptor);
                }
                result.addAll(referenceAttributes);
            }
            new UniqueFilterMutator(result).filter();
            cache.registerCollection(identifier, Collections.unmodifiableList(result));
        }
        return new ArrayList<T>(result);
    }

    @Override
    public IPlanType findPlanType2(IPlanningItemStore.IPlanningProcessStore process, String planTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        IPlanType planType;
        if (planTypeId.equals(DefaultPlanType.INSTANCE.getId())) {
            planTypeId = ID_SPRINT_BACKLOG;
        }
        if ((planType = this.findConfigurationElement2(IPlanType.class, planTypeId, process, monitor)) == null && !planTypeId.equals(ID_SPRINT_BACKLOG)) {
            APTCommonPlugin.log(NLS.bind((String)Messages.getString("PlanningCommonImpl.ERROR_PLAN_TYPE_NOT_FOUND"), (Object)planTypeId, (Object[])new Object[]{ID_SPRINT_BACKLOG}), null);
            planType = this.findConfigurationElement2(IPlanType.class, ID_SPRINT_BACKLOG, process, monitor);
        }
        if (planType == null) {
            planType = DefaultPlanType.INSTANCE;
            APTCommonPlugin.log(NLS.bind((String)Messages.getString("PlanningCommonImpl.ERROR_USING_DEFAULT_PLAN_TYPE"), (Object)planTypeId, (Object[])new Object[0]), null);
        }
        return planType;
    }

    @Override
    public <T extends IConfigurationElement> T findConfigurationElementInCache(Class<T> type, String identifier, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ConfigurationElementCache cache = this.getConfigurationElementCache(projectArea);
        return (T)((IConfigurationElement)cache.get(identifier, type));
    }

    @Override
    public <T extends IConfigurationElement> T findConfigurationElement2(final Class<T> type, final String identifier, IPlanningItemStore.IPlanningProcessStore process, final IProgressMonitor monitor) throws TeamRepositoryException {
        IConfigurationElement result = (IConfigurationElement)this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea()).get(identifier, type);
        if (result != null) {
            return (T)result;
        }
        if (IAttributeDefinitionDescriptor.class.equals(type) && (result = new ReferenceAttributeProvider(process, monitor).getReferenceAttribute(identifier)) != null) {
            this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea()).add(PlanningCommonImpl.createCachingKey(process), identifier, result);
            return (T)result;
        }
        final CompositeNodeProvider provider = new CompositeNodeProvider(this.getConfigurationElementCache((IProjectAreaHandle)process.getProjectArea()), new ReferenceAttributeProvider(process, monitor), new ProcessConfigurationNodeProvider(process), this.fRegistry);
        final IFilter<INode> filter = new IFilter<INode>(){

            @Override
            public boolean accept(INode element) {
                return identifier != null && identifier.equals(element.getAttribute("id"));
            }
        };
        ServiceRunnable runnable = new ServiceRunnable<T>(){

            public T run() throws TeamRepositoryException {
                return (IConfigurationElement)ConfigurationElementFactory.singleInstance(type, filter, provider, PlanningCommonImpl.this.getConfigurationElementMassages(), monitor);
            }
        };
        return (T)((IConfigurationElement)this.fServiceContext.callCancelableService(runnable, monitor));
    }

    private static ICacheEntryState createCachingKey(final IPlanningItemStore.IPlanningProcessStore process) throws TeamRepositoryException {
        final Object projectAreaETag = ProcessConfigurationNodeProvider.getProjectAreaETag(process, null);
        return new ICacheEntryState(){

            @Override
            public Object getState() {
                return projectAreaETag;
            }

            @Override
            public UUID getOrigin() {
                return process.getProjectArea().getItemId();
            }
        };
    }

    @Override
    public List<IConfigurationElementMassage<?>> getConfigurationElementMassages() {
        return this.fMassages;
    }

    @Override
    public synchronized ConfigurationElementCache getConfigurationElementCacheIfExists(IProjectAreaHandle projectArea) {
        return this.getConfigurationElementCacheIfExists(projectArea, Arrays.asList(Locale.getDefault()));
    }

    protected synchronized ConfigurationElementCache getConfigurationElementCacheIfExists(IProjectAreaHandle projectArea, List<Locale> locales) {
        Map<UUID, ConfigurationElementCache> map = this.fLocale2ProjectArea2Cache.get(PlanningCommonImpl.getLocale(locales));
        if (map != null) {
            return map.get(projectArea.getItemId());
        }
        return null;
    }

    @Override
    public synchronized ConfigurationElementCache getConfigurationElementCache(IProjectAreaHandle projectArea) {
        return this.getConfigurationElementCache(projectArea, Arrays.asList(Locale.getDefault()));
    }

    public synchronized void clearCaches(IProjectAreaHandle projectArea) {
        UUID key = projectArea.getItemId();
        for (Map<UUID, ConfigurationElementCache> next : this.fLocale2ProjectArea2Cache.values()) {
            ConfigurationElementCache cache = next.remove(key);
            if (cache == null) continue;
            cache.clear();
        }
    }

    protected synchronized ConfigurationElementCache getConfigurationElementCache(IProjectAreaHandle projectArea, List<Locale> locales) {
        ConfigurationElementCache result;
        Locale locale = PlanningCommonImpl.getLocale(locales);
        Map<UUID, ConfigurationElementCache> map = this.fLocale2ProjectArea2Cache.get(locale);
        if (map == null) {
            map = new HashMap<UUID, ConfigurationElementCache>();
            this.fLocale2ProjectArea2Cache.put(locale, map);
        }
        if ((result = map.get(projectArea.getItemId())) == null) {
            result = new ConfigurationElementCache();
            map.put(projectArea.getItemId(), result);
        }
        return result;
    }

    private static Locale getLocale(List<Locale> locales) {
        if (locales.isEmpty()) {
            return Locale.getDefault();
        }
        return locales.get(0);
    }

    @Override
    public IItemQueryPage fetchRelatedPlans2(IIterationPlanRecordHandle planHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Node<IIteration> contextIterations = this.fetchContextIterations2(planHandle, itemStore, (IProgressMonitor)progress.newChild(1));
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        if (!contextIterations.getChildren().isEmpty()) {
            int size = contextIterations.getChildren().size();
            iterations.add(contextIterations.getChildren().get(size - 1).getElement());
        }
        while (!contextIterations.getChildren().isEmpty()) {
            if (contextIterations.getElement() != null) {
                iterations.add(contextIterations.getElement());
            }
            contextIterations = contextIterations.getChildren().get(0);
        }
        if (iterations.isEmpty()) {
            return null;
        }
        IIterationPlanRecord plan = (IIterationPlanRecord)itemStore.fetchItem((IItemHandle)planHandle, IIterationPlanRecord.MEDIUM_PROFILE.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        IProcessAreaHandle owner = plan.getOwner();
        BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel model = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        Object[] params = new Object[iterations.size() + 1 + 1];
        IItemHandleInputArg[] args = new IItemHandleInputArg[iterations.size()];
        ListIterator iter = iterations.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            args[index] = query.newItemHandleArg();
            params[index] = iter.next();
        }
        params[params.length - 2] = owner.getItemId();
        params[params.length - 1] = plan.getItemId();
        IPredicate predicate = model.owner().itemId()._eq((IUUID)query.newUUIDArg())._and(model.iteration()._in(args))._and(query.not(model.itemId()._eq((IUUID)query.newUUIDArg())));
        query.distinct();
        query.filter(predicate);
        query.orderByAsc((IField)model.iteration().internalEndDate());
        query.orderByAsc((IField)model.iteration().internalStartDate());
        query.orderByAsc((IField)model.iteration().name());
        query.orderByAsc((IField)model.iteration().archived());
        query.orderByAsc((IField)model.name());
        return this.fAuditableCommon.queryItems(query, params, 512, (IProgressMonitor)progress.newChild(1));
    }

    @Override
    public Node<IIteration> fetchContextIterations2(IIterationPlanRecordHandle planHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IIterationPlanRecord plan = (IIterationPlanRecord)itemStore.fetchItem((IItemHandle)planHandle, IIterationPlanRecord.MEDIUM_PROFILE.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        IIteration iteration = (IIteration)itemStore.fetchItem((IItemHandle)plan.getIteration(), ItemProfile.ITERATION_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        IDevelopmentLine timeline = (IDevelopmentLine)itemStore.fetchItem((IItemHandle)iteration.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        Node<IIteration> iterations = Iterations.fetchIterationTree((IDevelopmentLineHandle)timeline, itemStore, (IProgressMonitor)progress.newChild(1));
        IIteration currentIteration = Iterations.fetchCurrentIteration((IDevelopmentLineHandle)timeline, itemStore, (IProgressMonitor)progress.newChild(1));
        Node<IIteration> nodeCurrentIteration = currentIteration != null ? iterations.depthFirstIterator(new IItemFilter(this, (IItemHandle)currentIteration)).next() : null;
        IIteration backlogIteration = this.fetchBacklogIteration((IDevelopmentLineHandle)timeline, itemStore, (IProgressMonitor)progress.newChild(1));
        Node<Object> result = new Node<Object>(null, null);
        if (nodeCurrentIteration != null) {
            Node<Object> parent = result;
            Node<IIteration> subtree = nodeCurrentIteration;
            ArrayList<IIteration> releaseIterations = new ArrayList<IIteration>();
            while (!subtree.isRoot() && subtree.getElement() != null) {
                releaseIterations.add(0, subtree.getElement());
                subtree = subtree.getParent();
            }
            for (IIteration releaseIteration : releaseIterations) {
                Node<IIteration> node = new Node<IIteration>(parent, releaseIteration);
                parent.getChildren().add(node);
                parent = node;
            }
            int c = 4;
            Node<IIteration> sibling = nodeCurrentIteration;
            while (sibling != null && c > 0) {
                parent.getChildren().add(new Node<IIteration>(parent, sibling.getElement()));
                sibling = sibling.nextSibling();
                --c;
            }
            while (!parent.isRoot()) {
                Node<IIteration> parentNode = iterations.depthFirstIterator(new IItemFilter(this, (IItemHandle)((IIteration)parent.getElement()))).next();
                Node<IIteration> parentSibling = parentNode.nextSibling();
                parent = parent.getParent();
                if (parentSibling == null) continue;
                parent.getChildren().add(new Node<IIteration>(parent, parentSibling.getElement()));
            }
        }
        if (backlogIteration != null) {
            result.getChildren().add(new Node<IIteration>(result, backlogIteration));
        }
        return result;
    }

    @Override
    public IPlanType fetchPlanType2(IProcessAreaHandle processAreaHandle, IIterationHandle iterationHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        IIteration backlogIteration;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IPlanningItemStore.IPlanningProcessStore process = itemStore.getProcessStore(processAreaHandle, (IProgressMonitor)progress.newChild(1));
        IIteration iteration = (IIteration)itemStore.fetchItem((IItemHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        if (iteration.sameItemId((IItemHandle)(backlogIteration = this.fetchBacklogIteration(iteration.getDevelopmentLine(), itemStore, (IProgressMonitor)progress.newChild(1))))) {
            return this.findPlanType2(process, ID_PRODUCT_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        Node<IIteration> tree = Iterations.fetchIterationTree((IIterationHandle)iteration, itemStore, (IProgressMonitor)progress.newChild(1));
        if (tree.getChildren().isEmpty()) {
            return this.findPlanType2(process, ID_SPRINT_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        IProcessArea owner = (IProcessArea)itemStore.fetchItem((IItemHandle)processAreaHandle, new String[]{IItem.ITEM_ID_PROPERTY}, monitor);
        if (owner instanceof IProjectAreaHandle) {
            return this.findPlanType2(process, ID_PROJECT_RELEASE_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        return this.findPlanType2(process, ID_TEAM_RELEASE_BACKLOG, (IProgressMonitor)progress.newChild(1));
    }

    protected IIteration fetchBacklogIteration(IDevelopmentLineHandle timelineHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IDevelopmentLine timeline = (IDevelopmentLine)itemStore.fetchItem((IItemHandle)timelineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        IPlanningItemStore.IPlanningProcessStore process = itemStore.getProcessStore((IProcessAreaHandle)timeline.getProjectArea(), (IProgressMonitor)progress.newChild(1));
        IBacklogIteration backlogIteration = this.findConfigurationElement2(IBacklogIteration.class, timeline.getId(), process, (IProgressMonitor)progress.newChild(1));
        return backlogIteration != null ? Iterations.resolveIterationFromPath((IProcessAreaHandle)timeline.getProjectArea(), backlogIteration.getPath(), itemStore, (IProgressMonitor)progress.newChild(1)) : null;
    }

    @Override
    public List<IPlanType> findPlanTypes(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findPlanTypes2(new AuditablePlanningItemStore.AuditablePlanningProcessStore(this.fDefaultItemStore, process), monitor);
    }

    @Override
    public IPlanType findPlanType(IAuditableCommonProcess process, String planTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findPlanType2(new AuditablePlanningItemStore.AuditablePlanningProcessStore(this.fDefaultItemStore, process), planTypeId, monitor);
    }

    @Override
    public <T extends IConfigurationElement> List<T> findConfigurationElements(Class<T> type, IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findConfigurationElements2(type, new AuditablePlanningItemStore.AuditablePlanningProcessStore(this.fDefaultItemStore, process), monitor);
    }

    @Override
    public <T extends IConfigurationElement> T findConfigurationElement(Class<T> type, String identifier, IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findConfigurationElement2(type, identifier, new AuditablePlanningItemStore.AuditablePlanningProcessStore(this.fDefaultItemStore, process), monitor);
    }

    @Override
    public IComplexityAttribute findComplexityAttribute(IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findComplexityAttribute2(processArea, this.fDefaultItemStore, monitor);
    }

    @Override
    public Node<IIteration> fetchContextIterations(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchContextIterations2(planHandle, this.fDefaultItemStore, monitor);
    }

    @Override
    public IPlanType fetchPlanType(IProcessAreaHandle processAreaHandle, IIterationHandle iterationHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchPlanType2(processAreaHandle, iterationHandle, this.fDefaultItemStore, monitor);
    }

    @Override
    public IItemQueryPage fetchRelatedPlans(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchRelatedPlans2(planHandle, this.fDefaultItemStore, monitor);
    }

    public void validateCache(IProcessAreaHandle processAreaHandle, IPlanningItemStore itemStore, long validationInterval) throws TeamRepositoryException {
        IPlanningItemStore.IPlanningProcessStore processStore = itemStore.getProcessStore(processAreaHandle, null);
        IProjectArea projectArea = processStore.getProjectArea();
        ConfigurationElementCache cache = this.getConfigurationElementCacheIfExists((IProjectAreaHandle)projectArea);
        if (cache == null) {
            return;
        }
        Long timestamp = cache.getLastValidationTime();
        if (timestamp != null && System.currentTimeMillis() - timestamp < validationInterval) {
            return;
        }
        final boolean[] projectAreaValid = new boolean[]{true};
        final Object state = ProcessConfigurationNodeProvider.getProjectAreaETag(processStore, (IProgressMonitor)new NullProgressMonitor());
        cache.validate(projectArea.getItemId(), new ConfigurationElementCache.IInvalidationStrategy(){

            @Override
            public boolean validate(Object cachedState) {
                boolean valid = state.equals(cachedState);
                projectAreaValid[0] = projectAreaValid[0] & valid;
                return valid;
            }
        });
        final boolean[] registryValid = new boolean[]{true};
        if (!cache.knownOrigin(projectArea.getItemId())) {
            String identifier = projectArea.getItemId().getUuidValue();
            UUID lastState = cache.get(identifier, UUID.class);
            UUID currentState = projectArea.getStateId();
            if (lastState != null) {
                registryValid[0] = currentState.equals((Object)lastState);
            }
            cache.add(ICacheEntryState.DEFAULT, identifier, currentState);
        }
        final StaticConfigurationDataRegistry staticRegistry = StaticConfigurationDataRegistry.getInstance();
        cache.validate(staticRegistry.getOrigin(), new ConfigurationElementCache.IInvalidationStrategy(){

            @Override
            public boolean validate(Object cachedState) {
                return registryValid[0] && projectAreaValid[0] && staticRegistry.getState().equals(cachedState);
            }
        });
        cache.setLastValidationTime(System.currentTimeMillis());
    }

    @Override
    public boolean isSyncTimeSpentWithTimeTracking(IProcessAreaHandle processAreaHandle) {
        IProcessConfigurationData data;
        boolean isTimeTrackingEnabled = false;
        try {
            data = this.getConfigurationPointData(TIMETRACKING_CONFIG_POINT, processAreaHandle);
        }
        catch (TeamRepositoryException e) {
            return false;
        }
        if (data != null) {
            IProcessConfigurationElement[] dataElements;
            IProcessConfigurationElement[] iProcessConfigurationElementArray = dataElements = data.getElements();
            int n = dataElements.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute;
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (TIMETRACKING_CFG_ELEMENT.equals(element.getName()) && (attribute = element.getAttribute(TIMETRACKING_SYNC_FLAG)) != null && attribute.compareTo("true") == 0) {
                    isTimeTrackingEnabled = true;
                    break;
                }
                ++n2;
            }
        }
        return isTimeTrackingEnabled;
    }

    private IProcessConfigurationData getConfigurationPointData(String configPt, IProcessAreaHandle processAreaHandle) throws TeamRepositoryException {
        IProcessConfigurationData data = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAuditableCommonProcess processService = this.fAuditableCommon.getProcess(processAreaHandle, (IProgressMonitor)monitor);
        if (processService != null) {
            data = processService.findProcessConfiguration(configPt, (IProgressMonitor)monitor);
        }
        return data;
    }

    public static class IItemFilter<E extends IItemHandle>
    implements IFilter<E> {
        private final E fItemHandle;
        final /* synthetic */ PlanningCommonImpl this$0;

        public IItemFilter(E itemHandle) {
            this.this$0 = var1_1;
            this.fItemHandle = itemHandle;
        }

        @Override
        public boolean accept(E element) {
            return this.fItemHandle == element || element != null && element.sameItemId(this.fItemHandle);
        }
    }
}

