/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PlanItemAttributes {
    private static Map<String, PlanningAttributeType> attributeTypes = new HashMap<String, PlanningAttributeType>();
    private static final Map<String, String> planItem2WorkItem;

    static {
        attributeTypes.put("smallString", PlanningAttributeType.STRING);
        attributeTypes.put("mediumString", PlanningAttributeType.STRING);
        attributeTypes.put("string", PlanningAttributeType.STRING);
        attributeTypes.put("mediumHtml", PlanningAttributeType.HTML);
        attributeTypes.put("html", PlanningAttributeType.HTML);
        attributeTypes.put("timestamp", PlanningAttributeType.INSTANT);
        attributeTypes.put("integer", PlanningAttributeType.INTEGER);
        attributeTypes.put("float", PlanningAttributeType.FLOAT);
        attributeTypes.put("decimal", PlanningAttributeType.DECIMAL);
        attributeTypes.put("long", PlanningAttributeType.INTEGER);
        attributeTypes.put("boolean", PlanningAttributeType.BOOLEAN);
        attributeTypes.put("duration", PlanningAttributeType.DURATION);
        attributeTypes.put("tags", PlanningAttributeType.TAGS);
        attributeTypes.put("type", PlanningAttributeType.WORKITEM_TYPE);
        attributeTypes.put("projectArea", PlanningAttributeType.ITEM);
        attributeTypes.put("teamArea", PlanningAttributeType.ITEM);
        attributeTypes.put("processArea", PlanningAttributeType.ITEM);
        attributeTypes.put("category", PlanningAttributeType.ITEM);
        attributeTypes.put("interval", PlanningAttributeType.ITEM);
        attributeTypes.put("contributor", PlanningAttributeType.ITEM);
        attributeTypes.put("workItem", PlanningAttributeType.ITEM);
        attributeTypes.put("deliverable", PlanningAttributeType.ITEM);
        planItem2WorkItem = new HashMap<String, String>();
        planItem2WorkItem.put("com.ibm.team.apt.attribute.summary", IWorkItem.SUMMARY_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.owner", IWorkItem.OWNER_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.sequenceValueRaw", WorkItem.SEQUENCE_VALUE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.id", IWorkItem.ID_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.description", IWorkItem.DESCRIPTION_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.creator", IWorkItem.CREATOR_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.filedAgainst", IWorkItem.CATEGORY_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.plannedFor", IWorkItem.TARGET_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.tags", IWorkItem.TAGS_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.state", IWorkItem.STATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.workflowResolution", IWorkItem.RESOLUTION_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.priority", IWorkItem.PRIORITY_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.severity", IWorkItem.SEVERITY_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.originalEstimate", IWorkItem.DURATION_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.correctedEstimate", WorkItem.CORRECTED_ESTIMATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.timeSpent", WorkItem.TIME_SPENT_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.dueDate", IWorkItem.DUE_DATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.resolutionDate", IWorkItem.RESOLUTION_DATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.resolvedBy", IWorkItem.RESOLVER_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.startDate", WorkItem.START_DATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.modifiedDate", IWorkItem.MODIFIED_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.modifiedBy", IWorkItem.MODIFIED_BY_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.creationDate", IWorkItem.CREATION_DATE_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.foundIn", IWorkItem.FOUND_IN_PROPERTY);
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.blocked", "com.ibm.team.apt.attribute.planitem.blocked");
        planItem2WorkItem.put("com.ibm.team.apt.attribute.planitem.blockedReason", "com.ibm.team.apt.attribute.planitem.blockedReason");
    }

    public static PlanningAttributeType getPlanningAttributeType(String attributeType) {
        if (attributeType == null) {
            return null;
        }
        if (AttributeTypes.isEnumerationAttributeType((String)attributeType)) {
            return PlanningAttributeType.ENUMERATION;
        }
        return attributeTypes.get(attributeType);
    }

    public static Collection<String> getBuiltInWorkItemAttributes() {
        return Collections.unmodifiableCollection(planItem2WorkItem.values());
    }

    public static boolean isBuiltIn(IAttributeDefinitionDescriptor desc) {
        return "com.ibm.team.apt.client.BuiltInAttribute".equals(desc.getImplementationName());
    }

    public static boolean isWorkItemBuiltIn(IAttributeDefinitionDescriptor desc) {
        if (!PlanItemAttributes.isBuiltIn(desc)) {
            return false;
        }
        return planItem2WorkItem.get(desc.getId()) != null;
    }

    public static boolean isWorkItemProxied(IAttributeDefinitionDescriptor desc) {
        return "com.ibm.team.apt.client.WorkItemAttribute".equals(desc.getImplementationName());
    }

    public static Identifier<IAttribute> getAttributeId(IAttributeDefinitionDescriptor desc) {
        if (PlanItemAttributes.isWorkItemBuiltIn(desc)) {
            String identifier = planItem2WorkItem.get(desc.getId());
            if (identifier != null) {
                return Identifier.create(IAttribute.class, (String)identifier);
            }
        } else {
            IParameter[] parameters = desc.getParameters();
            IParameter parameter = IParameter.FACTORY.findFirst("attribute", parameters);
            if (parameter != null) {
                return Identifier.create(IAttribute.class, (String)parameter.getValue());
            }
        }
        return null;
    }
}

