/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.foundation.common.util.IMemento;

public class PlanConfigurationStore {
    public static final String ID = "planConfiguration";
    public static final String ALWAYS_LOAD_EXECUTION_ITEMS = "alwaysLoadExecutionItems";
    public static final String DEFAULT_PLAN_MODE = "defaultPlanMode";
    public static final String PLAN_DASHBOARD_URL = "planDashboardUrl";
    public static final String RANKING_MODE = "rankingMode";
    public static final String RESTRICTED_SCOPE = "restrictedScope";
    public static final String FETCH_CHILDREN_ON_DEMAND = "fetchChildrenOnDemand";
    public static final String MIGRATED = "migrated";
    public static final String VALUE = "value";
    private IMemento fMemento;

    public PlanConfigurationStore(IStore store) {
        this.fMemento = store.getStore(ID);
    }

    public boolean getAlwaysLoadExecutionItems() {
        IMemento alei = this.fMemento.getChild(ALWAYS_LOAD_EXECUTION_ITEMS);
        if (alei == null) {
            return false;
        }
        Boolean result = alei.getBoolean(VALUE);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setAlwaysLoadExecutionItems(boolean value) {
        IMemento alei = this.fMemento.getChild(ALWAYS_LOAD_EXECUTION_ITEMS);
        if (alei == null) {
            alei = this.fMemento.createChild(ALWAYS_LOAD_EXECUTION_ITEMS);
        }
        alei.putBoolean(VALUE, value);
    }

    public String getDefaultPlanMode() {
        IMemento memento = this.fMemento.getChild(DEFAULT_PLAN_MODE);
        if (memento == null) {
            return null;
        }
        return memento.getString(VALUE);
    }

    public void setDefaultPlanMode(String planModeId) {
        IMemento memento = this.fMemento.getChild(DEFAULT_PLAN_MODE);
        if (memento == null) {
            memento = this.fMemento.createChild(DEFAULT_PLAN_MODE);
        }
        memento.putString(VALUE, planModeId);
    }

    public String getPlanDashboardUrl() {
        IMemento memento = this.fMemento.getChild(PLAN_DASHBOARD_URL);
        if (memento == null) {
            return null;
        }
        return memento.getString(VALUE);
    }

    public void setPlanDashboardUrl(String planDashboardUrl) {
        IMemento memento = this.fMemento.getChild(PLAN_DASHBOARD_URL);
        if (memento == null) {
            memento = this.fMemento.createChild(PLAN_DASHBOARD_URL);
        }
        memento.putString(VALUE, planDashboardUrl);
    }

    public String getRankingMode() {
        IMemento memento = this.fMemento.getChild(RANKING_MODE);
        if (memento == null) {
            return null;
        }
        return memento.getString(VALUE);
    }

    public void setRankingMode(String rankingMode) {
        IMemento memento = this.fMemento.getChild(RANKING_MODE);
        if (memento == null) {
            memento = this.fMemento.createChild(RANKING_MODE);
        }
        memento.putString(VALUE, rankingMode);
    }

    public String getRestrictedScope() {
        IMemento memento = this.fMemento.getChild(RESTRICTED_SCOPE);
        if (memento == null) {
            return null;
        }
        return memento.getString(VALUE);
    }

    public void setRestrictedScope(String restrictedScope) {
        IMemento memento = this.fMemento.getChild(RESTRICTED_SCOPE);
        if (memento == null) {
            memento = this.fMemento.createChild(RESTRICTED_SCOPE);
        }
        memento.putString(VALUE, restrictedScope);
    }

    public boolean getFetchChildrenOnDemand() {
        IMemento memento = this.fMemento.getChild(FETCH_CHILDREN_ON_DEMAND);
        if (memento == null) {
            return true;
        }
        Boolean result = memento.getBoolean(VALUE);
        if (result == null) {
            return true;
        }
        return result;
    }

    public void setFetchChildrenOnDemand(boolean value) {
        IMemento memento = this.fMemento.getChild(FETCH_CHILDREN_ON_DEMAND);
        if (memento == null) {
            memento = this.fMemento.createChild(FETCH_CHILDREN_ON_DEMAND);
        }
        memento.putBoolean(VALUE, value);
    }

    public boolean isMigrated() {
        IMemento memento = this.fMemento.getChild(MIGRATED);
        if (memento == null) {
            return false;
        }
        Boolean result = memento.getBoolean(VALUE);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setMigrated(boolean value) {
        IMemento memento = this.fMemento.getChild(MIGRATED);
        if (memento == null) {
            memento = this.fMemento.createChild(MIGRATED);
        }
        memento.putBoolean(VALUE, value);
    }
}

