/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.plantype.IBacklogIteration;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Iterations {
    private static final String BACKLOG_MARKER = "__backlogMarker@";
    public static final String PARENT_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"parent");
    public static final String DEVELOPMENT_LINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");
    public static final String ID_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"id");
    public static final String NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    public static final ItemProfile<IIteration> UI_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> LARGE_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(PARENT_PROPERTY, DEVELOPMENT_LINE_PROPERTY, NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> FULL_PROFILE = ItemProfile.createFullProfile((IItemType)IIteration.ITEM_TYPE);
    private static final ItemProfile<IDevelopmentLine> TIMELINE_PROFILE = ItemProfile.createFullProfile((IItemType)IDevelopmentLine.ITEM_TYPE);
    public static final String PATH_SEPARATOR = "/";
    public static final String PATH_SEPARATOR_ESCAPED = "//";
    private static Map<String, Map<String, BacklogPair>> fgBacklogInformation = new HashMap<String, Map<String, BacklogPair>>();

    public static int compareTo(IIteration i1, IIteration i2) {
        return new IterationComparator(SortMode.ASC).compare(i1, i2);
    }

    public static List<IIteration> sort(Collection<IIteration> intervals) {
        return Iterations.sort(intervals, SortMode.ASC);
    }

    public static List<IIteration> sort(Collection<IIteration> iterations, SortMode mode) {
        ArrayList<IIteration> sorted = new ArrayList<IIteration>();
        for (IIteration iteration : iterations) {
            sorted.add(iteration);
        }
        Iterations.sort(sorted, mode);
        return sorted;
    }

    public static void sort(List<IIteration> intervals, SortMode mode) {
        Collections.sort(intervals, new IterationComparator(mode));
    }

    public static List<IIteration>[] splitByTime(List<? extends IIteration> iterations) {
        ArrayList<IIteration> current = new ArrayList<IIteration>();
        ArrayList<IIteration> past = new ArrayList<IIteration>();
        ArrayList<IIteration> future = new ArrayList<IIteration>();
        long currentTime = System.currentTimeMillis();
        for (IIteration iIteration : iterations) {
            Date endDate = iIteration.getEndDate();
            Date startDate = iIteration.getStartDate();
            if (endDate == null || startDate == null || endDate.getTime() < currentTime) {
                past.add(iIteration);
                continue;
            }
            if (startDate.getTime() > currentTime) {
                future.add(iIteration);
                continue;
            }
            current.add(iIteration);
        }
        Iterations.sort(current, SortMode.ASC);
        Iterations.sort(past, SortMode.DESC);
        Iterations.sort(future, SortMode.ASC);
        return new List[]{past, current, future};
    }

    public static boolean hasDates(IIteration iteration) {
        return iteration.getStartDate() != null && iteration.getEndDate() != null;
    }

    public static IterationHierarchy fetchIterationHierarchy(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationHierarchy.create(handle, auditableCommon, monitor);
    }

    public static ItemList<IIteration> fetchAllChildren(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>();
        IDevelopmentLine developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        IIterationHandle[] iIterationHandleArray = developmentLine.getIterations();
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle iteration = iIterationHandleArray[n2];
            ItemList<IIteration> children = Iterations.fetchAllChildren(iteration, auditableCommon, options, monitor);
            result.addAll(children);
            ++n2;
        }
        return result;
    }

    public static ItemList<IIteration> fetchAllChildren(IIterationHandle handle, IAuditableCommon auditableCommon, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>();
        IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.ITERATION_DEFAULT, monitor);
        IIterationHandle[] childrenHandles = iteration.getChildren();
        if (childrenHandles.length != 0) {
            List children = auditableCommon.resolveAuditables(Arrays.asList(childrenHandles), FULL_PROFILE, monitor);
            for (IIteration child : children) {
                if (!options.contains((Object)Options.ARCHIVED) && child.isArchived() || options.contains((Object)Options.DELIVERABLE) && !child.hasDeliverable()) continue;
                result.add(child);
                result.addAll(Iterations.fetchAllChildren((IIterationHandle)child, auditableCommon, options, monitor));
            }
        }
        return result;
    }

    public static IIteration fetchCurrentIteration(IDevelopmentLineHandle handle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IDevelopmentLine developmentLine = (IDevelopmentLine)itemStore.fetchCompleteItem((IItemHandle)handle, (IProgressMonitor)progress.newChild(1));
        IIterationHandle currentHandle = developmentLine.getCurrentIteration();
        IIteration current = currentHandle != null ? (IIteration)itemStore.fetchCompleteItem((IItemHandle)currentHandle, (IProgressMonitor)progress.newChild(1)) : null;
        SubMonitor nestedProgress = progress.newChild(1);
        while (current != null && !current.hasDeliverable() && current.getParent() != null) {
            current = (IIteration)itemStore.fetchCompleteItem((IItemHandle)current.getParent(), (IProgressMonitor)nestedProgress.newChild(1));
        }
        if (monitor != null) {
            monitor.done();
        }
        return current;
    }

    public static Node<IIteration> fetchIterationTree(IDevelopmentLineHandle handle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        Node<Object> node = new Node<Object>(null, null);
        IDevelopmentLine developmentLine = (IDevelopmentLine)itemStore.fetchItem((IItemHandle)handle, ItemProfile.createFullProfile((IItemType)IDevelopmentLine.ITEM_TYPE).getPropertiesArray(), monitor);
        IIterationHandle[] iIterationHandleArray = developmentLine.getIterations();
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle iterationHandle = iIterationHandleArray[n2];
            IIteration iteration = (IIteration)itemStore.fetchCompleteItem((IItemHandle)iterationHandle, monitor);
            node.getChildren().add(Iterations.buildIterationTree(node, iteration, itemStore, EnumSet.of(Options.DELIVERABLE), monitor));
            ++n2;
        }
        return node;
    }

    public static Node<IIteration> fetchIterationTree(IIterationHandle handle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        IIteration iteration = (IIteration)itemStore.fetchCompleteItem((IItemHandle)handle, monitor);
        return Iterations.buildIterationTree(null, iteration, itemStore, EnumSet.of(Options.DELIVERABLE), monitor);
    }

    private static Node<IIteration> buildIterationTree(Node<IIteration> parentNode, IIteration iteration, IPlanningItemStore itemStore, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        Node<IIteration> node = new Node<IIteration>(parentNode, iteration);
        List children = itemStore.fetchCompleteItems(Arrays.asList(iteration.getChildren()), monitor);
        for (IIteration child : children) {
            boolean checkSubtree = false;
            checkSubtree |= child.isArchived() && !options.contains((Object)Options.ARCHIVED);
            checkSubtree |= !child.hasDeliverable() && options.contains((Object)Options.DELIVERABLE);
            boolean keepSubtree = !(checkSubtree &= !options.isEmpty());
            Node<IIteration> subtree = Iterations.buildIterationTree(node, child, itemStore, options, monitor);
            if (checkSubtree) {
                Iterator<Node<IIteration>> iter = subtree.breadthFirstIterator();
                while (!keepSubtree && iter.hasNext()) {
                    IIteration element = iter.next().getElement();
                    keepSubtree = true;
                    if (!options.contains((Object)Options.ARCHIVED)) {
                        keepSubtree &= !element.isArchived();
                    }
                    if (!options.contains((Object)Options.DELIVERABLE)) continue;
                    keepSubtree &= element.hasDeliverable();
                }
            }
            if (!keepSubtree) continue;
            node.getChildren().add(subtree);
        }
        return node;
    }

    public static IIteration getCurrentPlanLeafIteration(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List iterations = auditableCommon.findCurrentIterations(handle, monitor);
        ListIterator iter = iterations.listIterator(iterations.size());
        while (iter.hasPrevious()) {
            IIteration previous = (IIteration)iter.previous();
            if (!previous.hasDeliverable() || previous.isArchived()) continue;
            return previous;
        }
        return null;
    }

    public static TimeKind getIterationTimeKind(IIteration iteration, ItemSet<IIteration> currentIterations, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        if (currentIterations.contains(iteration)) {
            return TimeKind.CURRENT;
        }
        Object parent = Iterations.getParent(iteration, itemStore, monitor);
        while (parent != null) {
            IIterationHandle[] siblings = Iterations.getChildren(parent);
            boolean currentVisited = false;
            boolean iterationVisited = false;
            IIterationHandle[] iIterationHandleArray = siblings;
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                IIterationHandle sibling = iIterationHandleArray[n2];
                if (currentIterations.contains(sibling)) {
                    if (iterationVisited) {
                        return TimeKind.PAST;
                    }
                    currentVisited = true;
                }
                if (sibling.sameItemId((IItemHandle)iteration)) {
                    if (currentVisited) {
                        return TimeKind.FUTURE;
                    }
                    iterationVisited = true;
                }
                ++n2;
            }
            iteration = parent instanceof IIteration ? (IIteration)parent : null;
            parent = Iterations.getParent(iteration, itemStore, monitor);
        }
        return TimeKind.UNKNOWN;
    }

    private static Object getParent(Object element, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        if (element instanceof IIteration) {
            IIteration iteration = (IIteration)element;
            if (iteration.getParent() != null) {
                return itemStore.fetchCompleteItem((IItemHandle)iteration.getParent(), monitor);
            }
            return itemStore.fetchItem((IItemHandle)iteration.getDevelopmentLine(), TIMELINE_PROFILE.getPropertiesArray(), monitor);
        }
        return null;
    }

    private static IIterationHandle[] getChildren(Object element) {
        if (element instanceof IIteration) {
            return ((IIteration)element).getChildren();
        }
        if (element instanceof IDevelopmentLine) {
            return ((IDevelopmentLine)element).getIterations();
        }
        return new IIterationHandle[0];
    }

    public static void distributeIterations(ItemCollection<IIteration> primaryIterations, ItemCollection<IIteration> secondaryIterations, IIteration iteration, ItemSet<IIteration> currentIterations, Node<IIteration> tree, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        TimeKind kind = Iterations.getIterationTimeKind(iteration, currentIterations, itemStore, monitor);
        if (tree == null) {
            tree = Iterations.fetchIterationTree((IIterationHandle)iteration, itemStore, monitor);
        }
        switch (kind) {
            case PAST: {
                primaryIterations.add(iteration);
                for (Node<IIteration> child : tree.getChildren()) {
                    Iterations.addAll(secondaryIterations, child);
                }
                break;
            }
            case CURRENT: {
                if (currentIterations == null) {
                    throw new TeamRepositoryException("No current iterations found");
                }
                Iterations.distributeCurrent(primaryIterations, secondaryIterations, tree, currentIterations);
                break;
            }
            case FUTURE: 
            case UNKNOWN: {
                Iterations.addAll(primaryIterations, tree);
            }
        }
    }

    private static void distributeCurrent(ItemCollection<IIteration> primaryIterations, ItemCollection<IIteration> secondaryIterations, Node<IIteration> node, ItemSet<IIteration> currentIterations) {
        IIteration iteration = node.getElement();
        primaryIterations.add(iteration);
        boolean currentVisted = false;
        for (Node<IIteration> childNode : node.getChildren()) {
            IIteration child = childNode.getElement();
            if (currentIterations.contains(child)) {
                currentVisted = true;
                Iterations.distributeCurrent(primaryIterations, secondaryIterations, childNode, currentIterations);
                continue;
            }
            if (currentVisted) {
                Iterations.addAll(primaryIterations, childNode);
                continue;
            }
            Iterations.addAll(secondaryIterations, childNode);
        }
    }

    private static void addAll(ItemCollection<IIteration> list, Node<IIteration> node) {
        IIteration iteration = node.getElement();
        if (!iteration.hasDeliverable() && node.getChildren().isEmpty()) {
            return;
        }
        list.add(iteration);
        for (Node<IIteration> child : node.getChildren()) {
            Iterations.addAll(list, child);
        }
    }

    public static IIteration resolveIterationFromPath(IProcessAreaHandle processAreaHandle, String iterationPath, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IProcessArea processArea = (IProcessArea)itemStore.fetchItem((IItemHandle)processAreaHandle, new String[]{ProcessCommon.getPropertyName(IProcessArea.class, (String)"projectArea")}, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = (IProjectArea)itemStore.fetchItem((IItemHandle)processArea.getProjectArea(), new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")}, (IProgressMonitor)progress.newChild(1));
        if (iterationPath == null || iterationPath.length() == 0 || !iterationPath.startsWith(PATH_SEPARATOR)) {
            return null;
        }
        String escapeLiteral = UUID.generate().getUuidValue();
        iterationPath = new StringBuilder(iterationPath).reverse().toString();
        iterationPath = iterationPath.replace(PATH_SEPARATOR_ESCAPED, new StringBuilder(escapeLiteral).reverse().toString());
        StringTokenizer tokenizer = new StringTokenizer((iterationPath = new StringBuilder(iterationPath).reverse().toString()).substring(1), PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        IDevelopmentLineHandle[] lines = projectArea.getDevelopmentLines();
        IDevelopmentLine line = null;
        progress.setWorkRemaining(1 + lines.length);
        IDevelopmentLineHandle[] iDevelopmentLineHandleArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IDevelopmentLineHandle lineHandle = iDevelopmentLineHandleArray[n2];
            IDevelopmentLine candidate = (IDevelopmentLine)itemStore.fetchItem((IItemHandle)lineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
            if (candidate.getId().equals(token)) {
                line = candidate;
                break;
            }
            ++n2;
        }
        if (line == null) {
            return null;
        }
        IDevelopmentLine result = null;
        IIterationHandle[] iterations = line.getIterations();
        progress.setWorkRemaining(tokenizer.countTokens() * iterations.length);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().replace(escapeLiteral, PATH_SEPARATOR);
            IDevelopmentLine current = null;
            List items = itemStore.fetchItems(Arrays.asList(iterations), ItemProfile.ITERATION_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(iterations.length));
            for (IDevelopmentLine candidate : items) {
                if (!token.equals(candidate.getId())) continue;
                current = candidate;
                break;
            }
            if (current != null && !tokenizer.hasMoreTokens()) {
                result = current;
                continue;
            }
            if (current == null) {
                return null;
            }
            iterations = current.getChildren();
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    public static String createIterationPath(IIterationHandle iterationHandle, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        StringBuilder result = new StringBuilder();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IIteration current = null;
        while (iterationHandle != null) {
            current = (IIteration)itemStore.fetchItem((IItemHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
            result.insert(0, current.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
            result.insert(0, PATH_SEPARATOR);
            iterationHandle = current.getParent();
        }
        Assert.isNotNull(current);
        IDevelopmentLine timeline = (IDevelopmentLine)itemStore.fetchItem((IItemHandle)current.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        result.insert(0, timeline.getId().replace(PATH_SEPARATOR, PATH_SEPARATOR_ESCAPED));
        result.insert(0, PATH_SEPARATOR);
        return result.toString();
    }

    public static Map<String, BacklogPair> getBacklogInformation(IProjectAreaHandle projectAreaHandle, IPlanningCommon planningCommon, IPlanningItemStore itemStore, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Map<String, BacklogPair> backlogInfo = fgBacklogInformation.get(projectAreaHandle.getItemId().getUuidValue());
        if (backlogInfo != null && !Iterations.hasValueUpdated(projectAreaHandle, planningCommon)) {
            return backlogInfo;
        }
        backlogInfo = new HashMap<String, BacklogPair>();
        IPlanningItemStore.IPlanningProcessStore process = itemStore.getProcessStore((IProcessAreaHandle)projectAreaHandle, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = (IProjectArea)itemStore.fetchItem((IItemHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        List timelines = itemStore.fetchItems(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        for (IDevelopmentLine timeline : timelines) {
            IBacklogIteration backlogIteration = planningCommon.findConfigurationElement2(IBacklogIteration.class, timeline.getId(), process, (IProgressMonitor)progress.newChild(1));
            if (backlogIteration == null) continue;
            IIteration iteration = Iterations.resolveIterationFromPath((IProcessAreaHandle)projectArea, backlogIteration.getPath(), itemStore, (IProgressMonitor)progress.newChild(1));
            BacklogPair backlogPair = new BacklogPair();
            if (iteration == null) {
                backlogPair.errorMessage = NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_INVALID_BACKLOG_ITERATION"), (Object)backlogIteration.getPath(), (Object[])new Object[]{timeline.getId()});
            } else {
                backlogPair.iteration = iteration;
                backlogPair.timeLine = timeline;
            }
            backlogInfo.put(timeline.getId(), backlogPair);
        }
        fgBacklogInformation.put(projectAreaHandle.getItemId().getUuidValue(), backlogInfo);
        Iterations.storeMarker(itemStore, projectAreaHandle, planningCommon, monitor);
        return backlogInfo;
    }

    private static boolean hasValueUpdated(IProjectAreaHandle handle, IPlanningCommon planningCommon) {
        ConfigurationElementCache cache = planningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return true;
        }
        return cache.get(Iterations.asIdentifier((IItemHandle)handle), Object.class) == null;
    }

    private static void storeMarker(IPlanningItemStore itemStore, IProjectAreaHandle handle, IPlanningCommon planningCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ConfigurationElementCache cache = planningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)itemStore.fetchItem((IItemHandle)handle, ItemProfile.PROJECT_AREA_DEFAULT.getPropertiesArray(), (IProgressMonitor)progress.newChild(1));
        cache.add(new ItemState((IItem)projectArea), Iterations.asIdentifier((IItemHandle)projectArea), new Object());
    }

    private static String asIdentifier(IItemHandle item) {
        return BACKLOG_MARKER + item.getItemId().getUuidValue();
    }

    public static final class BacklogPair {
        public IDevelopmentLine timeLine;
        public IIteration iteration;
        public String errorMessage;
    }

    private static class ItemState
    implements ICacheEntryState {
        private IItem fItem;

        public ItemState(IItem item) {
            this.fItem = item;
        }

        @Override
        public UUID getOrigin() {
            return this.fItem.getItemId();
        }

        @Override
        public Object getState() {
            return this.fItem.getStateId();
        }
    }

    private static final class IterationComparator
    implements Comparator<IIteration> {
        private final SortMode fMode;

        private IterationComparator(SortMode mode) {
            this.fMode = mode;
        }

        @Override
        public int compare(IIteration o1, IIteration o2) {
            boolean noDate2;
            boolean isAscending;
            if (o1 == o2) {
                return 0;
            }
            boolean bl = isAscending = this.fMode == SortMode.ASC;
            if (o1 == null) {
                return isAscending ? -1 : 1;
            }
            if (o2 == null) {
                return isAscending ? 1 : -1;
            }
            boolean noDate1 = o1.getStartDate() == null || o1.getEndDate() == null;
            boolean bl2 = noDate2 = o2.getStartDate() == null || o2.getEndDate() == null;
            if (noDate1 && noDate2) {
                return 0;
            }
            if (noDate1) {
                return isAscending ? -1 : 1;
            }
            if (noDate2) {
                return isAscending ? 1 : -1;
            }
            if (o1.getEndDate().getTime() <= o2.getStartDate().getTime()) {
                return isAscending ? -1 : 1;
            }
            if (o1.getStartDate().getTime() >= o2.getEndDate().getTime()) {
                return isAscending ? 1 : -1;
            }
            return 0;
        }
    }

    public static enum Options {
        ARCHIVED,
        DELIVERABLE;

    }

    public static enum TimeKind {
        PAST,
        CURRENT,
        FUTURE,
        UNKNOWN;

    }
}

