/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.workitem.common.model.Duration;
import java.util.Date;
import org.eclipse.core.runtime.Assert;

public class Instant
implements Comparable<Instant> {
    private final Date fDate;

    public Instant(Date date) {
        Assert.isNotNull((Object)date);
        this.fDate = date;
    }

    public Date getDate() {
        return this.fDate;
    }

    public boolean before(Instant instant) {
        return this.before(instant.fDate);
    }

    public boolean after(Instant instant) {
        return this.after(instant.fDate);
    }

    public Instant plus(Duration duration) {
        return new Instant(new Date(this.fDate.getTime() + duration.longValue()));
    }

    public Instant minus(Duration duration) {
        return new Instant(new Date(this.fDate.getTime() - duration.longValue()));
    }

    @Override
    public int compareTo(Instant o) {
        return Dates.compareTo(this.fDate, o.fDate);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instant)) {
            return false;
        }
        Instant other = (Instant)obj;
        return this.fDate.equals(other.fDate);
    }

    public int hashCode() {
        return this.fDate.hashCode();
    }

    public static Instant time(long millisecs) {
        return new Instant(new Date(millisecs));
    }

    public boolean after(Date date) {
        return this.fDate.after(date);
    }

    public boolean before(Date date) {
        return this.fDate.before(date);
    }
}

