/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common.resource;

import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.internal.common.resource.model.ResourceFactory;
import com.ibm.team.apt.internal.common.resource.model.WeekDay;
import com.ibm.team.apt.internal.common.resource.model.WorkDayDefinition;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;

public final class ResourcePlanningUtils {
    private static TimeZone fgDefaultTimeZone = TimeZone.getDefault();
    private static final String EMPTY_STRING = "";
    private static Hashtable<String, TimeZone> fgTimeZones = new Hashtable();
    private static final TimeZone fgGMTTimezone = ResourcePlanningUtils.getTimeZone("GMT");
    private static int fgTimeZoneOffset = ResourcePlanningUtils.retrieveCalendarTimeZoneOffset();
    private static boolean fgTimeZoneOffsetInDaylightTime = fgDefaultTimeZone.inDaylightTime(new Date());

    public static IWorkLocationDefinition createWorkLocation(int weekDays, long workDayMillis, Locale locale) {
        String variant;
        Assert.isNotNull((Object)locale);
        ResourceFactory factory = ResourceFactory.eINSTANCE;
        WorkLocationDefinition result = factory.createWorkLocationDefinition();
        result.setCustomized(false);
        result.setUniversal(false);
        result.setLanguage(locale.getLanguage());
        String country = locale.getCountry();
        if (country != null && !EMPTY_STRING.equals(country)) {
            result.setCountry(country);
        }
        if ((variant = locale.getVariant()) != null && !EMPTY_STRING.equals(variant)) {
            result.setVariant(variant);
        }
        TimeZone zone = fgDefaultTimeZone;
        result.setTimeZone(zone.getID());
        result.setZoneOffset(zone.getOffset(System.currentTimeMillis()));
        List days = result.getWorkDays();
        long workingTime = workDayMillis;
        long endTime = 32400000L + workingTime;
        WorkDayDefinition day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(2));
        if (weekDays > 0) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(3));
        if (weekDays > 1) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(4));
        if (weekDays > 2) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(5));
        if (weekDays > 3) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(6));
        if (weekDays > 4) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(7));
        if (weekDays > 5) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        day = factory.createWorkDayDefinition();
        day.setDay(WeekDay.get(1));
        if (weekDays > 6) {
            day.setWorkingTime(workingTime);
            day.setEndTime(endTime);
        } else {
            day.setWorkingTime(0L);
            day.setEndTime(0L);
        }
        days.add(day);
        return result;
    }

    public static IWorkLocationDefinition createWorkLocation(boolean[] workingDays, long workDayMillis, Locale locale, long endTime) {
        String variant;
        Assert.isNotNull((Object)locale);
        Assert.isNotNull((Object)workingDays);
        Assert.isTrue((workingDays.length == 7 ? 1 : 0) != 0);
        ResourceFactory factory = ResourceFactory.eINSTANCE;
        WorkLocationDefinition result = factory.createWorkLocationDefinition();
        result.setCustomized(false);
        result.setUniversal(false);
        result.setLanguage(locale.getLanguage());
        String country = locale.getCountry();
        if (country != null && !EMPTY_STRING.equals(country)) {
            result.setCountry(country);
        }
        if ((variant = locale.getVariant()) != null && !EMPTY_STRING.equals(variant)) {
            result.setVariant(variant);
        }
        TimeZone zone = fgDefaultTimeZone;
        result.setTimeZone(zone.getID());
        result.setZoneOffset(zone.getOffset(System.currentTimeMillis()));
        List days = result.getWorkDays();
        long workingTime = workDayMillis;
        if (endTime == -1L) {
            endTime = 32400000L + workingTime;
        }
        int i = 0;
        while (i < workingDays.length) {
            WorkDayDefinition day = factory.createWorkDayDefinition();
            day.setDay(WeekDay.get(i + 1));
            if (workingDays[i]) {
                day.setWorkingTime(workingTime);
                day.setEndTime(endTime);
            } else {
                day.setWorkingTime(0L);
                day.setEndTime(0L);
            }
            days.add(day);
            ++i;
        }
        return result;
    }

    public static IWorkLocationDefinition clone(IWorkLocationDefinition definition) {
        ResourceFactory factory = ResourceFactory.eINSTANCE;
        WorkLocationDefinition result = factory.createWorkLocationDefinition();
        result.setCustomized(definition.isCustomized());
        result.setUniversal(definition.isUniversal());
        result.setLanguage(definition.getLanguage());
        result.setCountry(definition.getCountry());
        result.setVariant(definition.getVariant());
        result.setTimeZone(definition.getTimeZone());
        result.setZoneOffset(definition.getZoneOffset());
        for (IWorkDayDefinition dd : definition.getWorkDays()) {
            WorkDayDefinition day = factory.createWorkDayDefinition();
            day.setDay(WeekDay.get(dd.getDay().getValue()));
            day.setWorkingTime(dd.getWorkingTime());
            day.setEndTime(dd.getEndTime());
            result.getWorkDays().add(day);
        }
        return result;
    }

    public static Locale getLocale(IWorkLocationDefinition definition) {
        String variant;
        String country;
        Assert.isNotNull((Object)definition);
        String language = definition.getLanguage();
        if (language == null) {
            language = EMPTY_STRING;
        }
        if ((country = definition.getCountry()) == null) {
            country = EMPTY_STRING;
        }
        if ((variant = definition.getVariant()) == null) {
            variant = EMPTY_STRING;
        }
        return new Locale(language, country, variant);
    }

    public static TimeZone getTimeZone(IWorkLocationDefinition definition) {
        String id = definition.getTimeZone();
        if (id != null && !EMPTY_STRING.equals(id)) {
            return ResourcePlanningUtils.getTimeZone(id);
        }
        return fgDefaultTimeZone;
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        TimeZone timeZone = fgTimeZones.get(timeZoneId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone(timeZoneId);
            fgTimeZones.put(timeZoneId, timeZone);
        }
        return timeZone;
    }

    public static long getWorkDayMillis(IWorkLocationDefinition definition) {
        Assert.isNotNull((Object)definition);
        Collection<IWorkDayDefinition> days = definition.getWorkDays();
        int result = 0;
        int count = 0;
        for (IWorkDayDefinition day : days) {
            long time = day.getWorkingTime();
            if (time <= 0L) continue;
            result = (int)((long)result + time);
            ++count;
        }
        if (count > 0) {
            return result / count;
        }
        return 0L;
    }

    public static int getWorkWeekDays(IWorkLocationDefinition definition) {
        Assert.isNotNull((Object)definition);
        Collection<IWorkDayDefinition> days = definition.getWorkDays();
        int result = 0;
        for (IWorkDayDefinition day : days) {
            if (day.getWorkingTime() <= 0L) continue;
            ++result;
        }
        return result;
    }

    public static int[] convertWorkDayMillis(long millis) {
        int hours = (int)(millis / 3600000L);
        int rest = (int)(millis % 3600000L);
        int minutes = (int)((long)rest / 60000L);
        rest = (int)((long)rest % 60000L);
        int seconds = (int)((long)rest / 1000L);
        rest = (int)((long)rest % 1000L);
        return new int[]{hours, minutes, seconds, rest};
    }

    public static TimeZone getGMTTimezone() {
        return fgGMTTimezone;
    }

    public static int getCalendarTimeZoneOffset() {
        boolean inDaylightTime = fgDefaultTimeZone.inDaylightTime(new Date());
        if (fgTimeZoneOffsetInDaylightTime != inDaylightTime) {
            fgTimeZoneOffset = ResourcePlanningUtils.retrieveCalendarTimeZoneOffset();
            fgTimeZoneOffsetInDaylightTime = inDaylightTime;
        }
        return fgTimeZoneOffset;
    }

    public static void setDefaultTimeZone(TimeZone timeZone) {
        fgDefaultTimeZone = timeZone;
    }

    private static int retrieveCalendarTimeZoneOffset() {
        Calendar withTimeZone = Calendar.getInstance();
        return withTimeZone.get(15) + withTimeZone.get(16);
    }
}

