/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common.resource;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.team.apt.common.expressions.DateRange;
import com.ibm.team.apt.common.expressions.DayOfWeekExpression;
import com.ibm.team.apt.common.expressions.IntersectionExpression;
import com.ibm.team.apt.common.expressions.TemporalExpression;
import com.ibm.team.apt.common.expressions.TimeEveryDayExpression;
import com.ibm.team.apt.common.expressions.UnionExpression;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.resource.dto.DTO_ContributorInfo;
import com.ibm.team.apt.internal.common.resource.model.WorkDayDefinition;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ResourcePlanningHelper {
    public static Calendar DEFAULT_START_DATE = new GregorianCalendar(2000, 0, 1);
    public static Calendar DEFAULT_END_DATE = new GregorianCalendar(3000, 0, 1);

    public static DateRange validateDateRange(IWorkResourceDetails[] workingCopies) {
        Date startDateForAbsences = null;
        Date endDateForAbsences = null;
        IWorkResourceDetails[] iWorkResourceDetailsArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkResourceDetails workingCopy = iWorkResourceDetailsArray[n2];
            if (workingCopy.getStartDate() != null && workingCopy.getEndDate() == null) {
                throw new IllegalArgumentException(Messages.getString("ResourcePlanningHelper.HAS_START_DATE_NO_END_DATE"));
            }
            if (workingCopy.getStartDate() == null && workingCopy.getEndDate() != null) {
                throw new IllegalArgumentException(Messages.getString("ResourcePlanningHelper.NO_START_DATE_HAS_END_DATE"));
            }
            if (!(workingCopy.getStartDate() == null && workingCopy.getEndDate() == null || ResourcePlanningHelper.isDefaultStartDate(workingCopy.getStartDate()) && ResourcePlanningHelper.isDefaultEndDate(workingCopy.getEndDate()))) {
                if (startDateForAbsences == null || Dates.compareTo2(startDateForAbsences, workingCopy.getStartDate()) > 0) {
                    startDateForAbsences = workingCopy.getStartDate();
                }
                if (endDateForAbsences == null || Dates.compareTo2(endDateForAbsences, workingCopy.getEndDate()) < 0) {
                    endDateForAbsences = workingCopy.getEndDate();
                }
            }
            ++n2;
        }
        if (startDateForAbsences == null) {
            return null;
        }
        Calendar startDateForAbsencesCal = Calendar.getInstance();
        startDateForAbsencesCal.setTime(startDateForAbsences);
        Calendar endDateForAbsencesCal = Calendar.getInstance();
        endDateForAbsencesCal.setTime(endDateForAbsences);
        return new DateRange(startDateForAbsencesCal, endDateForAbsencesCal);
    }

    public static boolean isDefaultEndDate(Date date) {
        return Dates.compareDatesWithoutTime(date, DEFAULT_END_DATE.getTime());
    }

    public static boolean isDefaultStartDate(Date date) {
        return Dates.compareDatesWithoutTime(date, DEFAULT_START_DATE.getTime());
    }

    public static boolean isDefaultDateRange(DateRange dateRange) {
        if (dateRange == null || dateRange.getStart() == null || dateRange.getEnd() == null) {
            return false;
        }
        return ResourcePlanningHelper.isDefaultStartDate(dateRange.getStart().getTime()) && ResourcePlanningHelper.isDefaultEndDate(dateRange.getEnd().getTime());
    }

    public static DateRange getDateRangeTEForAllocation(DateRange dr, IWorkResourceDetails workDetails) {
        DateRange drTE = null;
        if (workDetails.getStartDate() == null) {
            drTE = new DateRange(dr.getStart(), dr.getEnd());
        } else {
            Calendar start = Calendar.getInstance();
            start.setTime(workDetails.getStartDate());
            Calendar end = Calendar.getInstance();
            end.setTime(workDetails.getEndDate());
            drTE = new DateRange(start, end);
        }
        return drTE;
    }

    public static IntersectionExpression createTEForADay(TemporalExpression workingTime, int day) {
        DayOfWeekExpression dow = new DayOfWeekExpression(day);
        IntersectionExpression timeOnADay = new IntersectionExpression();
        timeOnADay.addElement(dow);
        timeOnADay.addElement(workingTime);
        return timeOnADay;
    }

    public static HashMap<Integer, WorkDayDefinition> prepareWorkDayDefinitions(WorkLocationDefinition workLocationDefinition) {
        HashMap<Integer, WorkDayDefinition> workDayDefinitions = new HashMap<Integer, WorkDayDefinition>();
        List workDays = workLocationDefinition.getWorkDays();
        for (Object object : workDays) {
            workDayDefinitions.put(((IWorkDayDefinition)object).getDay().getValue(), (WorkDayDefinition)object);
        }
        return workDayDefinitions;
    }

    public static UnionExpression getAvailabilityTE(HashMap<Integer, WorkDayDefinition> workDayDefinitions) {
        UnionExpression availableTE = new UnionExpression();
        Iterator<Integer> iter = workDayDefinitions.keySet().iterator();
        while (iter.hasNext()) {
            WorkDayDefinition wdd = workDayDefinitions.get(iter.next());
            Calendar timeStartCal = Calendar.getInstance();
            Calendar timeEndCal = Calendar.getInstance();
            timeEndCal.setTimeInMillis(timeEndCal.getTimeInMillis() + wdd.getEndTime());
            timeStartCal.setTimeInMillis(timeEndCal.getTimeInMillis() - wdd.getWorkingTime());
            TimeEveryDayExpression workingTime = new TimeEveryDayExpression(timeStartCal, timeEndCal);
            IntersectionExpression timeOnADayTE = ResourcePlanningHelper.createTEForADay(workingTime, wdd.getDay().getValue());
            availableTE.addElement(timeOnADayTE);
        }
        return availableTE;
    }

    public static UnionExpression getAbsencesTE(DTO_ContributorInfo info, DateRange dr) throws TeamRepositoryException {
        List absencesItem = info.getAbsences();
        UnionExpression absencesTE = new UnionExpression();
        for (Object element : absencesItem) {
            IContributorAbsence absence = (IContributorAbsence)element;
            Calendar start = Calendar.getInstance();
            start.setTime(absence.getStartDate());
            Calendar end = Calendar.getInstance();
            end.setTime(absence.getEndDate());
            DateRange drTE = new DateRange(start, end);
            absencesTE.addElement(drTE);
        }
        return absencesTE;
    }

    public static UnionExpression getAbsencesTE(List<IContributorAbsence> absences) throws TeamRepositoryException {
        UnionExpression absencesTE = new UnionExpression();
        for (IContributorAbsence absence : absences) {
            Calendar start = Calendar.getInstance();
            start.setTime(absence.getStartDate());
            Calendar end = Calendar.getInstance();
            end.setTime(absence.getEndDate());
            DateRange drTE = new DateRange(start, end);
            absencesTE.addElement(drTE);
        }
        return absencesTE;
    }
}

