/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common.expressions;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.team.apt.common.expressions.TemporalExpression;

public class TimeEveryDayExpression
extends TemporalExpression {
    private Calendar fStartTime;
    private Calendar fEndTime;
    private long fDiff;

    @Override
    public boolean includes(Calendar theDate) {
        boolean after;
        theDate.setTimeZone(this.fStartTime.getTimeZone());
        GregorianCalendar todayTime = new GregorianCalendar(this.fStartTime.getTimeZone());
        todayTime.clear();
        todayTime.set(theDate.get(1), theDate.get(2), theDate.get(5), this.fStartTime.get(11), this.fStartTime.get(12), this.fStartTime.get(13));
        long timeInMillis = theDate.getTimeInMillis();
        long timeInMillis2 = todayTime.getTimeInMillis();
        boolean bl = after = !theDate.before((Object)todayTime);
        return after && timeInMillis - timeInMillis2 < this.fDiff;
    }

    public TimeEveryDayExpression(Calendar sDate, Calendar eDate) {
        this.fStartTime = sDate;
        this.fEndTime = eDate;
        this.fDiff = this.fEndTime.getTimeInMillis() - this.fStartTime.getTimeInMillis();
    }

    @Override
    public boolean occurs(Calendar startDate, Calendar endDate) {
        return false;
    }

    @Override
    public long minLength() {
        return this.fDiff / 1000L;
    }
}

