/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common.expressions;

import com.ibm.icu.util.Calendar;
import com.ibm.team.apt.common.expressions.TemporalExpression;
import com.ibm.team.apt.internal.common.util.Dates;

public class DateRange
extends TemporalExpression {
    private Calendar fStartDate = Calendar.getInstance();
    private Calendar fEndDate;

    public DateRange(Calendar start, Calendar end) {
        this.fStartDate.setTime(start.getTime());
        Dates.setGMTHighNoon(this.fStartDate);
        this.fEndDate = Calendar.getInstance();
        this.fEndDate.setTime(end.getTime());
        Dates.setGMTHighNoon(this.fEndDate);
    }

    public Calendar getStart() {
        return this.fStartDate;
    }

    public Calendar getEnd() {
        return this.fEndDate;
    }

    @Override
    public boolean includes(Calendar theDate) {
        long theDateinMS = theDate.getTimeInMillis();
        long sDateinMS = this.fStartDate.getTimeInMillis();
        long eDateinMS = this.fEndDate.getTimeInMillis();
        return theDateinMS >= sDateinMS && theDateinMS <= eDateinMS;
    }

    public boolean includes(DateRange dr) {
        return this.includes(dr.getStart()) && this.includes(dr.getEnd());
    }

    public boolean overlaps(DateRange dr) {
        return dr.includes(this.fStartDate) || dr.includes(this.fEndDate) || this.includes(dr);
    }

    @Override
    public boolean occurs(Calendar startDate, Calendar endDate) {
        return false;
    }

    @Override
    public long minLength() {
        long sDateinMS = this.fStartDate.getTimeInMillis();
        long eDateinMS = this.fEndDate.getTimeInMillis();
        return (eDateinMS - sDateinMS) / 1000L;
    }
}

