/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.common;

import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class APTCommon {
    public static String[] getPlanningWorkItemProperties(IPlanningCommon planningCommon, IPlanningItemStore.IPlanningProcessStore process, IProgressMonitor monitor) throws TeamRepositoryException {
        return APTCommon.getPlanningWorkItemProfile(planningCommon, process, false, monitor).getPropertiesArray();
    }

    public static ItemProfile getPlanningWorkItemProfile(IPlanningCommon planningCommon, IPlanningItemStore.IPlanningProcessStore process, IProgressMonitor monitor) throws TeamRepositoryException {
        return APTCommon.getPlanningWorkItemProfile(planningCommon, process, false, monitor);
    }

    public static ItemProfile<IWorkItem> getPlanningWorkItemProfile(IPlanningCommon planningCommon, IPlanningItemStore.IPlanningProcessStore process, boolean withReferences, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("Calculate Item Profile", 1);
        try {
            HashSet<String> result = new HashSet<String>();
            result.addAll(IWorkItem.SMALL_PROFILE.getProperties());
            result.add(IItem.ITEM_ID_PROPERTY);
            result.add(IItem.STATE_ID_PROPERTY);
            result.add(IItem.CONTEXT_ID_PROPERTY);
            result.add(IWorkItem.WORKFLOW_SURROGATE_PROPERTY);
            for (Identifier<IAttribute> attribute : APTCommon.getPlanningWorkItemAttributes(planningCommon, process, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                result.add(WorkItemAttributes.getAttributeId(attribute));
            }
            ItemProfile itemProfile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, result, (boolean)withReferences);
            return itemProfile;
        }
        finally {
            monitor.done();
        }
    }

    public static Set<Identifier<IAttribute>> getPlanningWorkItemAttributes(IPlanningCommon planningCommon, IPlanningItemStore.IPlanningProcessStore process, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("Calculate Item Profile", 1);
        try {
            HashSet<Identifier<IAttribute>> result = new HashSet<Identifier<IAttribute>>();
            result.add(WorkItemAttributes.CATEGORY);
            result.add(WorkItemAttributes.TARGET);
            result.add(WorkItemAttributes.SUMMARY);
            result.add(WorkItemAttributes.DESCRIPTION);
            result.add(WorkItemAttributes.OWNER);
            result.add(WorkItemAttributes.PRIORITY);
            result.add(WorkItemAttributes.STATE);
            result.add(WorkItemAttributes.TYPE);
            result.add(WorkItemAttributes.TAGS);
            result.add(WorkItemAttributes.DURATION);
            result.add(WorkItemAttributes.CORRECTED_ESTIMATE);
            result.add(WorkItemAttributes.TIME_SPENT);
            result.add(WorkItemAttributes.ID);
            result.add(WorkItemAttributes.DUE_DATE);
            result.add(WorkItemAttributes.SEVERITY);
            result.add(WorkItemAttributes.CREATOR);
            result.add(WorkItemAttributes.CREATION_DATE);
            result.add(WorkItemAttributes.RESOLUTION_DATE);
            result.add(WorkItemAttributes.SEQUENCE_VALUE);
            List<IAttributeDefinitionDescriptor> attributeDescriptors = planningCommon.findConfigurationElements2(IAttributeDefinitionDescriptor.class, process, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            block3: for (IAttributeDefinitionDescriptor attributeDescriptor : attributeDescriptors) {
                IParameter parameter;
                int n;
                int n2;
                IParameter[] iParameterArray;
                if ("com.ibm.team.apt.client.WorkItemAttribute".equals(attributeDescriptor.getImplementationName())) {
                    iParameterArray = attributeDescriptor.getParameters();
                    n2 = iParameterArray.length;
                    n = 0;
                    while (n < n2) {
                        parameter = iParameterArray[n];
                        if ("attribute".equals(parameter.getKey())) {
                            result.add((Identifier<IAttribute>)Identifier.create(IAttribute.class, (String)parameter.getValue()));
                            continue block3;
                        }
                        ++n;
                    }
                    continue;
                }
                if (!APTCommon.isRanking(attributeDescriptor.getImplementationName())) continue;
                iParameterArray = attributeDescriptor.getParameters();
                n2 = iParameterArray.length;
                n = 0;
                while (n < n2) {
                    parameter = iParameterArray[n];
                    if ("attribute".equals(parameter.getKey())) {
                        result.add((Identifier<IAttribute>)Identifier.create(IAttribute.class, (String)parameter.getValue()));
                        result.add((Identifier<IAttribute>)Identifier.create(IAttribute.class, (String)(String.valueOf(parameter.getValue()) + '.' + "_pm7NmRYUEd6L1tNIGdz5qQ")));
                        continue block3;
                    }
                    ++n;
                }
            }
            HashSet<Identifier<IAttribute>> hashSet = result;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean isRanking(String implementationName) {
        return "com.ibm.team.apt.shared.client.RankingAttribute".equals(implementationName) || "com.ibm.team.apt.shared.client.NewRankingAttribute".equals(implementationName);
    }
}

