/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class IterationStructure {
    private ItemMap<IDevelopmentLineHandle, ItemList<IIteration>> fCurrentIterations;
    private ItemMap<IDevelopmentLineHandle, IDevelopmentLine> fDevelopmentLines;
    private ItemMap<IIterationHandle, IIteration> fIterations;
    private ItemMap<IIterationHandle, Boolean> fVisible;

    public static IterationStructure create(IProjectAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IterationStructure(handle, monitor);
    }

    private IterationStructure(IProjectAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 10);
        IProcessItemService pis = PlanningClientPlugin.getProcessItemService((IItemHandle)handle);
        this.fetchDevLinesAndIterations(pis, handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.fCurrentIterations = new ItemHashMap();
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 9);
        sub.beginTask("", this.fDevelopmentLines.size());
        for (IDevelopmentLineHandle devLine : this.fDevelopmentLines.keySet()) {
            IIteration[] ci = pis.getCurrentIterations(devLine, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
            this.fCurrentIterations.put((IItemHandle)devLine, (Object)new ItemArrayList(Arrays.asList(ci)));
        }
        sub.done();
        monitor.done();
    }

    public IDevelopmentLine getDevelopmentLine(IDevelopmentLineHandle handle) {
        return (IDevelopmentLine)this.fDevelopmentLines.get((IItemHandle)handle);
    }

    public ItemList<IDevelopmentLine> getDevelopmentLines(boolean showArchived) {
        ItemArrayList result = new ItemArrayList(this.fDevelopmentLines.size());
        for (IDevelopmentLine developmentLine : this.fDevelopmentLines.values()) {
            if (!showArchived && developmentLine.isArchived()) continue;
            result.add((Object)developmentLine);
        }
        return result;
    }

    public IIteration getIteration(IIterationHandle handle) {
        return (IIteration)this.fIterations.get((IItemHandle)handle);
    }

    public ItemList<IIteration> getIterations(IIterationHandle ... handles) {
        ItemArrayList result = new ItemArrayList(handles.length);
        IIterationHandle[] iIterationHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle handle = iIterationHandleArray[n2];
            result.add((Object)((IIteration)this.fIterations.get((IItemHandle)handle)));
            ++n2;
        }
        return result;
    }

    public ItemList<IIteration> getCurrentIterations(IDevelopmentLineHandle devLine) {
        ItemList result = (ItemList)this.fCurrentIterations.get((IItemHandle)devLine);
        return result != null ? result : ItemCollections.emptyList();
    }

    public List<ItemList<IIteration>> getCurrentIterations(ItemList<? extends IDevelopmentLineHandle> devLines) {
        ArrayList<ItemList<IIteration>> result = new ArrayList<ItemList<IIteration>>();
        for (IDevelopmentLineHandle developmentLineHandle : devLines) {
            result.add((ItemList<IIteration>)((ItemList)this.fCurrentIterations.get((IItemHandle)developmentLineHandle)));
        }
        return result;
    }

    public boolean showIteration(IIterationHandle iteration) {
        return (Boolean)this.fVisible.get((IItemHandle)iteration);
    }

    private void fetchDevLinesAndIterations(IProcessItemService pis, IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fIterations = new ItemHashMap();
        this.fDevelopmentLines = new ItemHashMap();
        this.fVisible = new ItemHashMap();
        List allItems = pis.fetchCompleteIterationStructure(projectAreaHandle, monitor);
        for (Object item : allItems) {
            if (item instanceof IIteration) {
                IIteration iteration = (IIteration)item;
                this.fIterations.put((IItemHandle)((IIterationHandle)iteration.getItemHandle()), (Object)iteration);
                continue;
            }
            if (!(item instanceof IDevelopmentLine)) continue;
            IDevelopmentLine devLine = (IDevelopmentLine)item;
            this.fDevelopmentLines.put((IItemHandle)((IDevelopmentLineHandle)devLine.getItemHandle()), (Object)devLine);
        }
        for (IDevelopmentLine devLine : this.fDevelopmentLines.values()) {
            IIterationHandle[] iterations;
            IIterationHandle[] iIterationHandleArray = iterations = devLine.getIterations();
            int n = iterations.length;
            int n2 = 0;
            while (n2 < n) {
                IIterationHandle handle = iIterationHandleArray[n2];
                this.markVisible((IIteration)this.fIterations.get((IItemHandle)handle));
                ++n2;
            }
        }
    }

    private boolean markVisible(IIteration iteration) {
        if (iteration != null) {
            IIterationHandle[] children;
            boolean result = iteration.hasDeliverable();
            IIterationHandle[] iIterationHandleArray = children = iteration.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IIterationHandle child = iIterationHandleArray[n2];
                result |= this.markVisible((IIteration)this.fIterations.get((IItemHandle)child));
                ++n2;
            }
            this.fVisible.put((IItemHandle)((IIterationHandle)iteration.getItemHandle()), (Object)result);
            return result;
        }
        return false;
    }
}

