/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class Items {
    public static Set<String> setProperties(IItem item) {
        HashSet<String> result = new HashSet<String>();
        for (String propertyName : ((ItemType)item.getItemType()).propertyNames()) {
            if (!item.isPropertySet(propertyName)) continue;
            result.add(propertyName);
        }
        return result;
    }

    public static List<String> allProperties(IItem item) {
        return ((ItemType)item.getItemType()).propertyNames();
    }

    public static void setOrigin(IItem item, ITeamRepository origin) {
        Items.setOrigin((EObject)item, origin, new IdentityHashMap());
    }

    private static void setOrigin(EObject object, ITeamRepository origin, Map<EObject, ?> visited) {
        if (visited.containsKey(object)) {
            return;
        }
        visited.put(object, null);
        if (object instanceof ItemHandle) {
            ItemHandle itemHandle = (ItemHandle)object;
            itemHandle.setOrigin((Object)origin);
        }
        Iterator iter = object.eContents().iterator();
        while (iter.hasNext()) {
            Items.setOrigin((EObject)iter.next(), origin, visited);
        }
        iter = object.eCrossReferences().iterator();
        while (iter.hasNext()) {
            Items.setOrigin((EObject)iter.next(), origin, visited);
        }
    }

    public static Location createLocation(IItem item) {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)item);
        return Location.itemLocation((IItemHandle)item, (String)repository.publicUriRoot());
    }

    public static UUID getUUID(String uuid) {
        if (uuid == null || uuid.length() == 0) {
            return null;
        }
        try {
            return UUID.valueOf((String)uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

