/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AssignmentAwareTeamAreaComparator
implements Comparator<ITeamAreaHandle> {
    private ItemMap<ITeamAreaHandle, Integer> fTeamArea2Assignment = new ItemHashMap(CMode.CURRENT_HANDLEONLY);

    private AssignmentAwareTeamAreaComparator(ItemMap<ITeamAreaHandle, Integer> assignments) {
        this.fTeamArea2Assignment = ItemCollections.unmodifiableItemMap(assignments);
    }

    public static AssignmentAwareTeamAreaComparator newInstance(IContributorHandle contributorHandle, IProjectAreaHandle projectAreaHandle, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IterationPlanClient iterationPlanClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)contributorHandle);
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)contributorHandle).itemManager();
        IContributor contributor = (IContributor)itemManager.fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(1));
        ITeamArea[] teamAreas = iterationPlanClient.getAssociatedTeamAreas(contributor, projectArea, (IProgressMonitor)progress.newChild(1));
        return AssignmentAwareTeamAreaComparator.newInstance((IContributorHandle)contributor, Arrays.asList(teamAreas), includeArchived, (IProgressMonitor)progress.newChild(1));
    }

    public static AssignmentAwareTeamAreaComparator newInstance(IContributorHandle contributorHandle, List<? extends ITeamAreaHandle> teamAreaHandles, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        int ticksTeamArea = 2 * teamAreaHandles.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 + ticksTeamArea));
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)contributorHandle);
        ResourcePlanningManager resourceManager = PlanningClientPlugin.getResourcePlanningClient((IItemHandle)contributorHandle).getResourcePlanningManager();
        IContributorInfo info = resourceManager.getContributorInfo(contributorHandle, false, (IProgressMonitor)progress.newChild(1));
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)contributorHandle).itemManager();
        IContributor contributor = (IContributor)itemManager.fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)progress.newChild(1));
        List teamAreas = itemManager.fetchCompleteItems(teamAreaHandles, 0, (IProgressMonitor)progress.newChild(1));
        ItemHashMap teamArea2Assignment = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
        for (ITeamArea teamArea : teamAreas) {
            IIteration iteration;
            if (!includeArchived && teamArea.isArchived()) {
                progress.setWorkRemaining(ticksTeamArea -= 2);
                continue;
            }
            IDevelopmentLine line = auditableClient.getDevelopmentLine((ITeamAreaHandle)teamArea, (IProgressMonitor)progress.newChild(1));
            if (line == null) {
                progress.setWorkRemaining(--ticksTeamArea);
                continue;
            }
            if (!includeArchived && line.isArchived() || (iteration = Iterations.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, (IAuditableCommon)auditableClient, (IProgressMonitor)progress.newChild(1))) == null || !includeArchived && iteration.isArchived()) continue;
            int assignment = info.getWorkAssignment((IContributorHandle)contributor, (IProcessAreaHandle)teamArea, (IDevelopmentLineHandle)line);
            teamArea2Assignment.put((IItemHandle)teamArea, (Object)assignment);
        }
        return new AssignmentAwareTeamAreaComparator((ItemMap<ITeamAreaHandle, Integer>)teamArea2Assignment);
    }

    @Override
    public int compare(ITeamAreaHandle o1, ITeamAreaHandle o2) {
        if (this.fTeamArea2Assignment.containsKey((IItemHandle)o1)) {
            if (this.fTeamArea2Assignment.containsKey((IItemHandle)o2)) {
                return (Integer)this.fTeamArea2Assignment.get((IItemHandle)o2) - (Integer)this.fTeamArea2Assignment.get((IItemHandle)o1);
            }
            return -1;
        }
        if (this.fTeamArea2Assignment.containsKey((IItemHandle)o2)) {
            return 1;
        }
        return 0;
    }
}

