/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AssignmentAwareProcessAreaComparator
implements Comparator<IProcessAreaHandle> {
    private ItemMap<IProcessAreaHandle, Integer> fProcessArea2Assignment = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IProjectAreaHandle, IDevelopmentLine> fProjectArea2DevLine = new ItemHashMap(CMode.CURRENT_HANDLEONLY);

    private AssignmentAwareProcessAreaComparator(ItemMap<IProcessAreaHandle, Integer> assignments, ItemMap<IProjectAreaHandle, IDevelopmentLine> devLines) {
        this.fProcessArea2Assignment = ItemCollections.unmodifiableItemMap(assignments);
        this.fProjectArea2DevLine = devLines;
    }

    public static AssignmentAwareProcessAreaComparator newInstance(IContributorHandle contributorHandle, IProjectAreaHandle projectAreaHandle, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IterationPlanClient iterationPlanClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)contributorHandle);
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)contributorHandle).itemManager();
        IContributor contributor = (IContributor)itemManager.fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)progress.newChild(1));
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(1));
        IProcessArea[] processAreas = iterationPlanClient.getAssociatedProcessAreas(contributor, projectArea, (IProgressMonitor)progress.newChild(1));
        return AssignmentAwareProcessAreaComparator.newInstance((IContributorHandle)contributor, Arrays.asList(processAreas), includeArchived, (IProgressMonitor)progress.newChild(1));
    }

    public static AssignmentAwareProcessAreaComparator newInstance(IContributorHandle contributorHandle, List<? extends IProcessAreaHandle> processAreaHandles, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        int ticksTeamArea = 2 * processAreaHandles.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 + ticksTeamArea));
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)contributorHandle);
        ResourcePlanningManager resourceManager = PlanningClientPlugin.getResourcePlanningClient((IItemHandle)contributorHandle).getResourcePlanningManager();
        IContributorInfo info = resourceManager.getContributorInfo(contributorHandle, false, (IProgressMonitor)progress.newChild(1));
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)contributorHandle).itemManager();
        IContributor contributor = (IContributor)itemManager.fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)progress.newChild(1));
        List processAreas = itemManager.fetchCompleteItems(processAreaHandles, 0, (IProgressMonitor)progress.newChild(1));
        ItemHashMap processArea2Assignment = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
        ItemHashMap devLines = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
        for (IProcessArea processArea : processAreas) {
            if (!includeArchived && processArea.isArchived()) {
                progress.setWorkRemaining(ticksTeamArea -= 2);
                continue;
            }
            if (processArea instanceof ITeamArea) {
                IIteration iteration;
                IDevelopmentLine line = auditableClient.getDevelopmentLine((ITeamAreaHandle)((ITeamArea)processArea), (IProgressMonitor)progress.newChild(1));
                if (line == null) {
                    progress.setWorkRemaining(--ticksTeamArea);
                    continue;
                }
                if (!includeArchived && line.isArchived() || (iteration = Iterations.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, (IAuditableCommon)auditableClient, (IProgressMonitor)progress.newChild(1))) == null || !includeArchived && iteration.isArchived()) continue;
                int assignment = info.getWorkAssignment((IContributorHandle)contributor, (IProcessAreaHandle)processArea, (IDevelopmentLineHandle)line);
                processArea2Assignment.put((IItemHandle)processArea, (Object)assignment);
                continue;
            }
            if (!(processArea instanceof IProjectArea)) continue;
            IDevelopmentLineHandle[] devLineHandles = ((IProjectArea)processArea).getDevelopmentLines();
            List lines = itemManager.fetchCompleteItems(Arrays.asList(devLineHandles), 0, (IProgressMonitor)progress.newChild(1));
            SubMonitor sub = progress.newChild(1);
            sub.beginTask("", devLineHandles.length);
            for (IDevelopmentLine line : lines) {
                int assignment = info.getWorkAssignment((IContributorHandle)contributor, (IProcessAreaHandle)processArea, (IDevelopmentLineHandle)line);
                Integer last = (Integer)processArea2Assignment.get((IItemHandle)processArea);
                if (last == null || last < assignment) {
                    processArea2Assignment.put((IItemHandle)processArea, (Object)assignment);
                    devLines.put((IItemHandle)((IProjectAreaHandle)processArea.getItemHandle()), (Object)line);
                }
                sub.worked(1);
            }
        }
        return new AssignmentAwareProcessAreaComparator((ItemMap<IProcessAreaHandle, Integer>)processArea2Assignment, (ItemMap<IProjectAreaHandle, IDevelopmentLine>)devLines);
    }

    @Override
    public int compare(IProcessAreaHandle o1, IProcessAreaHandle o2) {
        if (this.fProcessArea2Assignment.containsKey((IItemHandle)o1)) {
            if (this.fProcessArea2Assignment.containsKey((IItemHandle)o2)) {
                return (Integer)this.fProcessArea2Assignment.get((IItemHandle)o2) - (Integer)this.fProcessArea2Assignment.get((IItemHandle)o1);
            }
            return -1;
        }
        if (this.fProcessArea2Assignment.containsKey((IItemHandle)o2)) {
            return 1;
        }
        return 0;
    }

    public IDevelopmentLine getDevelopmentLine(IProjectAreaHandle projectArea) {
        return (IDevelopmentLine)this.fProjectArea2DevLine.get((IItemHandle)projectArea);
    }
}

