/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.WorkItemEstimator;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class TeamLoadDelta {
    private static final int UNTOUCHED = 0;
    private static final int APPLIED = 2;
    private static final int UNDONE = 4;
    private static final Iterable<UUID> fgNullIterable = new NullIterable<UUID>();
    private int fState = 0;
    private IWorkItem fWorkItem;
    private LoadItem fItem;
    private long deltaSumOfEstimates;
    private Map<Mode, Set<UUID>> deltaEstimated = new HashMap<Mode, Set<UUID>>();
    private Map<Mode, Set<UUID>> deltaOpen = new HashMap<Mode, Set<UUID>>();
    private Map<Mode, Set<UUID>> deltaClosed = new HashMap<Mode, Set<UUID>>();

    private TeamLoadDelta(LoadItem item, IWorkItem workItem) {
        Assert.isNotNull((Object)workItem);
        Assert.isNotNull((Object)item);
        this.fWorkItem = workItem;
        this.fItem = item;
    }

    public IWorkItem getWorkItem() {
        return this.fWorkItem;
    }

    public LoadItem getItem() {
        return this.fItem;
    }

    TeamLoadDelta adopt(LoadItem item) {
        Assert.isNotNull((Object)item);
        this.fItem = item;
        this.fState = 0;
        return this;
    }

    public final void apply() {
        if ((this.fState & 2) != 0) {
            throw new IllegalStateException();
        }
        this.fItem.deltaApply(this, false);
        this.fState |= 2;
    }

    public final void undo() {
        if ((this.fState & 2) == 0) {
            throw new IllegalStateException();
        }
        if ((this.fState & 4) != 0) {
            throw new IllegalStateException();
        }
        this.fItem.deltaApply(this, true);
        this.fState &= 0xFFFFFFFD;
        this.fState |= 4;
    }

    public long deltaSumOfEstimates() {
        return this.deltaSumOfEstimates;
    }

    public Iterable<UUID> deltaOpen(Mode mode) {
        return TeamLoadDelta.saveIterable(this.deltaOpen, mode);
    }

    public Iterable<UUID> deltaEstimated(Mode mode) {
        return TeamLoadDelta.saveIterable(this.deltaEstimated, mode);
    }

    public Iterable<UUID> deltaClosed(Mode mode) {
        return TeamLoadDelta.saveIterable(this.deltaClosed, mode);
    }

    private static Iterable<UUID> saveIterable(Map<Mode, Set<UUID>> map, Mode mode) {
        Set<UUID> set = map.get((Object)mode);
        if (set != null) {
            return set;
        }
        return fgNullIterable;
    }

    public static TeamLoadDelta updateSumOfEstimates(LoadItem item, IWorkItem workItem, long oldEstimate, long newEstimate, long oldTimeSpent, long newTimeSpent) {
        TeamLoadDelta delta = new TeamLoadDelta(item, workItem);
        boolean noEstimate = newEstimate < 0L;
        long oldValue = Math.max(0L, oldEstimate - Math.max(0L, oldTimeSpent));
        long newValue = Math.max(0L, newEstimate - Math.max(0L, newTimeSpent));
        if (item.getEstimatedItems().contains(workItem.getItemId())) {
            if (noEstimate) {
                delta.deltaSumOfEstimates = WorkItemEstimator.getInstance().getDefaultEstimate() - oldValue;
                delta.ensure(Mode.REMOVE, delta.deltaEstimated).add(workItem.getItemId());
            } else {
                delta.deltaSumOfEstimates = newValue - oldValue;
            }
        } else if (!noEstimate) {
            delta.deltaSumOfEstimates = newValue - WorkItemEstimator.getInstance().getDefaultEstimate();
            delta.ensure(Mode.ADD, delta.deltaEstimated).add(workItem.getItemId());
        }
        return delta;
    }

    public static TeamLoadDelta add(LoadItem item, IWorkItem workItem) {
        TeamLoadDelta delta = new TeamLoadDelta(item, workItem);
        delta.ensure(Mode.ADD, delta.deltaOpen).add(workItem.getItemId());
        long estimate = Math.max(-1L, workItem.getDuration() - Math.max(0L, WorkItems.getTimeSpent(workItem)));
        if (estimate < 0L) {
            delta.deltaSumOfEstimates = WorkItemEstimator.getInstance().getDefaultEstimate();
        } else {
            delta.deltaSumOfEstimates = estimate;
            delta.ensure(Mode.ADD, delta.deltaEstimated).add(workItem.getItemId());
        }
        if (item.getClosedItems().contains(workItem.getItemId())) {
            delta.ensure(Mode.REMOVE, delta.deltaClosed).add(workItem.getItemId());
        }
        return delta;
    }

    public static TeamLoadDelta remove(LoadItem item, IWorkItem workItem, IWorkflowInfo info) {
        TeamLoadDelta delta = new TeamLoadDelta(item, workItem);
        delta.ensure(Mode.REMOVE, delta.deltaOpen).add(workItem.getItemId());
        long estimate = Math.max(-1L, workItem.getDuration() - Math.max(0L, WorkItems.getTimeSpent(workItem)));
        if (estimate < 0L) {
            delta.deltaSumOfEstimates = -WorkItemEstimator.getInstance().getDefaultEstimate();
        } else {
            delta.deltaSumOfEstimates = -estimate;
            delta.ensure(Mode.REMOVE, delta.deltaEstimated).add(workItem.getItemId());
        }
        if (WorkItems.isResolved(workItem, info)) {
            delta.ensure(Mode.ADD, delta.deltaClosed).add(workItem.getItemId());
        }
        return delta;
    }

    private <K, E> Set<E> ensure(K key, Map<K, Set<E>> map) {
        Set<E> value = map.get(key);
        if (value == null) {
            value = new HashSet();
            map.put(key, value);
        }
        return value;
    }

    public static enum Mode {
        ADD,
        REMOVE;

    }

    private static final class NullIterable<T>
    implements Iterable<T> {
        private NullIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

