/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.Messages;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.duration.TimeUnit;
import com.ibm.team.repository.common.util.NLS;

public class LoadItems {
    public static final Message MSG_NO_ESTIMATES = new Message(Messages.LoadItems_MESSAGE_NO_WORK_ESTIMATED, Severity.WARNING);
    public static final Message MSG_DEFAULT_WORK_ASSIGNMENT = new Message(Messages.LoadItems_MESSAGE_USING_DEFAULT_WORK_ASSIGNMENT, Severity.INFO);
    public static final Message MSG_NO_WORK_TIME = new Message(Messages.LoadItems_MESSAGE_NO_WORK_TIME_LEFT, Severity.INFO);
    private static final String STR_999_PLUS = Messages.LoadItems_999_PLUS;

    public static Message getMessage(AbstractLoadItem item) {
        if (item.getWorkTimeLeft() <= 0L) {
            return MSG_NO_WORK_TIME;
        }
        if (LoadItems.getQualityOfPlanning(item) == 0) {
            return MSG_NO_ESTIMATES;
        }
        return null;
    }

    public static boolean isOverbooked(AbstractLoadItem item) {
        return item.getWorkTimeLeft() < item.getSumOfEstimates();
    }

    public static int getHoursOverbooked(AbstractLoadItem item) {
        return Math.round((float)(item.getSumOfEstimates() - item.getWorkTimeLeft()) / (float)TimeUnit.HOURS.getDivisor());
    }

    public static int getQualityOfPlanning(AbstractLoadItem item) {
        if (item.getNumberOfOpenItems() < item.getNumberOfEstimatedItems()) {
            return 100;
        }
        if (item.getNumberOfOpenItems() == 0L) {
            return 100;
        }
        return Math.round(100.0f * ((float)item.getNumberOfEstimatedItems() / (float)item.getNumberOfOpenItems()));
    }

    public static String getTextQualityOfPlanning(LoadItem item) {
        int value = LoadItems.getQualityOfPlanning(item);
        if (value < 33) {
            return Messages.LoadItems_QUALITY_POOR;
        }
        if (value >= 33 && value < 66) {
            return Messages.LoadItems_QUALITY_FAIR;
        }
        if (value >= 66 && value < 95) {
            return Messages.LoadItems_QUALITY_GOOD;
        }
        if (value >= 95) {
            return Messages.LoadItems_QUALITY_EXCELLENT;
        }
        return Messages.LoadItems_QUALITY_UNKNOWN;
    }

    public static String getTextWorkTimeLeft(LoadItem item) {
        long value = Math.round((double)item.getWorkTimeLeft() / TimeUnit.HOURS.getDivisor());
        return String.valueOf(value);
    }

    public static String getTextSumOfEstimates(LoadItem item) {
        long value = Math.round((double)item.getSumOfEstimates() / TimeUnit.HOURS.getDivisor());
        return String.valueOf(value);
    }

    public static String getTextEstimate(AbstractLoadItem item) {
        return NLS.bind((String)Messages.LoadItems_WORK_ESTIMATED, (Object)LoadItems.getQualityOfPlanning(item), (Object[])new Object[0]);
    }

    public static String getTextEstimateShort(AbstractLoadItem item) {
        return NLS.bind((String)Messages.LoadItems_WORK_ESTIMATED_SHORT, (Object)LoadItems.getQualityOfPlanning(item), (Object[])new Object[0]);
    }

    public static String getMaxTextEstimate() {
        return NLS.bind((String)Messages.LoadItems_WORK_ESTIMATED, (Object)100, (Object[])new Object[0]);
    }

    public static String getTextAssignment(LoadItem item) {
        return NLS.bind((String)Messages.LoadItems_WORK_ASSIGNMENT, (Object)item.getAssignmentRange(), (Object[])new Object[0]);
    }

    public static String getTextHours(AbstractLoadItem item) {
        StringBuilder text = LoadItems.internalGetTextHours(item);
        return NLS.bind((String)Messages.LoadItems_WORK_HOURS, (Object)LoadItems.formatHours(item.getSumOfEstimates()), (Object[])new Object[]{LoadItems.formatHours(item.getWorkTimeLeft()), text});
    }

    public static String getTextHoursShort(AbstractLoadItem item) {
        StringBuilder text = LoadItems.internalGetTextHours(item);
        return NLS.bind((String)Messages.LoadItems_WORK_HOURS_SHORT, (Object)LoadItems.formatHours(item.getSumOfEstimates()), (Object[])new Object[]{LoadItems.formatHours(item.getWorkTimeLeft()), text});
    }

    private static StringBuilder internalGetTextHours(AbstractLoadItem item) {
        StringBuilder text = new StringBuilder();
        int hoursOverbooked = Math.round((float)(item.getWorkTimeLeft() - item.getSumOfEstimates()) / (float)TimeUnit.HOURS.getDivisor());
        if (Math.abs(hoursOverbooked) > 999) {
            text.append(STR_999_PLUS);
        } else {
            if (hoursOverbooked > 0) {
                text.append('+');
            }
            text.append(hoursOverbooked);
        }
        return text;
    }

    private static String formatHours(long value) {
        StringBuilder text = new StringBuilder();
        long hour = Math.round((double)value / TimeUnit.HOURS.getDivisor());
        if (hour == 0L) {
            if (value > 0L) {
                text.append('<');
                text.append(1);
            } else {
                text.append(0);
            }
        } else if (hour > 999L) {
            text.append(STR_999_PLUS);
        } else {
            text.append(hour);
        }
        return text.toString();
    }

    public static String getMaxTextHours() {
        return NLS.bind((String)Messages.LoadItems_WORK_HOURS, (Object)STR_999_PLUS, (Object[])new Object[]{STR_999_PLUS, STR_999_PLUS});
    }

    public static String getTextOpenClose(LoadItem item) {
        int closeCount = item.getClosedItems().size();
        int openCount = item.getOpenItems().size();
        return NLS.bind((String)Messages.LoadItems_OPEN_CLOSED_COUNT, (Object)(closeCount > 999 ? STR_999_PLUS : Integer.valueOf(closeCount)), (Object[])new Object[]{openCount > 999 ? STR_999_PLUS : Integer.valueOf(openCount)});
    }
}

