/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.ResourceDelta;
import com.ibm.team.apt.internal.client.teamload.TeamLoadDelta;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public class LoadItem
extends AbstractLoadItem {
    public static final int ASSIGNMENT_NOT_FOUND = -1;
    static final boolean TRACE;
    private final LoadInformation fLoadInformation;
    protected IContributor fContributor;
    protected ItemCollection<IContributorAbsence> fAbsences;
    protected long fWorkTimeLeft;
    protected long fSumOfEstimates;
    protected boolean fUsesDefaultWorkLocation;
    protected boolean fUsesDefaultWorkAssignment;
    protected int fMinAssignment;
    protected int fMaxAssignment;
    protected Set<UUID> fOpenItems;
    protected Set<UUID> fEstimatedItems;
    protected Set<UUID> fClosedItems;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.apt.client/traceLoadItems");
        TRACE = Boolean.parseBoolean(value);
    }

    public LoadItem(LoadInformation loadInformation, IContributor contributor, ItemCollection<IContributorAbsence> absences, long workTimeLeft, int minAssignment, int maxAssignment, boolean defaultAssignment, boolean defaultWorkLocation, long sumOfEstimates, Set<UUID> openItems, Set<UUID> estiamtedItems, Set<UUID> closedItems) {
        Assert.isNotNull((Object)loadInformation);
        Assert.isNotNull((Object)contributor);
        this.fLoadInformation = loadInformation;
        this.fContributor = contributor;
        this.fAbsences = absences;
        this.fWorkTimeLeft = workTimeLeft;
        this.fMinAssignment = minAssignment == -1 ? 0 : minAssignment;
        this.fMaxAssignment = maxAssignment == -1 ? 0 : maxAssignment;
        this.fUsesDefaultWorkAssignment = defaultAssignment;
        this.fUsesDefaultWorkLocation = defaultWorkLocation;
        this.fSumOfEstimates = sumOfEstimates;
        this.fOpenItems = openItems;
        this.fEstimatedItems = estiamtedItems;
        this.fClosedItems = closedItems;
    }

    public final IContributor getContributor() {
        return this.fContributor;
    }

    public final LoadInformation getLoadInformation() {
        return this.fLoadInformation;
    }

    public Collection<IContributorAbsence> getAbsences() {
        return Collections.unmodifiableCollection(this.fAbsences.toCollection());
    }

    @Override
    public long getNumberOfOpenItems() {
        return this.fOpenItems.size();
    }

    public Set<UUID> getOpenItems() {
        return Collections.unmodifiableSet(this.fOpenItems);
    }

    @Override
    public long getNumberOfEstimatedItems() {
        return this.fEstimatedItems.size();
    }

    public Set<UUID> getEstimatedItems() {
        return Collections.unmodifiableSet(this.fEstimatedItems);
    }

    @Override
    public long getNumberOfClosedItems() {
        return this.fClosedItems.size();
    }

    public Set<UUID> getClosedItems() {
        return Collections.unmodifiableSet(this.fClosedItems);
    }

    @Override
    public long getWorkTimeLeft() {
        return this.fWorkTimeLeft;
    }

    public String getAssignmentRange() {
        String assignmentRange = "";
        assignmentRange = this.fMinAssignment == this.fMaxAssignment ? String.valueOf(assignmentRange) + this.fMinAssignment : String.valueOf(this.fMinAssignment) + " - " + this.fMaxAssignment;
        return assignmentRange;
    }

    @Override
    public long getSumOfEstimates() {
        return this.fSumOfEstimates;
    }

    public boolean usesDefaultWorkLocation() {
        return this.fUsesDefaultWorkLocation;
    }

    public boolean usesDefaultWorkAssignment() {
        return this.fUsesDefaultWorkAssignment;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadItem)) {
            return false;
        }
        LoadItem other = (LoadItem)o;
        return this.fContributor.sameItemId((IItemHandle)other.fContributor);
    }

    public int hashCode() {
        return this.fContributor.hashCode();
    }

    void deltaApply(ResourceDelta delta) {
        this.fAbsences.clear();
        this.fAbsences.addAll(delta.getNewAbsences());
        this.fWorkTimeLeft = delta.getNewWorkTimeLeft();
        this.fUsesDefaultWorkAssignment = delta.getNewUsesDefaultWorkAssignment();
        this.fUsesDefaultWorkLocation = delta.getNewUsesDefaultWorkLocation();
    }

    void deltaApply(TeamLoadDelta delta, boolean undo) {
        long deltaSumOfEstimates = delta.deltaSumOfEstimates();
        this.fSumOfEstimates = !undo ? (this.fSumOfEstimates += deltaSumOfEstimates) : (this.fSumOfEstimates -= deltaSumOfEstimates);
        for (UUID uuid : delta.deltaEstimated(TeamLoadDelta.Mode.ADD)) {
            if (!undo) {
                this.fEstimatedItems.add(uuid);
                continue;
            }
            this.fEstimatedItems.remove(uuid);
        }
        for (UUID uuid : delta.deltaEstimated(TeamLoadDelta.Mode.REMOVE)) {
            if (!undo) {
                this.fEstimatedItems.remove(uuid);
                continue;
            }
            this.fEstimatedItems.add(uuid);
        }
        for (UUID uuid : delta.deltaOpen(TeamLoadDelta.Mode.ADD)) {
            if (!undo) {
                this.fOpenItems.add(uuid);
                continue;
            }
            this.fOpenItems.remove(uuid);
        }
        for (UUID uuid : delta.deltaOpen(TeamLoadDelta.Mode.REMOVE)) {
            if (!undo) {
                this.fOpenItems.remove(uuid);
                continue;
            }
            this.fOpenItems.add(uuid);
        }
        for (UUID uuid : delta.deltaClosed(TeamLoadDelta.Mode.ADD)) {
            if (!undo) {
                this.fClosedItems.add(uuid);
                continue;
            }
            this.fClosedItems.remove(uuid);
        }
        for (UUID uuid : delta.deltaClosed(TeamLoadDelta.Mode.REMOVE)) {
            if (!undo) {
                this.fClosedItems.remove(uuid);
                continue;
            }
            this.fClosedItems.add(uuid);
        }
        LoadItem.bug46407(this);
    }

    private static void bug46407(LoadItem item) {
        boolean[] changes = new boolean[3];
        if (item.fSumOfEstimates < 0L) {
            changes[0] = true;
            item.fSumOfEstimates = 0L;
        }
        changes[1] = item.fEstimatedItems.retainAll(item.fOpenItems);
        changes[2] = item.fClosedItems.removeAll(item.fOpenItems);
        if (TRACE) {
            if (changes[0]) {
                PlanningClientPlugin.log("LoadItem: Fixed illegal sum of estimate", new Exception());
            }
            if (changes[1]) {
                PlanningClientPlugin.log("LoadItem: Fixed illegal estimated/open relation", new Exception());
            }
            if (changes[2]) {
                PlanningClientPlugin.log("LoadItem: Fixed illegal open/closed relation", new Exception());
            }
        }
    }
}

