/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.facades;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.apt.internal.common.WorkflowUtils;
import com.ibm.team.rtc.common.scriptengine.AbstractWrapperScriptType;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

@Stub(value="com.ibm.team.apt.client.WorkflowInfo")
@WrapType(value=IWorkflowInfo.class)
public class WorkflowInfoScriptType
extends AbstractWrapperScriptType {
    private String[] fAllStateIds;

    public WorkflowInfoScriptType(Context cx, Scriptable scope, IWorkflowInfo wrapped) {
        super(cx, scope, (Object)wrapped);
    }

    @Function
    public String getId() {
        return this.getSubject().getIdentifier();
    }

    @Function
    public String getStartStateId() {
        Identifier startActionId = this.getSubject().getStartActionId();
        if (startActionId == null) {
            return this.getStateIds()[0];
        }
        return WorkflowInfoScriptType.getActionResultState(this.getSubject(), (Identifier<IWorkflowAction>)startActionId).getStringIdentifier();
    }

    @Function
    public String[] getStateIds() {
        if (this.fAllStateIds == null) {
            Identifier[] allStateIds = WorkflowUtils.getSortedStates((IWorkflowInfo)this.getSubject());
            this.fAllStateIds = new String[allStateIds.length];
            int i = 0;
            while (i < allStateIds.length) {
                this.fAllStateIds[i] = allStateIds[i].getStringIdentifier();
                ++i;
            }
        }
        return this.fAllStateIds;
    }

    @Function
    public int getStateGroup(String stateId) {
        return this.getSubject().getStateGroup(Identifier.create(IState.class, (String)stateId));
    }

    @Function
    public String getStateLabel(String stateId) {
        return this.getSubject().getStateName(Identifier.create(IState.class, (String)stateId));
    }

    @Function
    public String getActionResultState(String actionId) {
        return WorkflowInfoScriptType.getActionResultState(this.getSubject(), (Identifier<IWorkflowAction>)Identifier.create(IWorkflowAction.class, (String)actionId)).getStringIdentifier();
    }

    private static Identifier<IState> getActionResultState(IWorkflowInfo workflowInfo, Identifier<IWorkflowAction> action) {
        Identifier result = workflowInfo.getActionResultState(action);
        String stripOffPrefix = Utils.stripOffPrefix((String)result.getStringIdentifier(), (char)'s');
        return Identifier.create(IState.class, (String)stripOffPrefix);
    }

    protected IWorkflowInfo getSubject() {
        return (IWorkflowInfo)super.getSubject();
    }
}

