/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.facades;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.rtc.common.scriptengine.AbstractWrapperScriptType;
import com.ibm.team.rtc.common.scriptengine.annotation.Constant;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.ILiteral;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

@Stub(value="com.ibm.team.apt.client.PlanningAttributeType")
@WrapType(value=PlanningAttributeType.class)
public class PlanningAttributeTypeScriptType
extends AbstractWrapperScriptType {
    @Constant
    public static final PlanningAttributeType STRING = PlanningAttributeType.STRING;
    @Constant
    public static final PlanningAttributeType HTML = PlanningAttributeType.HTML;
    @Constant
    public static final PlanningAttributeType INTEGER = PlanningAttributeType.INTEGER;
    @Constant
    public static final PlanningAttributeType FLOAT = PlanningAttributeType.FLOAT;
    @Constant
    public static final PlanningAttributeType DECIMAL = PlanningAttributeType.DECIMAL;
    @Constant
    public static final PlanningAttributeType BOOLEAN = PlanningAttributeType.BOOLEAN;
    @Constant
    public static final PlanningAttributeType INSTANT = PlanningAttributeType.INSTANT;
    @Constant
    public static final PlanningAttributeType DURATION = PlanningAttributeType.DURATION;
    @Constant
    public static final PlanningAttributeType TIMESPAN = PlanningAttributeType.TIMESPAN;
    @Constant
    public static final PlanningAttributeType SEQUENCEVALUE = PlanningAttributeType.SEQUENCEVALUE;
    @Constant
    public static final PlanningAttributeType RANKING = PlanningAttributeType.RANKING;
    @Constant
    public static final PlanningAttributeType TAGS = PlanningAttributeType.TAGS;
    @Constant
    public static final PlanningAttributeType CHECKERREPORT = PlanningAttributeType.CHECKERREPORT;
    @Constant
    public static final PlanningAttributeType UUID = PlanningAttributeType.UUID;
    @Constant
    public static final PlanningAttributeType WORKITEM_TYPE = PlanningAttributeType.WORKITEM_TYPE;
    @Constant
    public static final PlanningAttributeType WORKFLOW_STATE = PlanningAttributeType.WORKFLOW_STATE;
    @Constant
    public static final PlanningAttributeType ITEM = PlanningAttributeType.ITEM;
    @Constant
    public static final PlanningAttributeType ENUMERATION = PlanningAttributeType.ENUMERATION;
    @Constant
    public static final PlanningAttributeType VOID = PlanningAttributeType.VOID;
    private static final Map<PlanningAttributeType, DefaultType> LEGACY = new HashMap<PlanningAttributeType, DefaultType>();

    static {
        LEGACY.put(PlanningAttributeType.STRING, new StringType());
        LEGACY.put(PlanningAttributeType.HTML, new StringType());
        LEGACY.put(PlanningAttributeType.INTEGER, new ComparableType());
        LEGACY.put(PlanningAttributeType.FLOAT, new ComparableType());
        LEGACY.put(PlanningAttributeType.DECIMAL, new ComparableType());
        LEGACY.put(PlanningAttributeType.BOOLEAN, new ComparableType());
        LEGACY.put(PlanningAttributeType.INSTANT, new ComparableType());
        LEGACY.put(PlanningAttributeType.DURATION, new DurationType());
        LEGACY.put(PlanningAttributeType.TIMESPAN, new TimespanType());
        LEGACY.put(PlanningAttributeType.SEQUENCEVALUE, new ComparableType());
        LEGACY.put(PlanningAttributeType.RANKING, new DefaultType());
        LEGACY.put(PlanningAttributeType.TAGS, new DefaultType());
        LEGACY.put(PlanningAttributeType.CHECKERREPORT, new DefaultType());
        LEGACY.put(PlanningAttributeType.UUID, new DefaultType());
        LEGACY.put(PlanningAttributeType.WORKITEM_TYPE, new DefaultType());
        LEGACY.put(PlanningAttributeType.WORKFLOW_STATE, new DefaultType());
        LEGACY.put(PlanningAttributeType.ITEM, new ItemType());
        LEGACY.put(PlanningAttributeType.REFERENCE, new ReferenceType());
        LEGACY.put(PlanningAttributeType.ENUMERATION, new EnumType());
        LEGACY.put(PlanningAttributeType.VOID, new VoidType());
    }

    public PlanningAttributeTypeScriptType(Context cx, Scriptable scope, PlanningAttributeType wrapped) {
        super(cx, scope, (Object)wrapped);
    }

    @Function
    public int compareValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return (v1 == null ? 1 : 0) - (v2 == null ? 1 : 0);
        }
        return LEGACY.get(this.getSubject()).compareValues(v1, v2);
    }

    @Function
    public boolean equalsValues(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return v1 == v2;
        }
        return LEGACY.get(this.getSubject()).equalValues(v1, v2);
    }

    protected PlanningAttributeType getSubject() {
        return (PlanningAttributeType)super.getSubject();
    }

    private static class ComparableType
    extends DefaultType {
        private ComparableType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            return ((Comparable)v1).compareTo(v2);
        }
    }

    private static class DefaultType {
        private DefaultType() {
        }

        public boolean equalValues(Object v1, Object v2) {
            return v1.equals(v2);
        }

        public int compareValues(Object v1, Object v2) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ DefaultType(DefaultType defaultType, DefaultType defaultType2) {
            this();
        }
    }

    private static class DurationType
    extends DefaultType {
        private DurationType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            Duration d1 = (Duration)v1;
            Duration d2 = (Duration)v2;
            if (!d1.isSpecified() || !d2.isSpecified()) {
                return (d1.isSpecified() ? 1 : 0) - (d2.isSpecified() ? 1 : 0);
            }
            if (d1.longValue() < d2.longValue()) {
                return -1;
            }
            if (d1.longValue() > d2.longValue()) {
                return 1;
            }
            return 0;
        }
    }

    private static class EnumType
    extends DefaultType {
        private EnumType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            return ((ILiteral)v1).compareTo((Object)((ILiteral)v2));
        }
    }

    private static class ItemType
    extends DefaultType {
        private ItemType() {
            super(null, null);
        }

        @Override
        public boolean equalValues(Object v1, Object v2) {
            return ((IItemHandle)v1).sameItemId((IItemHandle)v2);
        }
    }

    private static class ReferenceType
    extends DefaultType {
        private ReferenceType() {
            super(null, null);
        }

        @Override
        public boolean equalValues(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o2 != null && ((IReference)o1).createURI().equals(((IReference)o2).createURI());
        }
    }

    private static class StringType
    extends DefaultType {
        private StringType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            return CollatorCache.getInstance().compare(v1, v2);
        }
    }

    private static class TimespanType
    extends DefaultType {
        private TimespanType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            return Dates.compareTo((Date)((Timespan)v1).getStart(), (Date)((Timespan)v2).getStart());
        }
    }

    private static class VoidType
    extends DefaultType {
        private VoidType() {
            super(null, null);
        }

        @Override
        public int compareValues(Object v1, Object v2) {
            throw new UnsupportedOperationException();
        }
    }
}

