/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.facades;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.scripting.facades.PlanElementScriptType;
import com.ibm.team.apt.internal.common.Instant;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.annotation.Constant;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

@Stub(value="com.ibm.team.apt.client.PlanModel")
@WrapType(value=ResolvedPlan.class)
public class PlanModelScriptType
extends PlanElementScriptType {
    @Constant
    public static final IPlanningAttributeIdentifier RESOURCE_PLANNING = ResolvedPlan.RESOURCE_PLANNING;
    @Constant
    public static final IPlanningAttributeIdentifier REFERENCE_TIME = ResolvedPlan.REFERENCE_TIME;

    public PlanModelScriptType(Context cx, Scriptable scope, ResolvedPlan plan) {
        super(cx, scope, plan);
    }

    @Function
    public PlanItem getPlanItem(String itemIdString) {
        return this.getSubject().getPlanItem(UUID.valueOf((String)itemIdString));
    }

    @Function
    public IItem getItem(String itemIdString) {
        UUID itemId = UUID.valueOf((String)itemIdString);
        ICategory result = null;
        ResolvedPlan subject = this.getSubject();
        result = subject.getResolvedCategory((ICategoryHandle)ICategory.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedContributor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedDevelopmentLine((IDevelopmentLineHandle)IDevelopmentLine.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        result = subject.getResolvedIteration((IIterationHandle)IIteration.ITEM_TYPE.createItemHandle(itemId, null));
        if (result != null) {
            return result;
        }
        IProcessAreaHandle handle = null;
        handle = subject.getProjectArea().getItemHandle().getItemId().equals((Object)itemId) ? (IProcessAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(itemId, null) : (IProcessAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(itemId, null);
        result = subject.getResolvedProcessArea(handle);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Function
    public Instant getReferenceTime() {
        return new Instant(this.getSubject().getReferenceTime());
    }

    @Function
    public IPlanningAttribute<?, ?> findAttribute(IPlanningAttributeIdentifier attributeId) {
        return this.getSubject().findAttribute(attributeId);
    }

    @Function
    public IPlanningAttribute[] getAllAttributes() {
        return (IPlanningAttribute[])PlanModelScriptType.toArray(this.getSubject().getAllAttributes(), IPlanningAttribute.class);
    }

    @Function
    public IPlanCheckDescription[] getPlanChecks() {
        ArrayList<IPlanCheckDescription> result = new ArrayList<IPlanCheckDescription>();
        for (PlanCheck planCheck : this.getSubject().getPlanChecker().getChecks()) {
            result.add(planCheck.getCheckDescription());
        }
        return (IPlanCheckDescription[])PlanModelScriptType.toArray(result, IPlanCheckDescription.class);
    }

    @Function
    public IPlanningAttributeIdentifier getComplexityAttribute() {
        IComplexityAttribute complexityAttribute;
        if (this.getSubject() instanceof ResolvedIterationPlan && (complexityAttribute = ((ResolvedIterationPlan)this.getSubject()).getComplexityAttribute()) != null) {
            return PlanningAttributeIdentifier.create(complexityAttribute.getAttributeId());
        }
        return null;
    }

    @Function
    public boolean useComplexity() {
        if (this.getSubject() instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)this.getSubject()).getPlanType().getPlanItems().isReleasePlan();
        }
        return false;
    }

    @Function
    public String getEstimateMode() {
        return this.getSubject().getDurationSupport().getEstimateMode().name();
    }

    @Function
    public IContributor[] getTeamMembers() {
        return (IContributor[])PlanModelScriptType.toArray((Collection)this.getSubject().getOwners().toCollection(), IContributor.class);
    }

    @Function
    public ICategory[] getPlanCategories() {
        return (ICategory[])PlanModelScriptType.toArray((Collection)this.getSubject().getCategories().toCollection(), ICategory.class);
    }

    @Function
    public IIteration[] getIterations() {
        return (IIteration[])PlanModelScriptType.toArray((Collection)this.getSubject().getIntervals().toCollection(), IIteration.class);
    }

    @Function
    public Node getIterationHierarchy() {
        return ((ResolvedIterationPlan)this.getSubject()).getIterationHierarchy();
    }

    @Function
    public boolean isPrimaryCategory(ICategoryHandle category) {
        return ((ResolvedIterationPlan)this.getSubject()).isPrimaryCategory(category);
    }

    @Function
    public boolean isPrimaryIteration(IIterationHandle iteration) {
        return ((ResolvedIterationPlan)this.getSubject()).isPrimaryIteration(iteration);
    }

    @Function
    public boolean canAddToIteration(IWorkItemType workItemType, IIterationHandle iteration) {
        return ((ResolvedIterationPlan)this.getSubject()).canAdd(workItemType, iteration);
    }

    @Function
    public boolean canAddToCategory(IWorkItemType workItemType, ICategoryHandle category) {
        return ((ResolvedIterationPlan)this.getSubject()).canAdd(workItemType, category);
    }

    @Function
    public IProcessArea getRootTeamMemberArea() {
        if (this.getSubject() instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)this.getSubject()).getTeamMemberArea();
        }
        return null;
    }

    @Function
    public IProcessArea[] getTeamMemberAreas() {
        ItemCollection<IProcessArea> result = this.getSubject().getTeamMemberAreas();
        return (IProcessArea[])result.toArray((Object[])new IProcessArea[result.size()]);
    }

    @Function
    public IProcessArea getTeamMemberArea(ICategoryHandle category) {
        return this.getSubject().getTeamMemberArea(category);
    }

    @Function
    public ICategoryHandle getPrimaryCategoryFor(IProcessArea area) {
        return this.getSubject().getPrimaryCategoryFor(area);
    }

    @Function
    public PlanItem[] getAllPlanItems() {
        Collection<PlanItem> result = this.getSubject().getAllPlanItems();
        return result.toArray(new PlanItem[result.size()]);
    }

    @Function
    public OutOfOfficeItem[] getAbsences() {
        Collection<OutOfOfficeItem> result = this.getSubject().getAbsences();
        return result.toArray(new OutOfOfficeItem[result.size()]);
    }

    @Function
    public IWorkflowInfo getWorkflowInfo(String workflowId) {
        return this.getSubject().getWorkflowInfo(workflowId);
    }

    @Function
    public Object compoundChange(final org.mozilla.javascript.Function code, final Scriptable thisObj) {
        final PlanDeltaBuilder deltaBuilder = this.getSubject().connectDeltaBuilder();
        try {
            IScriptEnvironment scriptEnvironment = IScriptEnvironment.CURRENT.getScriptEnvironment();
            Object object = scriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Object, RuntimeException>(){

                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    return code.call(cx, scope, thisObj, new Object[]{Context.javaToJS((Object)deltaBuilder, (Scriptable)scope)});
                }
            });
            return object;
        }
        finally {
            this.getSubject().disconnectDeltaBuilder();
        }
    }

    @Function
    public ItemSequenceManager getItemSequenceManager(IContributor owner) {
        ResolvedPlan plan = this.getSubject();
        if (plan instanceof ResolvedIterationPlan) {
            return ((ResolvedIterationPlan)plan).getItemSequenceManager((IContributorHandle)owner);
        }
        if (plan instanceof ResolvedPersonalPlan && ((ResolvedPersonalPlan)plan).getPlanOwner().sameItemId((IItemHandle)owner)) {
            return ((ResolvedPersonalPlan)plan).getItemSequenceManager();
        }
        return null;
    }

    @Override
    protected ResolvedPlan getSubject() {
        return (ResolvedPlan)super.getSubject();
    }
}

